/*
 * Decompiled with CFR 0.152.
 */
package gw.examples;

import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLJPanel;
import gov.nasa.worldwind.layers.Layer;
import gw.events.FeatureSelectionListener;
import gw.layers.LayerFactory;
import gw.layers.SimpleFeatureAnnotationLayer;
import gw.layers.SimpleFeatureLayer;
import gw.util.WorldWindUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.opengis.feature.simple.SimpleFeature;

public class ShapeExample
extends JFrame
implements FeatureSelectionListener {
    SimpleFeatureLayer sf;
    SimpleFeatureAnnotationLayer sal;
    private JButton focusButton;
    private JScrollPane jScrollPane1;
    private JSlider opacitySlider;
    private JCheckBox selectionCheckbox;
    private JTextArea textbox;
    private WorldWindowGLJPanel wwpanel;

    public ShapeExample() throws Exception {
        this.initComponents();
        if (this.wwpanel.getModel() == null) {
            this.wwpanel.setModel((Model)WorldWind.createConfigurationComponent((String)"gov.nasa.worldwind.avkey.ModelClassName"));
        }
        this.sf = LayerFactory.fromShapefile(new File("sampledata/hrus_dd polygon/hrus_dd polygon.shp"), (WorldWindow)this.wwpanel);
        this.sf.redraw();
        this.sf.addFeatureSelectionListener(this);
        this.wwpanel.getModel().getLayers().add((Layer)this.sf);
        this.sf.setPickEnabled(false);
    }

    @Override
    public boolean featureSelected(SimpleFeature selected) {
        if (selected != null) {
            String txt = "";
            for (int i = 0; i < selected.getFeatureType().getTypes().size(); ++i) {
                txt = txt + selected.getFeatureType().getType(i).getName().getLocalPart() + ": " + selected.getAttribute(i).toString() + "\n";
            }
            this.textbox.setText(txt);
        }
        return true;
    }

    private void initComponents() {
        this.wwpanel = new WorldWindowGLJPanel();
        this.jScrollPane1 = new JScrollPane();
        this.textbox = new JTextArea();
        this.opacitySlider = new JSlider();
        this.selectionCheckbox = new JCheckBox();
        this.focusButton = new JButton();
        this.setDefaultCloseOperation(3);
        GroupLayout wwpanelLayout = new GroupLayout((Container)this.wwpanel);
        this.wwpanel.setLayout((LayoutManager)wwpanelLayout);
        wwpanelLayout.setHorizontalGroup((GroupLayout.Group)wwpanelLayout.createParallelGroup(1).add(0, 690, Short.MAX_VALUE));
        wwpanelLayout.setVerticalGroup((GroupLayout.Group)wwpanelLayout.createParallelGroup(1).add(0, 471, Short.MAX_VALUE));
        this.textbox.setColumns(20);
        this.textbox.setFont(new Font("SansSerif", 0, 10));
        this.textbox.setRows(5);
        this.jScrollPane1.setViewportView(this.textbox);
        this.opacitySlider.setPaintTicks(true);
        this.opacitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ShapeExample.this.opacitySliderChanged(evt);
            }
        });
        this.selectionCheckbox.setText("Enable Selection");
        this.selectionCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShapeExample.this.selectionCheckboxActionPerformed(evt);
            }
        });
        this.focusButton.setText("Focus Camera");
        this.focusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShapeExample.this.focusButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.wwpanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 567, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.opacitySlider, -2, 117, -2).add((Component)this.selectionCheckbox).add((Component)this.focusButton, -2, 109, -2)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.wwpanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.opacitySlider, -2, -1, -2).addPreferredGap(0).add((Component)this.selectionCheckbox).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.focusButton, -2, 39, -2)).add((Component)this.jScrollPane1, -2, 114, -2)).addContainerGap()));
        this.pack();
    }

    private void focusButtonActionPerformed(ActionEvent evt) {
        WorldWindUtils.flyTo(this.sf.getSector(), (WorldWindow)this.wwpanel);
    }

    private void selectionCheckboxActionPerformed(ActionEvent evt) {
        this.sf.setPickEnabled(this.selectionCheckbox.isSelected());
    }

    private void opacitySliderChanged(ChangeEvent evt) {
        this.sf.setOpacity((double)this.opacitySlider.getValue() / (double)this.opacitySlider.getMaximum());
        this.wwpanel.redrawNow();
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    new ShapeExample().setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

