/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class StructAccessor {
    private final ByteBuffer bb;

    public StructAccessor(ByteBuffer byteBuffer) {
        this.bb = byteBuffer.order(ByteOrder.nativeOrder());
    }

    public final ByteBuffer getBuffer() {
        return this.bb;
    }

    public final ByteBuffer slice(int n, int n2) {
        this.bb.position(n);
        this.bb.limit(n + n2);
        ByteBuffer byteBuffer = this.bb.slice().order(this.bb.order());
        this.bb.position(0);
        this.bb.limit(this.bb.capacity());
        return byteBuffer;
    }

    public final byte getByteAt(int n) {
        return this.bb.get(n);
    }

    public final void setByteAt(int n, byte by) {
        this.bb.put(n, by);
    }

    public final char getCharAt(int n) {
        return this.bb.getChar(n);
    }

    public final void setCharAt(int n, char c) {
        this.bb.putChar(n, c);
    }

    public final short getShortAt(int n) {
        return this.bb.getShort(n);
    }

    public final void setShortAt(int n, short s) {
        this.bb.putShort(n, s);
    }

    public final int getIntAt(int n) {
        return this.bb.getInt(n);
    }

    public final void setIntAt(int n, int n2) {
        this.bb.putInt(n, n2);
    }

    public final int getIntAt(int n, int n2) {
        switch (n2) {
            case 2: {
                return this.bb.getShort(n) & 0xFFFF;
            }
            case 4: {
                return this.bb.getInt(n);
            }
            case 8: {
                return (int)(this.bb.getLong(n) & 0xFFFFFFFFL);
            }
        }
        throw new InternalError("invalid nativeSizeInBytes " + n2);
    }

    public final void setIntAt(int n, int n2, int n3) {
        switch (n3) {
            case 2: {
                this.bb.putShort(n, (short)(n2 & 0xFFFF));
                break;
            }
            case 4: {
                this.bb.putInt(n, n2);
                break;
            }
            case 8: {
                this.bb.putLong(n, (long)n2 & 0xFFFFFFFFL);
                break;
            }
            default: {
                throw new InternalError("invalid nativeSizeInBytes " + n3);
            }
        }
    }

    public final float getFloatAt(int n) {
        return this.bb.getFloat(n);
    }

    public final void setFloatAt(int n, float f) {
        this.bb.putFloat(n, f);
    }

    public final double getDoubleAt(int n) {
        return this.bb.getDouble(n);
    }

    public final void setDoubleAt(int n, double d) {
        this.bb.putDouble(n, d);
    }

    public final long getLongAt(int n) {
        return this.bb.getLong(n);
    }

    public final void setLongAt(int n, long l) {
        this.bb.putLong(n, l);
    }

    public final long getLongAt(int n, int n2) {
        switch (n2) {
            case 4: {
                return (long)this.bb.getInt(n) & 0xFFFFFFFFL;
            }
            case 8: {
                return this.bb.getLong(n);
            }
        }
        throw new InternalError("invalid nativeSizeInBytes " + n2);
    }

    public final void setLongAt(int n, long l, int n2) {
        switch (n2) {
            case 4: {
                this.bb.putInt(n, (int)(l & 0xFFFFFFFFL));
                break;
            }
            case 8: {
                this.bb.putLong(n, l);
                break;
            }
            default: {
                throw new InternalError("invalid nativeSizeInBytes " + n2);
            }
        }
    }

    public final void setBytesAt(int n, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.bb.put(n++, byArray[i]);
        }
    }

    public final byte[] getBytesAt(int n, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.bb.get(n++);
        }
        return byArray;
    }

    public final void setCharsAt(int n, char[] cArray) {
        int n2 = 0;
        while (n2 < cArray.length) {
            this.bb.putChar(n, cArray[n2]);
            ++n2;
            n += 2;
        }
    }

    public final char[] getCharsAt(int n, char[] cArray) {
        int n2 = 0;
        while (n2 < cArray.length) {
            cArray[n2] = this.bb.getChar(n);
            ++n2;
            n += 2;
        }
        return cArray;
    }

    public final void setShortsAt(int n, short[] sArray) {
        int n2 = 0;
        while (n2 < sArray.length) {
            this.bb.putShort(n, sArray[n2]);
            ++n2;
            n += 2;
        }
    }

    public final short[] getShortsAt(int n, short[] sArray) {
        int n2 = 0;
        while (n2 < sArray.length) {
            sArray[n2] = this.bb.getShort(n);
            ++n2;
            n += 2;
        }
        return sArray;
    }

    public final void setIntsAt(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            this.bb.putInt(n, nArray[n2]);
            ++n2;
            n += 4;
        }
    }

    public final int[] getIntsAt(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = this.bb.getInt(n);
            ++n2;
            n += 4;
        }
        return nArray;
    }

    public final void setFloatsAt(int n, float[] fArray) {
        int n2 = 0;
        while (n2 < fArray.length) {
            this.bb.putFloat(n, fArray[n2]);
            ++n2;
            n += 4;
        }
    }

    public final float[] getFloatsAt(int n, float[] fArray) {
        int n2 = 0;
        while (n2 < fArray.length) {
            fArray[n2] = this.bb.getFloat(n);
            ++n2;
            n += 4;
        }
        return fArray;
    }

    public final void setDoublesAt(int n, double[] dArray) {
        int n2 = 0;
        while (n2 < dArray.length) {
            this.bb.putDouble(n, dArray[n2]);
            ++n2;
            n += 8;
        }
    }

    public final double[] getDoublesAt(int n, double[] dArray) {
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = this.bb.getDouble(n);
            ++n2;
            n += 8;
        }
        return dArray;
    }

    public final void setLongsAt(int n, long[] lArray) {
        int n2 = 0;
        while (n2 < lArray.length) {
            this.bb.putLong(n, lArray[n2]);
            ++n2;
            n += 8;
        }
    }

    public final long[] getLongsAt(int n, long[] lArray) {
        int n2 = 0;
        while (n2 < lArray.length) {
            lArray[n2] = this.bb.getLong(n);
            ++n2;
            n += 8;
        }
        return lArray;
    }
}

