/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.interpreter.operations.reflection;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import nl.tudelft.simulation.dsol.interpreter.Frame;
import nl.tudelft.simulation.dsol.interpreter.InterpreterException;
import nl.tudelft.simulation.dsol.interpreter.OperandStack;
import nl.tudelft.simulation.dsol.interpreter.classfile.ConstantInterfaceMethodref;
import nl.tudelft.simulation.dsol.interpreter.operations.InvokeOperation;
import nl.tudelft.simulation.language.primitives.Primitive;
import nl.tudelft.simulation.language.reflection.ClassUtil;
import nl.tudelft.simulation.language.reflection.MethodSignature;

public class INVOKEINTERFACE
extends InvokeOperation {
    public static final int OP = 185;
    protected int index = -1;

    public INVOKEINTERFACE(DataInput dataInput) throws IOException {
        this.index = dataInput.readUnsignedShort();
        dataInput.skipBytes(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Frame execute(Frame frame) {
        try {
            OperandStack operandStack = frame.getOperandStack();
            synchronized (operandStack) {
                Method method = null;
                ConstantInterfaceMethodref constantInterfaceMethodref = (ConstantInterfaceMethodref)frame.getConstantPool()[this.index];
                Class[] parameterTypes = new MethodSignature(constantInterfaceMethodref.getConstantNameAndType().getDescriptor()).getParameterTypes();
                Object objectRef = frame.getOperandStack().peek(parameterTypes.length);
                method = ClassUtil.resolveMethod(objectRef, constantInterfaceMethodref.getConstantNameAndType().getName(), parameterTypes);
                Object[] arguments = new Object[parameterTypes.length];
                for (int i = arguments.length - 1; i > -1; --i) {
                    arguments[i] = Primitive.cast(parameterTypes[i], frame.getOperandStack().pop());
                }
                return this.execute(frame, frame.getOperandStack().pop(), method, arguments);
            }
        }
        catch (Exception exception) {
            throw new InterpreterException(exception);
        }
    }

    public Frame execute(Frame frame, Object objectRef, Method method, Object[] arguments) throws Exception {
        ((AccessibleObject)method).setAccessible(true);
        Object result = null;
        try {
            result = method.invoke(objectRef, arguments);
        }
        catch (Exception exception) {
            frame.getOperandStack().push(exception.getCause());
            throw new InterpreterException("ATHROW created");
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            frame.getOperandStack().push(result);
        }
        return null;
    }

    public int getByteLength() {
        return 5;
    }

    public int getOpcode() {
        return 185;
    }
}

