/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.Iterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class ReTypingIterator
implements Iterator {
    Iterator delegate;
    SimpleFeatureType target;
    AttributeDescriptor[] types;

    public ReTypingIterator(Iterator delegate, SimpleFeatureType source, SimpleFeatureType target) {
        this.delegate = delegate;
        this.target = target;
        this.types = this.typeAttributes(source, target);
    }

    public Iterator getDelegate() {
        return this.delegate;
    }

    public void remove() {
        this.delegate.remove();
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public Object next() {
        SimpleFeature next = (SimpleFeature)this.delegate.next();
        String id = next.getID();
        Object[] attributes = new Object[this.types.length];
        try {
            for (int i = 0; i < this.types.length; ++i) {
                String xpath = this.types[i].getLocalName();
                attributes[i] = next.getAttribute(xpath);
            }
            return SimpleFeatureBuilder.build(this.target, attributes, id);
        }
        catch (IllegalAttributeException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    protected AttributeDescriptor[] typeAttributes(SimpleFeatureType original, SimpleFeatureType target) {
        if (target.equals(original)) {
            throw new IllegalArgumentException("FeatureReader allready produces contents with the correct schema");
        }
        if (target.getAttributeCount() > original.getAttributeCount()) {
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover requested type)");
        }
        AttributeDescriptor[] types = new AttributeDescriptor[target.getAttributeCount()];
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            AttributeDescriptor attrib = target.getDescriptor(i);
            String xpath = attrib.getLocalName();
            types[i] = attrib;
            if (attrib.equals(original.getDescriptor(xpath))) continue;
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover " + xpath + ")");
        }
        return types;
    }
}

