/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForceCoordinateSystemFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    protected FeatureReader<SimpleFeatureType, SimpleFeature> reader;
    protected SimpleFeatureType schema;

    ForceCoordinateSystemFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeatureType schema) {
        this.reader = reader;
        this.schema = schema;
    }

    public ForceCoordinateSystemFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> reader, CoordinateReferenceSystem cs) throws SchemaException {
        this(reader, cs, false);
    }

    public ForceCoordinateSystemFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> reader, CoordinateReferenceSystem cs, boolean forceOnlyMissing) throws SchemaException {
        if (cs == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        SimpleFeatureType type = reader.getFeatureType();
        CoordinateReferenceSystem originalCs = type.getCoordinateReferenceSystem();
        if (!cs.equals(originalCs)) {
            this.schema = FeatureTypes.transform(type, cs, forceOnlyMissing);
        }
        this.reader = reader;
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        if (this.schema == null) {
            return this.reader.getFeatureType();
        }
        return this.schema;
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        SimpleFeature next = this.reader.next();
        if (this.schema == null) {
            return next;
        }
        return SimpleFeatureBuilder.retype(next, this.schema);
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    @Override
    public void close() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        this.reader.close();
        this.reader = null;
        this.schema = null;
    }
}

