/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.geometry;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;

public class FeatureSlidingAverage {
    private final Geometry geometry;

    public FeatureSlidingAverage(Geometry geometry) {
        this.geometry = geometry;
    }

    public List<Coordinate> smooth(int lookAhead, boolean considerZ, double slide) {
        Coordinate tmpCoord;
        int i;
        ArrayList<Coordinate> res = new ArrayList<Coordinate>();
        Coordinate[] coordinates = this.geometry.getCoordinates();
        int n = coordinates.length;
        int half = lookAhead / 2;
        for (int j = 0; j < n; ++j) {
            Coordinate tmp = new Coordinate();
            res.add(tmp);
        }
        if (lookAhead % 2 == 0) {
            throw new IllegalArgumentException("Look ahead parameter must be odd, but you supplied: " + lookAhead);
        }
        if (lookAhead >= n || lookAhead == 1) {
            return null;
        }
        double sc = 1.0 / (double)lookAhead;
        Coordinate pCoord = new Coordinate();
        Coordinate sCoord = new Coordinate();
        this.pointAssign(coordinates, 0, considerZ, pCoord);
        for (i = 1; i < lookAhead; ++i) {
            tmpCoord = new Coordinate();
            this.pointAssign(coordinates, i, considerZ, tmpCoord);
            this.pointAdd(pCoord, tmpCoord, pCoord);
        }
        i = half;
        while (i + half < n) {
            tmpCoord = new Coordinate();
            this.pointAssign(coordinates, i, considerZ, sCoord);
            this.pointScalar(sCoord, 1.0 - slide, sCoord);
            this.pointScalar(pCoord, sc * slide, tmpCoord);
            this.pointAdd(tmpCoord, sCoord, (Coordinate)res.get(i));
            if (i + half + 1 < n) {
                this.pointAssign(coordinates, i - half, considerZ, tmpCoord);
                this.pointSubtract(pCoord, tmpCoord, pCoord);
                this.pointAssign(coordinates, i + half + 1, considerZ, tmpCoord);
                this.pointAdd(pCoord, tmpCoord, pCoord);
            }
            ++i;
        }
        for (i = 0; i < half; ++i) {
            ((Coordinate)res.get((int)i)).x = coordinates[i].x;
            ((Coordinate)res.get((int)i)).y = coordinates[i].y;
            ((Coordinate)res.get((int)i)).z = coordinates[i].z;
        }
        for (i = n - half - 1; i < n; ++i) {
            ((Coordinate)res.get((int)i)).x = coordinates[i].x;
            ((Coordinate)res.get((int)i)).y = coordinates[i].y;
            ((Coordinate)res.get((int)i)).z = coordinates[i].z;
        }
        for (Coordinate coordinate : res) {
            if (coordinate.x != 0.0) continue;
            System.out.println();
        }
        return res;
    }

    private void pointAssign(Coordinate[] coordinates, int index, boolean considerZ, Coordinate newAssignedCoordinate) {
        Coordinate coordinate = coordinates[index];
        newAssignedCoordinate.x = coordinate.x;
        newAssignedCoordinate.y = coordinate.y;
        newAssignedCoordinate.z = considerZ ? coordinate.z : 0.0;
    }

    private void pointAdd(Coordinate a, Coordinate b, Coordinate res) {
        res.x = a.x + b.x;
        res.y = a.y + b.y;
        res.z = a.z + b.z;
    }

    private void pointSubtract(Coordinate a, Coordinate b, Coordinate res) {
        res.x = a.x - b.x;
        res.y = a.y - b.y;
        res.z = a.z - b.z;
    }

    private void pointScalar(Coordinate a, double k, Coordinate res) {
        res.x = a.x * k;
        res.y = a.y * k;
        res.z = a.z * k;
    }
}

