/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.utils.clustering;

import java.util.Arrays;
import org.jgrasstools.gears.utils.clustering.GvmClusterPair;
import org.jgrasstools.gears.utils.clustering.GvmSpace;

class GvmClusterPairs<S extends GvmSpace, K> {
    private GvmClusterPair<S, K>[] pairs;
    private int size;

    GvmClusterPairs(int initialCapacity) {
        this.pairs = new GvmClusterPair[initialCapacity];
        this.size = 0;
    }

    GvmClusterPairs(GvmClusterPairs<S, K> that) {
        this.pairs = Arrays.copyOf(that.pairs, that.size);
        this.size = this.pairs.length;
    }

    public boolean add(GvmClusterPair<S, K> e) {
        if (e == null) {
            throw new IllegalArgumentException("null pair");
        }
        int i = this.size;
        if (i >= this.pairs.length) {
            this.grow(i + 1);
        }
        this.size = i + 1;
        if (i == 0) {
            this.pairs[0] = e;
            e.index = 0;
        } else {
            this.heapifyUp(i, e);
        }
        return true;
    }

    public GvmClusterPair<S, K> peek() {
        return this.size == 0 ? null : this.pairs[0];
    }

    public boolean remove(GvmClusterPair<S, K> pair) {
        int i = this.indexOf(pair);
        if (i == -1) {
            return false;
        }
        this.removeAt(i);
        return true;
    }

    public void reprioritize(GvmClusterPair<S, K> pair) {
        GvmClusterPair<S, K> parent;
        int i = this.indexOf(pair);
        if (i == -1) {
            throw new IllegalArgumentException("no such pair");
        }
        pair.update();
        GvmClusterPair<S, K> gvmClusterPair = parent = i == 0 ? null : this.pairs[i - 1 >>> 1];
        if (parent != null && parent.value > pair.value) {
            this.heapifyUp(i, pair);
        } else {
            this.heapifyDown(i, pair);
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            GvmClusterPair<S, K> e = this.pairs[i];
            e.index = -1;
            this.pairs[i] = e;
        }
        this.size = 0;
    }

    private void grow(int minCapacity) {
        int newCapacity;
        if (minCapacity < 0) {
            throw new IllegalStateException("can't grow, maximum number of elements exceeded");
        }
        int oldCapacity = this.pairs.length;
        int n = newCapacity = oldCapacity < 64 ? (oldCapacity + 1) * 2 : oldCapacity / 2 * 3;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        }
        if (newCapacity < minCapacity) {
            newCapacity = minCapacity;
        }
        this.pairs = Arrays.copyOf(this.pairs, newCapacity);
    }

    private int indexOf(GvmClusterPair<S, K> pair) {
        return pair == null ? -1 : pair.index;
    }

    private GvmClusterPair<S, K> removeAt(int i) {
        int s;
        if ((s = --this.size) == i) {
            this.pairs[i].index = -1;
            this.pairs[i] = null;
        } else {
            GvmClusterPair<S, K> moved = this.pairs[s];
            this.pairs[s] = null;
            moved.index = -1;
            this.heapifyDown(i, moved);
            if (this.pairs[i] == moved) {
                this.heapifyUp(i, moved);
                if (this.pairs[i] != moved) {
                    return moved;
                }
            }
        }
        return null;
    }

    private void heapifyUp(int k, GvmClusterPair<S, K> pair) {
        while (k > 0) {
            int parent = k - 1 >>> 1;
            GvmClusterPair<S, K> e = this.pairs[parent];
            if (pair.value >= e.value) break;
            this.pairs[k] = e;
            e.index = k;
            k = parent;
        }
        this.pairs[k] = pair;
        pair.index = k;
    }

    private void heapifyDown(int k, GvmClusterPair<S, K> pair) {
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            GvmClusterPair<S, K> c = this.pairs[child];
            int right = child + 1;
            if (right < this.size && c.value > this.pairs[right].value) {
                child = right;
                c = this.pairs[child];
            }
            if (pair.value <= c.value) break;
            this.pairs[k] = c;
            c.index = k;
            k = child;
        }
        this.pairs[k] = pair;
        pair.index = k;
    }
}

