/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.vectoroperations;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import java.util.ArrayList;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.features.FeatureGeometrySubstitutor;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="A module that performs a buffer operation on a vector layer.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="JTS, OmsBuffer")
@Label(value="Vector Processing")
@Name(value="vbuffer")
@Status(value=5)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsBuffer
extends JGTModel {
    @Description(value="The input vector map.")
    @In
    public SimpleFeatureCollection inMap = null;
    @Description(value="The buffer distance.")
    @In
    public double pBuffer = 10.0;
    @Description(value="Flag to toggle singlesided buffer.")
    @In
    public boolean doSinglesided = false;
    @Description(value="The join style to use.")
    @UI(value="combo:round,mitre,bevel")
    @In
    public String pJoinstyle = "round";
    @Description(value="The cap style to use.")
    @UI(value="combo:round,flat,square")
    @In
    public String pCapstyle = "round";
    @Description(value="The buffered vector map.")
    @Out
    public SimpleFeatureCollection outMap = null;
    private double mitreLimit = 5.0;
    private int quadrantSegments = 8;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inMap);
        int joinStyle = this.pJoinstyle.equals("mitre") ? 2 : (this.pJoinstyle.equals("bevel") ? 3 : 1);
        int endCapStyle = this.pCapstyle.equals("flat") ? 2 : (this.pCapstyle.equals("square") ? 3 : 1);
        FeatureGeometrySubstitutor fgs = new FeatureGeometrySubstitutor((SimpleFeatureType)this.inMap.getSchema(), MultiPolygon.class);
        DefaultFeatureCollection outMaptmp = new DefaultFeatureCollection("new", fgs.getNewFeatureType());
        GeometryFactory gf = GeometryUtilities.gf();
        List<SimpleFeature> featuresList = FeatureUtilities.featureCollectionToList(this.inMap);
        this.pm.beginTask("Buffering geometries...", featuresList.size());
        for (SimpleFeature feature : featuresList) {
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            BufferParameters bP = new BufferParameters(this.quadrantSegments, endCapStyle, joinStyle, this.mitreLimit);
            Geometry bufferedGeom = BufferOp.bufferOp((Geometry)geometry, (double)this.pBuffer, (BufferParameters)bP);
            ArrayList<Polygon> polygons = new ArrayList<Polygon>(bufferedGeom.getNumGeometries());
            for (int i = 0; i < bufferedGeom.getNumGeometries(); ++i) {
                Geometry geometryN = bufferedGeom.getGeometryN(i);
                if (geometryN instanceof Polygon) {
                    polygons.add((Polygon)geometryN);
                    continue;
                }
                this.pm.errorMessage("Ignored non polygonal geometry in: " + geometryN.toText());
            }
            MultiPolygon multiPolygon = gf.createMultiPolygon(polygons.toArray(GeometryUtilities.TYPE_POLYGON));
            SimpleFeature newFeature = fgs.substituteGeometry(feature, (Geometry)multiPolygon);
            outMaptmp.add(newFeature);
            this.pm.worked(1);
        }
        this.pm.done();
        this.outMap = outMaptmp;
    }
}

