/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.v.polygonize;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.jgrasstools.gears.libs.exceptions.ModelsIllegalargumentException;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryType;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@Description(value="Polygonizes a layer of lines.")
@Documentation(value="")
@Author(name="Antonio Falciano, Andrea Antonello", contact="afalciano@yahoo.it, http://blog.spaziogis.it/, http://www.hydrologis.com")
@Keywords(value="Vector, Polygonize")
@Label(value="Vector Processing")
@Name(value="linespolygonizer")
@Status(value=10)
@License(value="http://www.gnu.org/licenses/gpl-3.0.html")
public class OmsLinesPolygonizer
extends JGTModel {
    @Description(value="The map of lines to polygonize.")
    @In
    public SimpleFeatureCollection inMap = null;
    @Description(value="The map of points containing the id to put in the polygons attributes (optional).")
    @In
    public SimpleFeatureCollection inPoints = null;
    @Description(value="The field of the points layer containing the id for the polygons (necessary if inPoints is defined).")
    @In
    public String fId = null;
    @Description(value="The field of the polygonized layer containing the id (default is 'id').")
    @In
    public String fNewId = "id";
    @Description(value="The map of polygons.")
    @Out
    public SimpleFeatureCollection outMap = null;

    @Execute
    public void process() throws Exception {
        this.checkNull(this.inMap);
        this.outMap = new DefaultFeatureCollection();
        GeometryType geometryType = GeometryUtilities.getGeometryType(((SimpleFeatureType)this.inMap.getSchema()).getGeometryDescriptor().getType());
        switch (geometryType) {
            case LINE: 
            case MULTILINE: {
                break;
            }
            default: {
                throw new ModelsIllegalargumentException("The module only works with line layers.", this, this.pm);
            }
        }
        List<Geometry> linesList = FeatureUtilities.featureCollectionToGeometriesList(this.inMap, true, null);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(linesList);
        Collection polygonizedLines = polygonizer.getPolygons();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("polygonized");
        b.setCRS(((SimpleFeatureType)this.inMap.getSchema()).getCoordinateReferenceSystem());
        b.add("the_geom", Polygon.class);
        b.add(this.fNewId, String.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        List<Object> pointGeometries = new ArrayList();
        if (this.inPoints != null) {
            this.fId = FeatureUtilities.findAttributeName((SimpleFeatureType)this.inPoints.getSchema(), this.fId);
            pointGeometries = FeatureUtilities.featureCollectionToGeometriesList(this.inPoints, false, this.fId);
        }
        this.pm.beginTask("Generating polygon features...", polygonizedLines.size());
        int index = 0;
        for (Polygon polygon : polygonizedLines) {
            String attribute = String.valueOf(index++);
            if (this.inPoints != null) {
                attribute = "-";
                for (Geometry geometry : pointGeometries) {
                    if (!polygon.contains(geometry)) continue;
                    attribute = geometry.getUserData().toString();
                    break;
                }
            }
            Object[] values = new Object[]{polygon, attribute};
            builder.addAll(values);
            SimpleFeature simpleFeature = builder.buildFeature(null);
            ((DefaultFeatureCollection)this.outMap).add(simpleFeature);
            this.pm.worked(1);
        }
        this.pm.done();
    }
}

