/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.modules.r.transformer;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.util.HashMap;
import javax.media.jai.Interpolation;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.RotateDescriptor;
import javax.media.jai.operator.ScaleDescriptor;
import javax.media.jai.operator.TranslateDescriptor;
import javax.media.jai.operator.TransposeDescriptor;
import javax.media.jai.operator.TransposeType;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import oms3.annotations.UI;
import oms3.annotations.Unit;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.jgrasstools.gears.libs.modules.JGTModel;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.jgrasstools.gears.utils.features.FeatureUtilities;
import org.jgrasstools.gears.utils.geometry.GeometryUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

@Description(value="Module for raster tranforms.")
@Documentation(value="")
@Author(name="Andrea Antonello", contact="www.hydrologis.com")
@Keywords(value="Transform, Raster")
@Label(value="Raster Processing")
@Name(value="rtrans")
@Status(value=10)
@License(value="General Public License Version 3 (GPLv3)")
public class OmsRasterTransformer
extends JGTModel {
    @Description(value="The raster that has to be transformed.")
    @In
    public GridCoverage2D inRaster;
    @Description(value="The interpolation type to use")
    @UI(value="combo:nearest neightbour,bilinear,bicubic")
    @In
    public String pInterpolation = "nearest neightbour";
    @Description(value="The translation along the X axis.")
    @Unit(value="m")
    @In
    public Double pTransX;
    @Description(value="The translation along the Y axis.")
    @Unit(value="m")
    @In
    public Double pTransY;
    @Description(value="The scale factor along X axis.")
    @In
    public Double pScaleX;
    @Description(value="The scale factor along the Y axis.")
    @In
    public Double pScaleY;
    @Description(value="Flip horizontally.")
    @In
    public boolean doFlipHorizontal;
    @Description(value="Flip vertically.")
    @In
    public boolean doFlipVertical;
    @Description(value="The northern coordinate of the rotation point.")
    @UI(value="northing")
    @In
    public Double pNorth;
    @Description(value="The eastern coordinate of the rotation point.")
    @UI(value="easting")
    @In
    public Double pEast;
    @Description(value="The rotation angle in degree (rotation is performed before translation).")
    @Unit(value="degrees")
    @In
    public Double pAngle;
    @Description(value="The transformed raster.")
    @Out
    public GridCoverage2D outRaster = null;
    @Description(value="The new raster geometry.")
    @Out
    public SimpleFeatureCollection outBounds = null;

    @Execute
    public void process() throws Exception {
        Envelope jtsEnv;
        if (!this.concatOr(this.outRaster == null, this.doReset)) {
            return;
        }
        Interpolation interpolation = Interpolation.getInstance((int)0);
        if (this.pInterpolation.equals("bilinear")) {
            interpolation = Interpolation.getInstance((int)1);
        } else if (this.pInterpolation.equals("bicubic")) {
            interpolation = Interpolation.getInstance((int)2);
        }
        RenderedImage inRasterRI = this.inRaster.getRenderedImage();
        RegionMap sourceRegion = CoverageUtilities.gridGeometry2RegionParamsMap(this.inRaster.getGridGeometry());
        Envelope2D envelope2d = this.inRaster.getEnvelope2D();
        Envelope targetEnvelope = new Envelope(envelope2d.getMinX(), envelope2d.getMaxX(), envelope2d.getMinY(), envelope2d.getMaxY());
        Geometry targetGeometry = null;
        GeometryFactory gf = GeometryUtilities.gf();
        RenderedOp finalImg = null;
        if (this.pAngle != null) {
            this.pm.beginTask("Rotate raster by angle: " + this.pAngle, -1);
            float centerX = 0.0f;
            float centerY = 0.0f;
            centerX = this.pEast == null ? (float)envelope2d.getCenterX() : this.pEast.floatValue();
            centerY = this.pNorth == null ? (float)envelope2d.getCenterY() : this.pNorth.floatValue();
            finalImg = RotateDescriptor.create((RenderedImage)inRasterRI, (Float)Float.valueOf(centerX), (Float)Float.valueOf(centerY), (Float)Float.valueOf((float)Math.toRadians(this.pAngle)), (Interpolation)interpolation, null, null);
            AffineTransform rotationAT = new AffineTransform();
            rotationAT.translate(centerX, centerY);
            rotationAT.rotate(Math.toRadians(-this.pAngle.doubleValue()));
            rotationAT.translate(-centerX, -centerY);
            AffineTransform2D rotationTransform = new AffineTransform2D(rotationAT);
            jtsEnv = new Envelope(targetEnvelope.getMinX(), targetEnvelope.getMaxX(), targetEnvelope.getMinY(), targetEnvelope.getMaxY());
            targetEnvelope = JTS.transform((Envelope)jtsEnv, (MathTransform)rotationTransform);
            Geometry rotGeometry = gf.toGeometry(jtsEnv);
            targetGeometry = JTS.transform((Geometry)rotGeometry, (MathTransform)rotationTransform);
            this.pm.done();
        }
        if (this.doFlipHorizontal) {
            this.pm.beginTask("Flip horizontally...", -1);
            finalImg = finalImg != null ? TransposeDescriptor.create(finalImg, (TransposeType)TransposeDescriptor.FLIP_HORIZONTAL, null) : TransposeDescriptor.create((RenderedImage)inRasterRI, (TransposeType)TransposeDescriptor.FLIP_HORIZONTAL, null);
            Envelope jtsEnv2 = new Envelope(targetEnvelope.getMinX(), targetEnvelope.getMaxX(), targetEnvelope.getMinY(), targetEnvelope.getMaxY());
            targetGeometry = gf.toGeometry(jtsEnv2);
            this.pm.done();
        }
        if (this.doFlipVertical) {
            this.pm.beginTask("Flip vertically...", -1);
            finalImg = finalImg != null ? TransposeDescriptor.create((RenderedImage)finalImg, (TransposeType)TransposeDescriptor.FLIP_VERTICAL, null) : TransposeDescriptor.create((RenderedImage)inRasterRI, (TransposeType)TransposeDescriptor.FLIP_VERTICAL, null);
            Envelope jtsEnv3 = new Envelope(targetEnvelope.getMinX(), targetEnvelope.getMaxX(), targetEnvelope.getMinY(), targetEnvelope.getMaxY());
            targetGeometry = gf.toGeometry(jtsEnv3);
            this.pm.done();
        }
        if (this.pScaleX != null || this.pScaleY != null) {
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            scaleX = this.pScaleX == null ? 1.0f : this.pScaleX.floatValue();
            scaleY = this.pScaleY == null ? 1.0f : this.pScaleY.floatValue();
            this.pm.beginTask("Scale raster by: " + scaleX + " and " + scaleY, -1);
            finalImg = finalImg != null ? ScaleDescriptor.create((RenderedImage)finalImg, (Float)new Float(scaleX), (Float)new Float(scaleY), (Float)new Float(0.0f), (Float)new Float(0.0f), (Interpolation)interpolation, null) : ScaleDescriptor.create((RenderedImage)inRasterRI, (Float)new Float(scaleX), (Float)new Float(scaleY), (Float)new Float(0.0f), (Float)new Float(0.0f), (Interpolation)interpolation, null);
            AffineTransform scaleAT = new AffineTransform();
            scaleAT.scale(scaleX, scaleY);
            AffineTransform2D scaleTransform = new AffineTransform2D(scaleAT);
            jtsEnv = new Envelope(targetEnvelope.getMinX(), targetEnvelope.getMaxX(), targetEnvelope.getMinY(), targetEnvelope.getMaxY());
            targetEnvelope = JTS.transform((Envelope)jtsEnv, (MathTransform)scaleTransform);
            Geometry scaledGeometry = gf.toGeometry(jtsEnv);
            targetGeometry = JTS.transform((Geometry)scaledGeometry, (MathTransform)scaleTransform);
            this.pm.done();
        }
        if (this.pTransX != null || this.pTransY != null) {
            float transX = 1.0f;
            float transY = 1.0f;
            transX = this.pTransX == null ? 1.0f : this.pTransX.floatValue();
            transY = this.pTransY == null ? 1.0f : this.pTransY.floatValue();
            this.pm.beginTask("Translate raster by: " + transX + " and " + transY, -1);
            finalImg = finalImg != null ? TranslateDescriptor.create((RenderedImage)finalImg, (Float)Float.valueOf(transX), (Float)Float.valueOf(transY), (Interpolation)interpolation, null) : TranslateDescriptor.create((RenderedImage)inRasterRI, (Float)Float.valueOf(transX), (Float)Float.valueOf(transY), (Interpolation)interpolation, null);
            AffineTransform translationAT = new AffineTransform();
            translationAT.translate(transX, transY);
            AffineTransform2D translateTransform = new AffineTransform2D(translationAT);
            if (targetGeometry == null) {
                targetGeometry = gf.toGeometry(targetEnvelope);
            }
            targetEnvelope = JTS.transform((Envelope)targetEnvelope, (MathTransform)translateTransform);
            targetGeometry = JTS.transform((Geometry)targetGeometry, (MathTransform)translateTransform);
            this.pm.done();
        }
        if (finalImg != null) {
            RegionMap targetRegion = new RegionMap();
            targetRegion.put("NORTH", targetEnvelope.getMaxY());
            targetRegion.put("SOUTH", targetEnvelope.getMinY());
            targetRegion.put("WEST", targetEnvelope.getMinX());
            targetRegion.put("EAST", targetEnvelope.getMaxX());
            targetRegion.put("XRES", sourceRegion.getXres());
            targetRegion.put("YRES", sourceRegion.getYres());
            CoordinateReferenceSystem crs = this.inRaster.getCoordinateReferenceSystem();
            this.outRaster = CoverageUtilities.buildCoverage("out", (RenderedImage)finalImg, (HashMap<String, Double>)targetRegion, crs);
            this.outBounds = FeatureUtilities.featureCollectionFromGeometry(crs, targetGeometry);
        }
        this.pm.done();
    }
}

