/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.grasslegacy.map.color;

import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Vector;
import org.jgrasstools.gears.io.grasslegacy.map.color.ColorRule;

public abstract class ColorTable {
    public static final byte[] blank = new byte[]{0, 0, 0, 0};
    protected Color backgroundColor = new Color(0, 0, 0, 0);
    protected static final int FIXED_COLORMAP = 1;
    protected static final int GRADIENT_COLORMAP = 2;
    protected boolean colorTableEmpty = false;
    protected Vector<ColorRule> rules = new Vector();

    public Enumeration<ColorRule> getColorRules() {
        return this.rules.elements();
    }

    public int size() {
        return this.rules.size();
    }

    public void setBackgroundColor(Color clr) {
        this.backgroundColor = clr;
    }

    public boolean isEmpty() {
        return this.colorTableEmpty;
    }

    protected void addColorRule(int cat, int r, int g, int b) {
        this.insertRule(cat, new ColorRule(cat, r, g, b));
    }

    protected void addColorRule(float cat0, int r0, int g0, int b0, float cat1, int r1, int g1, int b1) {
        this.insertRule(cat0, new ColorRule(cat0, r0, g0, b0, cat1, r1, g1, b1));
    }

    public ByteBuffer interpolateColorMap(int mapType, ByteBuffer data, int dataOffset) {
        ByteBuffer cmapBuffer;
        block4: {
            block5: {
                block3: {
                    int dataLength = data.capacity() - dataOffset;
                    cmapBuffer = ByteBuffer.allocate(dataLength);
                    data.position(dataOffset);
                    if (mapType <= 0) break block3;
                    while (data.hasRemaining()) {
                        int f = data.getInt();
                        cmapBuffer.put(f == Integer.MAX_VALUE ? blank : this.getColor(f));
                    }
                    break block4;
                }
                if (mapType != -1) break block5;
                while (data.hasRemaining()) {
                    float f = data.getFloat();
                    cmapBuffer.put(Float.isNaN(f) ? blank : this.getColor(f));
                }
                break block4;
            }
            if (mapType != -2) break block4;
            while (data.hasRemaining()) {
                float f = (float)data.getDouble();
                cmapBuffer.put(Float.isNaN(f) ? blank : this.getColor(f));
            }
        }
        return cmapBuffer;
    }

    public void interpolateColorValue(ByteBuffer cmapBuffer, int cell) {
        cmapBuffer.put(cell == Integer.MAX_VALUE ? blank : this.getColor(cell));
    }

    public void interpolateColorValue(ByteBuffer cmapBuffer, float cell) {
        cmapBuffer.put(Float.isNaN(cell) ? blank : this.getColor(cell));
    }

    public void interpolateColorValue(ByteBuffer cmapBuffer, double cell) {
        cmapBuffer.put(Float.isNaN((float)cell) ? blank : this.getColor((float)cell));
    }

    public void insertRule(float cat, ColorRule newrule) {
        int i = 0;
        int low = 0;
        int high = this.rules.size() - 1;
        while (low <= high) {
            i = (low + high) / 2;
            ColorRule crule = this.rules.elementAt(i);
            int c = crule.compare(cat);
            if (c == 0) {
                ++i;
                low = high + 1;
                continue;
            }
            if (c < 0) {
                high = i - 1;
                continue;
            }
            low = i++ + 1;
        }
        this.rules.insertElementAt(newrule, i);
    }

    private ColorRule get(float cat) {
        int low = 0;
        int high = this.rules.size() - 1;
        while (low <= high) {
            int i = (low + high) / 2;
            ColorRule crule = this.rules.elementAt(i);
            int c = crule.compare(cat);
            if (c == 0) {
                return crule;
            }
            if (c < 0) {
                high = i - 1;
                continue;
            }
            low = i++ + 1;
        }
        return null;
    }

    public byte[] getColor(float x) {
        ColorRule crule = this.get(x);
        return crule == null ? blank : crule.getColor(x);
    }

    public void createDefaultColorTable(double[] dataRange) {
    }

    public int getAlpha() {
        return 255;
    }
}

