/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.grasslegacy.io;

import java.io.IOException;
import java.util.Vector;
import org.jgrasstools.gears.io.grasslegacy.map.color.ColorMapBuffer;
import org.jgrasstools.gears.io.grasslegacy.map.color.ColorTable;
import org.jgrasstools.gears.io.grasslegacy.utils.Window;
import org.jgrasstools.gears.libs.monitor.IJGTProgressMonitor;

public abstract class MapReader {
    public static final int RASTER_READER = 1;
    public static final int VECTOR_READER = 2;
    public static final int POINT_READER = 3;
    public static final String FEATURECOLLECTION = "featurecollection";
    public static final int COLOR = 1;
    public static final int DATA = 1;
    protected Window fileWindow = null;
    protected Window dataWindow = null;
    protected ColorTable colorTable = null;
    protected Object dataObject = null;
    protected int readerType = 0;

    public MapReader(int _readerType) {
        this.readerType = _readerType;
    }

    public void setReaderType(int readerType) {
        this.readerType = readerType;
    }

    public int getReaderType() {
        return this.readerType;
    }

    public abstract void close();

    public void setOutputDataObject(Object outputDataObject) {
        this.dataObject = outputDataObject;
        if (outputDataObject instanceof Vector && ((Vector)outputDataObject).capacity() == 0) {
            this.dataObject = new Vector();
        }
    }

    public Object getOutputDataObject() {
        return this.dataObject;
    }

    public ColorTable getColorTable() {
        return this.colorTable;
    }

    public Window getMapWindow() {
        return new Window(this.fileWindow);
    }

    public Window getDataWindow() {
        return new Window(this.dataWindow);
    }

    public void setDataWindow(Window window) {
        this.dataWindow = window;
    }

    public void setParameter(String key, Object obj) {
    }

    public Object getParameter(String key, Object obj) {
        return obj;
    }

    public abstract boolean open(String var1, String var2, String var3);

    public abstract boolean open(String var1);

    public abstract boolean hasMoreData(IJGTProgressMonitor var1) throws Exception;

    public abstract Object getNextData();

    public abstract ColorMapBuffer getNextDataColor(int var1);

    public abstract String getLegendString() throws IOException;

    public abstract double[] getRange();
}

