/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.geopaparazzi.forms.items;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrasstools.gears.io.geopaparazzi.forms.items.Item;

public class ItemConnectedCombo
implements Item {
    private String description;
    private boolean isMandatory;
    private String defaultValue;
    private LinkedHashMap<String, List<String>> dataMap;

    public ItemConnectedCombo(String description, LinkedHashMap<String, List<String>> dataMap, String defaultValue, boolean isMandatory) {
        this.dataMap = dataMap;
        if (defaultValue == null) {
            defaultValue = "";
        }
        this.description = description;
        this.defaultValue = defaultValue;
        this.isMandatory = isMandatory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("        {\n");
        sb.append("             \"key\": \"").append(this.description).append("\",\n");
        sb.append("             \"values\": {\n");
        StringBuilder tmp = new StringBuilder();
        Set<Map.Entry<String, List<String>>> entrySet = this.dataMap.entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            String itemName = entry.getKey();
            List<String> items = entry.getValue();
            tmp.append("                 \"" + itemName + "\": [\n");
            StringBuilder tmp2 = new StringBuilder();
            for (String itemString : items) {
                tmp2.append("                     {\"item\": \"" + itemString + "\"},\n");
            }
            String substring = this.removeLastComma(tmp2);
            tmp.append(substring).append("\n");
            tmp.append("                 ],\n");
        }
        String substring = this.removeLastComma(tmp);
        sb.append(substring).append("\n");
        sb.append("             },\n");
        sb.append("             \"value\": \"").append(this.defaultValue).append("\",\n");
        sb.append("             \"type\": \"").append("connectedstringcombo").append("\",\n");
        sb.append("             \"mandatory\": \"").append(this.isMandatory ? "yes" : "no").append("\"\n");
        sb.append("        }\n");
        return sb.toString();
    }

    private String removeLastComma(StringBuilder tmp) {
        String tmpStr = tmp.toString();
        int lastIndexOf = tmpStr.lastIndexOf(44);
        String substring = tmp.substring(0, lastIndexOf);
        return substring;
    }

    @Override
    public String getKey() {
        return this.description;
    }

    @Override
    public void setValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public String getValue() {
        return this.defaultValue;
    }
}

