/*
 * Decompiled with CFR 0.152.
 */
package org.jgrasstools.gears.io.dxfdwg.libs;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.Point2D;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgArc;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgAttrib;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgCircle;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgLine;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgLwPolyline;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgMText;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgPoint;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgPolyline2D;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgPolyline3D;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgSolid;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.objects.DwgText;
import org.jgrasstools.gears.io.dxfdwg.libs.dwg.utils.GisModelCurveCalculator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryTranslator {
    private static GeometryFactory gF = new GeometryFactory();
    private final CoordinateReferenceSystem crs;

    public GeometryTranslator(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public SimpleFeature convertDwgMText(String typeName, String layerName, DwgMText text, int id) {
        double[] p = text.getInsertionPoint();
        Point2D.Double pto = new Point2D.Double(p[0], p[1]);
        Coordinate coord = new Coordinate(((Point2D)pto).getX(), ((Point2D)pto).getY(), 0.0);
        String textString = text.getText();
        return this.createPointTextFeature(typeName, layerName, id, coord, textString);
    }

    public SimpleFeature convertDwgText(String typeName, String layerName, DwgText text, int id) {
        Point2D pto = text.getInsertionPoint();
        Coordinate coord = new Coordinate(pto.getX(), pto.getY(), 0.0);
        String textString = text.getText();
        return this.createPointTextFeature(typeName, layerName, id, coord, textString);
    }

    public SimpleFeature convertDwgAttribute(String typeName, String layerName, DwgAttrib attribute, int id) {
        Point2D pto = attribute.getInsertionPoint();
        Coordinate coord = new Coordinate(pto.getX(), pto.getY(), attribute.getElevation());
        String textString = attribute.getText();
        return this.createPointTextFeature(typeName, layerName, id, coord, textString);
    }

    private SimpleFeature createPointTextFeature(String typeName, String layerName, int id, Coordinate coord, String textString) {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(typeName);
        b.setCRS(this.crs);
        b.add("the_geom", Point.class);
        b.add("text", String.class);
        b.add("layer", String.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        Point point = gF.createPoint(coord);
        Object[] values = new Object[]{point, textString, layerName};
        builder.addAll(values);
        SimpleFeature feature = builder.buildFeature(typeName + "." + id);
        return feature;
    }

    public SimpleFeature convertDwgPolyline3D(String typeName, String layerName, DwgPolyline3D polyline3d, int id) {
        double[][] ptos = polyline3d.getPts();
        CoordinateList coordList = new CoordinateList();
        if (ptos != null) {
            for (int j = 0; j < ptos.length; ++j) {
                Coordinate coord = new Coordinate(ptos[j][0], ptos[j][1], ptos[j][2]);
                coordList.add((Object)coord);
            }
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName(typeName);
            b.setCRS(this.crs);
            b.add("the_geom", LineString.class);
            b.add("layer", String.class);
            SimpleFeatureType type = b.buildFeatureType();
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
            LineString lineString = gF.createLineString(coordList.toCoordinateArray());
            Object[] values = new Object[]{lineString, layerName};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(typeName + "." + id);
            return feature;
        }
        return null;
    }

    public SimpleFeature convertDwgPolyline2D(String typeName, String layerName, DwgPolyline2D polyline2d, int id) {
        Point2D[] ptos = polyline2d.getPts();
        CoordinateList coordList = new CoordinateList();
        if (ptos != null) {
            for (int j = 0; j < ptos.length; ++j) {
                Coordinate coord = new Coordinate(ptos[j].getX(), ptos[j].getY(), 0.0);
                coordList.add((Object)coord);
            }
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName(typeName);
            b.setCRS(this.crs);
            b.add("the_geom", LineString.class);
            b.add("layer", String.class);
            SimpleFeatureType type = b.buildFeatureType();
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
            LineString lineString = gF.createLineString(coordList.toCoordinateArray());
            Object[] values = new Object[]{lineString, layerName};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(typeName + "." + id);
            return feature;
        }
        return null;
    }

    public SimpleFeature convertDwgLwPolyline(String typeName, String layerName, DwgLwPolyline lwPolyline, int id) {
        Point2D[] ptos = lwPolyline.getVertices();
        if (ptos != null) {
            CoordinateList coordList = new CoordinateList();
            for (int j = 0; j < ptos.length; ++j) {
                Coordinate coord = new Coordinate(ptos[j].getX(), ptos[j].getY(), 0.0);
                coordList.add((Object)coord);
            }
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName(typeName);
            b.setCRS(this.crs);
            b.add("the_geom", LineString.class);
            b.add("layer", String.class);
            SimpleFeatureType type = b.buildFeatureType();
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
            LineString lineString = gF.createLineString(coordList.toCoordinateArray());
            Object[] values = new Object[]{lineString, layerName};
            builder.addAll(values);
            SimpleFeature feature = builder.buildFeature(typeName + "." + id);
            return feature;
        }
        return null;
    }

    public SimpleFeature convertDwgPoint(String typeName, String layerName, DwgPoint point, int id) {
        double[] p = point.getPoint();
        Point2D.Double pto = new Point2D.Double(p[0], p[1]);
        CoordinateList coordList = new CoordinateList();
        Coordinate coord = new Coordinate(((Point2D)pto).getX(), ((Point2D)pto).getY(), 0.0);
        coordList.add((Object)coord);
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(typeName);
        b.setCRS(this.crs);
        b.add("the_geom", MultiPoint.class);
        b.add("layer", String.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        MultiPoint points = gF.createMultiPoint(coordList.toCoordinateArray());
        Object[] values = new Object[]{points, layerName};
        builder.addAll(values);
        SimpleFeature feature = builder.buildFeature(typeName + "." + id);
        return feature;
    }

    public SimpleFeature convertDwgLine(String typeName, String layerName, DwgLine line, int id) {
        double[] p1 = line.getP1();
        double[] p2 = line.getP2();
        Point2D[] ptos = new Point2D[]{new Point2D.Double(p1[0], p1[1]), new Point2D.Double(p2[0], p2[1])};
        CoordinateList coordList = new CoordinateList();
        for (int j = 0; j < ptos.length; ++j) {
            Coordinate coord = new Coordinate(ptos[j].getX(), ptos[j].getY(), 0.0);
            coordList.add((Object)coord);
        }
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(typeName);
        b.setCRS(this.crs);
        b.add("the_geom", LineString.class);
        b.add("layer", String.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        LineString lineString = gF.createLineString(coordList.toCoordinateArray());
        Object[] values = new Object[]{lineString, layerName};
        builder.addAll(values);
        SimpleFeature feature = builder.buildFeature(typeName + "." + id);
        return feature;
    }

    public SimpleFeature convertDwgCircle(String typeName, String layerName, DwgCircle circle, int id) {
        double[] center = circle.getCenter();
        double radius = circle.getRadius();
        Point2D[] ptos = GisModelCurveCalculator.calculateGisModelCircle(new Point2D.Double(center[0], center[1]), radius);
        CoordinateList coordList = new CoordinateList();
        for (int j = 0; j < ptos.length; ++j) {
            Coordinate coord = new Coordinate(ptos[j].getX(), ptos[j].getY(), 0.0);
            coordList.add((Object)coord);
        }
        if (ptos[ptos.length - 1].getX() != ptos[0].getX() || ptos[ptos.length - 1].getY() != ptos[0].getY()) {
            Coordinate coord = new Coordinate(ptos[0].getX(), ptos[0].getY(), 0.0);
            coordList.add((Object)coord);
        }
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(typeName);
        b.setCRS(this.crs);
        b.add("the_geom", Polygon.class);
        b.add("layer", String.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        LinearRing linearRing = gF.createLinearRing(coordList.toCoordinateArray());
        Polygon polygon = gF.createPolygon(linearRing, null);
        Object[] values = new Object[]{polygon, layerName};
        builder.addAll(values);
        SimpleFeature feature = builder.buildFeature(typeName + "." + id);
        return feature;
    }

    public SimpleFeature convertDwgSolid(String typeName, String layerName, DwgSolid solid, int id) {
        double[] p1 = solid.getCorner1();
        double[] p2 = solid.getCorner2();
        double[] p3 = solid.getCorner3();
        double[] p4 = solid.getCorner4();
        Point2D[] ptos = new Point2D[]{new Point2D.Double(p1[0], p1[1]), new Point2D.Double(p2[0], p2[1]), new Point2D.Double(p3[0], p3[1]), new Point2D.Double(p4[0], p4[1])};
        CoordinateList coordList = new CoordinateList();
        for (int j = 0; j < ptos.length; ++j) {
            Coordinate coord = new Coordinate(ptos[j].getX(), ptos[j].getY());
            coordList.add((Object)coord);
        }
        coordList.closeRing();
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(typeName);
        b.setCRS(this.crs);
        b.add("the_geom", Polygon.class);
        b.add("layer", String.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        LinearRing linearRing = gF.createLinearRing(coordList.toCoordinateArray());
        Polygon polygon = gF.createPolygon(linearRing, null);
        Object[] values = new Object[]{polygon, layerName};
        builder.addAll(values);
        SimpleFeature feature = builder.buildFeature(typeName + "." + id);
        return feature;
    }

    public SimpleFeature convertDwgArc(String typeName, String layerName, DwgArc arc, int id) {
        double[] c = arc.getCenter();
        Point2D.Double center = new Point2D.Double(c[0], c[1]);
        double radius = arc.getRadius();
        double initAngle = Math.toDegrees(arc.getInitAngle());
        double endAngle = Math.toDegrees(arc.getEndAngle());
        Point2D[] ptos = GisModelCurveCalculator.calculateGisModelArc(center, radius, initAngle, endAngle);
        CoordinateList coordList = new CoordinateList();
        for (int j = 0; j < ptos.length; ++j) {
            Coordinate coord = new Coordinate(ptos[j].getX(), ptos[j].getY(), 0.0);
            coordList.add((Object)coord);
        }
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(typeName);
        b.setCRS(this.crs);
        b.add("the_geom", LineString.class);
        b.add("layer", String.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        LineString lineString = gF.createLineString(coordList.toCoordinateArray());
        Object[] values = new Object[]{lineString, layerName};
        builder.addAll(values);
        SimpleFeature feature = builder.buildFeature(typeName + "." + id);
        return feature;
    }
}

