/*
 * Decompiled with CFR 0.152.
 */
package jams.gui.input;

import jams.data.Attribute;
import jams.gui.input.JCalendarButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class JCalendarPopup
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    public static final String DATE_PARAM = "date";
    protected String m_strDateParam = "date";
    public static Border ROLLOVER_BORDER = new LineBorder(Color.GRAY, 1);
    public static Border SELECTED_BORDER = new LineBorder(Color.BLUE, 1);
    public static Border EMPTY_BORDER = new EmptyBorder(1, 1, 1, 1);
    public static final long KMS_IN_A_DAY = 86400000L;
    protected Date m_dateTarget = null;
    protected Date m_datePanelTarget = null;
    protected Date m_dateSelected = null;
    protected Date m_dateNow = null;
    protected boolean m_bFirstTime = true;
    protected int m_iTargetComponent = 0;
    protected Calendar m_calendar = Calendar.getInstance();
    protected StringBuffer m_sb = new StringBuffer();
    protected DateFormat m_df = DateFormat.getDateInstance(0);
    private JPanel m_panelMonth;
    private JButton m_buttonPrevMonth;
    private JLabel m_labelMonth;
    private JButton m_buttonNextMonth;
    private JPanel m_panelYear;
    private JButton m_buttonPrevYear;
    private JLabel m_labelYear;
    private JButton m_buttonNextYear;
    private JPanel m_panelDays;
    protected boolean m_bTransferFocus = true;
    public static final String CALENDAR_ICON = "Calendar";
    public static final Insets NO_INSETS = new Insets(0, 0, 0, 0);
    private Border oldBorder = EMPTY_BORDER;

    public JCalendarPopup() {
    }

    public JCalendarPopup(Date date) {
        this();
        this.init(null, date, null);
    }

    public JCalendarPopup(String strDateParam, Date date) {
        this();
        this.init(strDateParam, date, null);
    }

    public JCalendarPopup(String strDateParam, Date date, String strLanguage) {
        this();
        this.init(strDateParam, date, strLanguage);
    }

    public void init(String strDateParam, Date dateTarget, String strLanguage) {
        Locale locale;
        if (strDateParam != null) {
            this.m_strDateParam = strDateParam;
        }
        this.initComponents();
        this.m_dateNow = new Date();
        if (dateTarget == null) {
            dateTarget = this.m_dateNow;
        }
        this.m_dateSelected = dateTarget;
        if (strLanguage != null && (locale = new Locale(strLanguage, "")) != null) {
            this.m_calendar = Calendar.getInstance(locale);
            this.m_df = DateFormat.getDateInstance(0, locale);
        }
        this.m_calendar.setTimeZone(Attribute.Calendar.DEFAULT_TIME_ZONE);
        this.m_calendar.setTime(dateTarget);
        this.m_calendar.set(11, 12);
        this.m_calendar.set(12, 0);
        this.m_calendar.set(13, 0);
        this.m_calendar.set(14, 0);
        this.m_dateTarget = this.m_calendar.getTime();
        this.layoutCalendar(this.m_dateTarget);
        if (dateTarget == this.m_dateNow) {
            this.m_dateSelected = this.m_dateTarget;
        }
    }

    public void layoutCalendar(Date dateTarget) {
        this.m_calendar.setTime(dateTarget);
        this.m_calendar.set(11, 12);
        this.m_calendar.set(12, 0);
        this.m_calendar.set(13, 0);
        this.m_calendar.set(14, 0);
        this.m_datePanelTarget = this.m_calendar.getTime();
        this.m_calendar.set(5, 1);
        this.m_calendar.set(11, 0);
        this.m_calendar.set(12, 0);
        this.m_calendar.set(13, 0);
        this.m_calendar.set(14, 0);
        Date dateFirstOfMonth = this.m_calendar.getTime();
        this.m_calendar.setTime(dateFirstOfMonth);
        this.m_calendar.add(2, 1);
        this.m_calendar.add(5, -1);
        this.m_calendar.set(11, 23);
        this.m_calendar.set(12, 59);
        this.m_calendar.set(13, 59);
        this.m_calendar.set(14, 999);
        Date dateLastOfMonth = this.m_calendar.getTime();
        Date dateCalendarFirstDate = this.getFirstDateInCalendar(dateFirstOfMonth);
        Date dateCalendar = new Date(dateCalendarFirstDate.getTime());
        this.m_iTargetComponent = (int)((this.m_dateTarget.getTime() - dateCalendarFirstDate.getTime()) / 86400000L);
        if (this.m_iTargetComponent < 0) {
            --this.m_iTargetComponent;
        }
        String strYear = this.getDateString(dateTarget, 1);
        String strMonth = this.getDateString(dateTarget, 2);
        this.m_labelMonth.setText(strMonth);
        this.m_labelYear.setText(strYear);
        int iDayOfWeekComponent = 0;
        for (int iDayComponent = 7; iDayComponent < this.m_panelDays.getComponentCount(); ++iDayComponent) {
            if (iDayOfWeekComponent < 7) {
                JLabel labelDayOfWeek = (JLabel)this.m_panelDays.getComponent(iDayOfWeekComponent);
                String strWeek = this.getDateString(dateCalendar, 9);
                if (strWeek != null && strWeek.length() > 0) {
                    labelDayOfWeek.setText(strWeek.substring(0, 1));
                } else {
                    labelDayOfWeek.setText(Integer.toString(iDayOfWeekComponent));
                }
            }
            JLabel labelDay = (JLabel)this.m_panelDays.getComponent(iDayComponent);
            String strDay = this.getDateString(dateCalendar, 3);
            labelDay.setText(strDay);
            if (dateCalendar.before(dateFirstOfMonth) || dateCalendar.after(dateLastOfMonth)) {
                labelDay.setForeground(Color.GRAY);
            } else {
                labelDay.setForeground(Color.BLACK);
            }
            labelDay.setBackground(this.m_panelDays.getBackground());
            if (this.m_iTargetComponent == iDayComponent - 7) {
                labelDay.setBorder(SELECTED_BORDER);
            } else {
                labelDay.setBorder(EMPTY_BORDER);
            }
            this.m_calendar.setTime(dateCalendar);
            this.m_calendar.add(5, 1);
            dateCalendar = this.m_calendar.getTime();
            if (this.m_bFirstTime) {
                labelDay.addMouseListener(this);
                labelDay.setName(Integer.toString(iDayComponent - 7));
            }
            ++iDayOfWeekComponent;
        }
        this.m_bFirstTime = false;
    }

    private void initComponents() {
        JLabel label;
        int i;
        ImageIcon icon;
        ClassLoader cl = this.getClass().getClassLoader();
        this.setLayout(new BoxLayout(this, 1));
        this.m_panelMonth = new JPanel();
        this.m_panelMonth.setLayout(new BoxLayout(this.m_panelMonth, 0));
        this.m_buttonPrevMonth = new JButton();
        this.m_labelMonth = new JLabel();
        this.m_buttonPrevMonth.setPreferredSize(new Dimension(22, 17));
        this.m_buttonPrevMonth.setMaximumSize(new Dimension(22, 17));
        this.m_buttonPrevMonth.setFont(new Font("Dialog", 1, 11));
        try {
            icon = new ImageIcon(cl.getResource("images/buttons/Back.gif"));
            this.m_buttonPrevMonth.setIcon(icon);
        }
        catch (Exception ex) {
            this.m_buttonPrevMonth.setText("<");
        }
        this.m_buttonPrevMonth.setMargin(new Insets(2, 2, 2, 2));
        this.m_buttonPrevMonth.setMinimumSize(new Dimension(22, 17));
        this.m_buttonPrevMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCalendarPopup.this.prevMonthActionPerformed(evt);
            }
        });
        this.m_panelMonth.add(this.m_buttonPrevMonth);
        this.m_labelMonth.setPreferredSize(new Dimension(80, 17));
        this.m_labelMonth.setMinimumSize(new Dimension(80, 17));
        this.m_labelMonth.setText("month");
        this.m_labelMonth.setHorizontalAlignment(0);
        this.m_labelMonth.setFont(new Font("Dialog", 0, 12));
        this.m_labelMonth.setMaximumSize(new Dimension(200, 20));
        this.m_panelMonth.add(this.m_labelMonth);
        this.m_buttonNextMonth = new JButton();
        this.m_buttonNextMonth.setAlignmentX(1.0f);
        this.m_buttonNextMonth.setPreferredSize(new Dimension(22, 17));
        this.m_buttonNextMonth.setMaximumSize(new Dimension(22, 17));
        this.m_buttonNextMonth.setFont(new Font("Dialog", 1, 11));
        try {
            icon = new ImageIcon(cl.getResource("images/buttons/Forward.gif"));
            this.m_buttonNextMonth.setIcon(icon);
        }
        catch (Exception ex) {
            this.m_buttonNextMonth.setText(">");
        }
        this.m_buttonNextMonth.setMargin(new Insets(2, 2, 2, 2));
        this.m_buttonNextMonth.setMinimumSize(new Dimension(22, 17));
        this.m_buttonNextMonth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCalendarPopup.this.nextMonthActionPerformed(evt);
            }
        });
        this.m_panelMonth.add(this.m_buttonNextMonth);
        this.add(this.m_panelMonth);
        this.m_panelYear = new JPanel();
        this.m_panelYear.setLayout(new BoxLayout(this.m_panelYear, 0));
        this.m_buttonPrevYear = new JButton();
        this.m_labelYear = new JLabel();
        this.m_buttonPrevYear.setPreferredSize(new Dimension(22, 17));
        this.m_buttonPrevYear.setMaximumSize(new Dimension(22, 17));
        this.m_buttonPrevYear.setFont(new Font("Dialog", 1, 11));
        try {
            icon = new ImageIcon(cl.getResource("images/buttons/Back.gif"));
            this.m_buttonPrevYear.setIcon(icon);
        }
        catch (Exception ex) {
            this.m_buttonPrevYear.setText("<");
        }
        this.m_buttonPrevYear.setMargin(new Insets(2, 2, 2, 2));
        this.m_buttonPrevYear.setMinimumSize(new Dimension(22, 17));
        this.m_buttonPrevYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCalendarPopup.this.prevYearActionPerformed(evt);
            }
        });
        this.m_panelYear.add(this.m_buttonPrevYear);
        this.m_labelYear.setPreferredSize(new Dimension(44, 17));
        this.m_labelYear.setMinimumSize(new Dimension(44, 17));
        this.m_labelYear.setText("Year");
        this.m_labelYear.setHorizontalAlignment(0);
        this.m_labelYear.setFont(new Font("Dialog", 0, 12));
        this.m_labelYear.setMaximumSize(new Dimension(200, 20));
        this.m_panelYear.add(this.m_labelYear);
        this.m_buttonNextYear = new JButton();
        this.m_buttonNextYear.setAlignmentX(1.0f);
        this.m_buttonNextYear.setPreferredSize(new Dimension(22, 17));
        this.m_buttonNextYear.setMaximumSize(new Dimension(22, 17));
        this.m_buttonNextYear.setFont(new Font("Dialog", 1, 11));
        try {
            icon = new ImageIcon(cl.getResource("images/buttons/Forward.gif"));
            this.m_buttonNextYear.setIcon(icon);
        }
        catch (Exception ex) {
            this.m_buttonNextYear.setText(">");
        }
        this.m_buttonNextYear.setMargin(new Insets(2, 2, 2, 2));
        this.m_buttonNextYear.setMinimumSize(new Dimension(22, 17));
        this.m_buttonNextYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCalendarPopup.this.nextYearActionPerformed(evt);
            }
        });
        this.m_panelYear.add(this.m_buttonNextYear);
        this.add(this.m_panelYear);
        this.m_panelDays = new JPanel();
        this.m_panelDays.setLayout(new GridLayout(7, 7));
        for (i = 1; i <= 7; ++i) {
            label = new JLabel();
            label.setText(Integer.toString(i));
            label.setHorizontalAlignment(0);
            label.setFont(new Font("Dialog", 1, 11));
            this.m_panelDays.add(label);
        }
        for (i = 1; i <= 42; ++i) {
            label = new JLabel();
            label.setBorder(EMPTY_BORDER);
            label.setHorizontalAlignment(0);
            this.m_panelDays.add(label);
        }
        this.add(this.m_panelDays);
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
    }

    private void nextMonthActionPerformed(ActionEvent evt) {
        this.m_calendar.setTime(this.m_datePanelTarget);
        this.m_calendar.add(2, 1);
        this.m_calendar.set(11, 12);
        this.m_calendar.set(12, 0);
        this.m_calendar.set(13, 0);
        this.m_calendar.set(14, 0);
        this.m_datePanelTarget = this.m_calendar.getTime();
        this.layoutCalendar(this.m_datePanelTarget);
    }

    private void prevMonthActionPerformed(ActionEvent evt) {
        this.m_calendar.setTime(this.m_datePanelTarget);
        this.m_calendar.add(2, -1);
        this.m_calendar.set(11, 12);
        this.m_calendar.set(12, 0);
        this.m_calendar.set(13, 0);
        this.m_calendar.set(14, 0);
        this.m_datePanelTarget = this.m_calendar.getTime();
        this.layoutCalendar(this.m_datePanelTarget);
    }

    private void nextYearActionPerformed(ActionEvent evt) {
        this.m_calendar.setTime(this.m_datePanelTarget);
        this.m_calendar.add(1, 1);
        this.m_calendar.set(11, 12);
        this.m_calendar.set(12, 0);
        this.m_calendar.set(13, 0);
        this.m_calendar.set(14, 0);
        this.m_datePanelTarget = this.m_calendar.getTime();
        this.layoutCalendar(this.m_datePanelTarget);
    }

    private void prevYearActionPerformed(ActionEvent evt) {
        this.m_calendar.setTime(this.m_datePanelTarget);
        this.m_calendar.add(1, -1);
        this.m_calendar.set(11, 12);
        this.m_calendar.set(12, 0);
        this.m_calendar.set(13, 0);
        this.m_calendar.set(14, 0);
        this.m_datePanelTarget = this.m_calendar.getTime();
        this.layoutCalendar(this.m_datePanelTarget);
    }

    public Date getFirstDateInCalendar(Date dateTarget) {
        int iFirstDayOfWeek = this.m_calendar.getFirstDayOfWeek();
        this.m_calendar.setTime(dateTarget);
        int iTargetDayOfWeek = this.m_calendar.get(7);
        int iOffset = -Math.abs(iTargetDayOfWeek - iFirstDayOfWeek);
        this.m_calendar.add(5, iOffset);
        this.m_calendar.set(11, 0);
        this.m_calendar.set(12, 0);
        this.m_calendar.set(13, 0);
        this.m_calendar.set(14, 0);
        return this.m_calendar.getTime();
    }

    public String getDateString(Date dateTarget, int iDateFormat) {
        this.m_sb.setLength(0);
        FieldPosition fieldPosition = new FieldPosition(iDateFormat);
        String string = null;
        string = this.m_df.format(dateTarget, this.m_sb, fieldPosition).toString();
        int iBegin = fieldPosition.getBeginIndex();
        int iEnd = fieldPosition.getEndIndex();
        string = string.substring(iBegin, iEnd);
        return string;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        JLabel button = (JLabel)evt.getSource();
        int iOffsetDay = Integer.parseInt(button.getName());
        iOffsetDay -= this.m_iTargetComponent;
        this.m_calendar.setTime(this.m_dateSelected);
        int hour = this.m_calendar.get(11);
        int minute = this.m_calendar.get(12);
        int second = this.m_calendar.get(13);
        int ms = this.m_calendar.get(14);
        this.m_calendar.setTime(this.m_dateTarget);
        this.m_calendar.add(5, iOffsetDay);
        if (hour == 0 && minute == 0 && second == 0 && ms == 0) {
            hour = 12;
        }
        this.m_calendar.set(11, hour);
        this.m_calendar.set(12, minute);
        this.m_calendar.set(13, second);
        this.m_calendar.set(14, ms);
        Date date = this.m_calendar.getTime();
        JPopupMenu popupMenu = this.getJPopupMenu();
        if (popupMenu != null) {
            Component invoker = popupMenu.getInvoker();
            this.getParent().remove(this);
            Container container = popupMenu.getParent();
            container.remove(popupMenu);
            popupMenu.setVisible(false);
            if (invoker != null && this.m_bTransferFocus) {
                invoker.transferFocus();
            }
        }
        Date oldDate = this.m_dateSelected;
        if (this.m_dateSelected == this.m_dateTarget) {
            oldDate = null;
        }
        this.firePropertyChange(this.m_strDateParam, oldDate, date);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        JLabel button = (JLabel)evt.getSource();
        this.oldBorder = button.getBorder();
        button.setBorder(ROLLOVER_BORDER);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        JLabel button = (JLabel)evt.getSource();
        button.setBorder(this.oldBorder);
    }

    private JPopupMenu getJPopupMenu() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JPopupMenu)) continue;
            return (JPopupMenu)parent;
        }
        return null;
    }

    public static JCalendarPopup createCalendarPopup(Date dateTarget, Component button) {
        return JCalendarPopup.createCalendarPopup(null, dateTarget, button, null);
    }

    public static JCalendarPopup createCalendarPopup(String strDateParam, Date dateTarget, Component button) {
        return JCalendarPopup.createCalendarPopup(null, dateTarget, button, null);
    }

    public static JCalendarPopup createCalendarPopup(String strDateParam, Date dateTarget, Component button, String strLanguage) {
        JPopupMenu popup;
        JPopupMenu c = popup = new JPopupMenu();
        c.setLayout(new BorderLayout());
        JCalendarPopup calendar = new JCalendarPopup(strDateParam, dateTarget, strLanguage);
        c.add((Component)calendar, "Center");
        popup.show(button, button.getBounds().width, 0);
        return calendar;
    }

    public static JButton createCalendarButton(String strDateParam, Date dateTarget) {
        JCalendarButton button = new JCalendarButton(strDateParam, dateTarget);
        button.setMargin(NO_INSETS);
        button.setOpaque(false);
        return button;
    }

    public void setTransferFocus(boolean bTransferFocus) {
        this.m_bTransferFocus = bTransferFocus;
    }
}

