/*
 * Decompiled with CFR 0.152.
 */
package jams.gui;

import jams.gui.input.BooleanInput;
import jams.gui.input.InputComponent;
import jams.gui.input.IntegerInput;
import jams.gui.input.TextInput;
import jams.gui.tools.GUIHelper;
import jams.workspace.JAMSWorkspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class WorkspaceDlg
extends JDialog {
    private JAMSWorkspace ws;
    private InputComponent titleInput;
    private IntegerInput idInput;
    private JTextArea descriptionInput;
    private InputComponent persistenceInput;

    public WorkspaceDlg(Frame parent) {
        super(parent);
        this.setLocationByPlatform(true);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        GridBagLayout gbl = new GridBagLayout();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(gbl);
        GUIHelper.addGBComponent(mainPanel, gbl, new JLabel("Title"), 10, 10, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(mainPanel, gbl, new JLabel("Description"), 10, 20, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(mainPanel, gbl, new JLabel("ID"), 10, 30, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(mainPanel, gbl, new JLabel("Persistent"), 10, 30, 1, 1, 1.0, 1.0);
        this.titleInput = new TextInput();
        this.titleInput.setLength(40);
        this.idInput = new IntegerInput();
        this.descriptionInput = new JTextArea();
        JScrollPane descriptionScroll = new JScrollPane(this.descriptionInput);
        descriptionScroll.setPreferredSize(new Dimension(200, 100));
        this.persistenceInput = new BooleanInput();
        GUIHelper.addGBComponent(mainPanel, gbl, this.titleInput.getComponent(), 20, 10, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(mainPanel, gbl, descriptionScroll, 20, 20, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(mainPanel, gbl, this.idInput.getComponent(), 20, 20, 1, 1, 1.0, 1.0);
        GUIHelper.addGBComponent(mainPanel, gbl, this.persistenceInput.getComponent(), 20, 30, 1, 1, 1.0, 1.0);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceDlg.this.ws.setTitle(WorkspaceDlg.this.titleInput.getValue());
                WorkspaceDlg.this.ws.setDescription(WorkspaceDlg.this.descriptionInput.getText());
                WorkspaceDlg.this.ws.setID(Integer.parseInt(WorkspaceDlg.this.idInput.getValue()));
                if (WorkspaceDlg.this.persistenceInput.getValue().equalsIgnoreCase("true")) {
                    WorkspaceDlg.this.ws.setPersistent(true);
                } else {
                    WorkspaceDlg.this.ws.setPersistent(false);
                }
                WorkspaceDlg.this.ws.saveConfig();
                WorkspaceDlg.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkspaceDlg.this.setVisible(false);
            }
        };
        cancelButton.addActionListener(cancelListener);
        cancelButton.registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke(27, 0), 2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        JScrollPane scroll = new JScrollPane(mainPanel);
        this.getContentPane().add((Component)scroll, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.setResizable(false);
    }

    public void setVisible(JAMSWorkspace ws) {
        this.ws = ws;
        this.setTitle("Workspace Properties [" + ws.getDirectory().getPath() + "]");
        this.titleInput.setValue(ws.getTitle());
        this.idInput.setValue(Integer.toString(ws.getID()));
        this.descriptionInput.setText(ws.getDescription());
        this.persistenceInput.setValue(Boolean.toString(ws.isPersistent()));
        this.setVisible(true);
    }
}

