/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.view;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.view.OrbitView;

public class OrbitViewPropertyAccessor {
    private OrbitViewPropertyAccessor() {
    }

    public static PositionAccessor createCenterPositionAccessor() {
        return new CenterPositionAccessor();
    }

    public static AngleAccessor createHeadingAccessor() {
        return new HeadingAccessor();
    }

    public static AngleAccessor createPitchAccessor() {
        return new PitchAccessor();
    }

    public static DoubleAccessor createZoomAccessor() {
        return new ZoomAccessor();
    }

    private static class ZoomAccessor
    implements DoubleAccessor {
        private ZoomAccessor() {
        }

        public final Double getDouble(OrbitView orbitView) {
            if (orbitView == null) {
                return null;
            }
            return orbitView.getZoom();
        }

        public final boolean setDouble(OrbitView orbitView, Double d) {
            if (orbitView == null || d == null) {
                return false;
            }
            try {
                orbitView.setZoom(d);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class PitchAccessor
    implements AngleAccessor {
        private PitchAccessor() {
        }

        public final Angle getAngle(OrbitView orbitView) {
            if (orbitView == null) {
                return null;
            }
            return orbitView.getPitch();
        }

        public final boolean setAngle(OrbitView orbitView, Angle angle) {
            if (orbitView == null || angle == null) {
                return false;
            }
            try {
                orbitView.setPitch(angle);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class HeadingAccessor
    implements AngleAccessor {
        private HeadingAccessor() {
        }

        public final Angle getAngle(OrbitView orbitView) {
            if (orbitView == null) {
                return null;
            }
            return orbitView.getHeading();
        }

        public final boolean setAngle(OrbitView orbitView, Angle angle) {
            if (orbitView == null || angle == null) {
                return false;
            }
            try {
                orbitView.setHeading(angle);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    private static class CenterPositionAccessor
    implements PositionAccessor {
        private CenterPositionAccessor() {
        }

        public Position getPosition(OrbitView orbitView) {
            if (orbitView == null) {
                return null;
            }
            return orbitView.getCenterPosition();
        }

        public boolean setPosition(OrbitView orbitView, Position position) {
            if (orbitView == null || position == null) {
                return false;
            }
            try {
                orbitView.setCenterPosition(position);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static interface PositionAccessor {
        public Position getPosition(OrbitView var1);

        public boolean setPosition(OrbitView var1, Position var2);
    }

    public static interface DoubleAccessor {
        public Double getDouble(OrbitView var1);

        public boolean setDouble(OrbitView var1, Double var2);
    }

    public static interface AngleAccessor {
        public Angle getAngle(OrbitView var1);

        public boolean setAngle(OrbitView var1, Angle var2);
    }
}

