/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileKey
implements Comparable<TileKey> {
    private final int level;
    private final int row;
    private final int col;
    private final String cacheName;
    private final int hash;

    public TileKey(int n, int n2, int n3, String string) {
        if (n < 0) {
            String string2 = Logging.getMessage("TileKey.levelIsLessThanZero");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (n2 < 0) {
            String string3 = Logging.getMessage("generic.RowIndexOutOfRange", n2);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (n3 < 0) {
            String string4 = Logging.getMessage("generic.ColumnIndexOutOfRange", n3);
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (string == null || string.length() < 1) {
            String string5 = Logging.getMessage("TileKey.cacheNameIsNullOrEmpty");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        this.level = n;
        this.row = n2;
        this.col = n3;
        this.cacheName = string;
        this.hash = this.computeHash();
    }

    public TileKey(Angle angle, Angle angle2, Level level) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (level == null) {
            String string = Logging.getMessage("nullValue.LevelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.level = level.getLevelNumber();
        this.row = Tile.computeRow(level.getTileDelta().getLatitude(), angle);
        this.col = Tile.computeColumn(level.getTileDelta().getLongitude(), angle2);
        this.cacheName = level.getCacheName();
        this.hash = this.computeHash();
    }

    public TileKey(Tile tile) {
        if (tile == null) {
            String string = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.level = tile.getLevelNumber();
        this.row = tile.getRow();
        this.col = tile.getColumn();
        this.cacheName = tile.getCacheName();
        this.hash = this.computeHash();
    }

    public int getLevelNumber() {
        return this.level;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.col;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    private int computeHash() {
        int n = this.level;
        n = 29 * n + this.row;
        n = 29 * n + this.col;
        n = 29 * n + (this.cacheName != null ? this.cacheName.hashCode() : 0);
        return n;
    }

    @Override
    public final int compareTo(TileKey tileKey) {
        if (tileKey == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (tileKey.level == this.level && tileKey.row == this.row && tileKey.col == this.col) {
            return 0;
        }
        if (this.level < tileKey.level) {
            return -1;
        }
        if (this.level > tileKey.level) {
            return 1;
        }
        if (this.row < tileKey.row) {
            return -1;
        }
        if (this.row > tileKey.row) {
            return 1;
        }
        if (this.col < tileKey.col) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TileKey tileKey = (TileKey)object;
        if (this.col != tileKey.col) {
            return false;
        }
        if (this.level != tileKey.level) {
            return false;
        }
        if (this.row != tileKey.row) {
            return false;
        }
        return !(this.cacheName == null ? tileKey.cacheName != null : !this.cacheName.equals(tileKey.cacheName));
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.cacheName + "/" + this.level + "/" + this.row + "/" + this.col;
    }
}

