/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileKey;
import gov.nasa.worldwind.util.TileUrlBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelSet
extends WWObjectImpl {
    private final Sector sector;
    private final LatLon levelZeroTileDelta;
    private final int numLevelZeroColumns;
    private final ArrayList<Level> levels = new ArrayList();
    private final SectorResolution[] sectorLevelLimits;

    public LevelSet(Collection<Level> collection, AVList aVList) {
        this(aVList, collection);
    }

    public LevelSet(AVList aVList) {
        this(aVList, null);
    }

    /*
     * WARNING - void declaration
     */
    public LevelSet(AVList aVList, Collection<Level> collection) {
        String string;
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        Object object2 = aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta");
        if (object2 == null || !(object2 instanceof LatLon)) {
            stringBuffer.append(Logging.getMessage("term.tileDelta"));
        }
        if ((object2 = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) == null || !(object2 instanceof Sector)) {
            stringBuffer.append(Logging.getMessage("term.sector"));
        }
        int n3 = 0;
        object2 = aVList.getValue("gov.nasa.worldwind.avkey.NumLevels");
        if (object2 == null || !(object2 instanceof Integer) || (n3 = ((Integer)object2).intValue()) < 1) {
            stringBuffer.append(Logging.getMessage("term.numLevels"));
        }
        int n22 = 0;
        object2 = aVList.getValue("gov.nasa.worldwind.avkey.NumEmptyLevels");
        if (object2 == null || !(object2 instanceof Integer) || (n22 = ((Integer)object2).intValue()) < 0) {
            stringBuffer.append(Logging.getMessage("term.numEMptyLevels"));
        }
        String[] stringArray = null;
        object2 = aVList.getValue("gov.nasa.worldwind.avkey.InactiveLevels");
        if (object2 != null && !(object2 instanceof String)) {
            stringBuffer.append(Logging.getMessage("term.sector"));
        } else if (object2 != null) {
            stringArray = ((String)object2).split(",");
        }
        SectorResolution[] sectorResolutionArray = null;
        object2 = aVList.getValue("gov.nasa.worldwind.avkey.SectorResolutionLimits");
        if (object2 != null && !(object2 instanceof SectorResolution[])) {
            stringBuffer.append(Logging.getMessage("term.sectorResolutionLimits"));
        } else if (object2 != null) {
            SectorResolution[] object = sectorResolutionArray = (SectorResolution[])object2;
            n2 = object.length;
            for (n = 0; n < n2; ++n) {
                SectorResolution sectorResolution = object[n];
                if (sectorResolution.levelNumber <= n3 - 1) continue;
                string = Logging.getMessage("LevelSet.sectorResolutionLimitsTooHigh", sectorResolution.levelNumber, n3 - 1);
                Logging.logger().warning(string);
                break;
            }
        }
        this.sectorLevelLimits = sectorResolutionArray;
        if (stringBuffer.length() > 0) {
            String string2 = Logging.getMessage("layers.LevelSet.InvalidLevelDescriptorFields", stringBuffer.toString());
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.levelZeroTileDelta = (LatLon)aVList.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta");
        this.sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        TileUrlBuilder tileUrlBuilder = (TileUrlBuilder)(aVList = aVList.copy()).getValue("gov.nasa.worldwind.avkey.TileURLBuilder");
        if (tileUrlBuilder == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new TileUrlBuilder(){

                public URL getURL(Tile tile, String string) throws MalformedURLException {
                    String string2 = tile.getLevel().getService();
                    if (string2 == null || string2.length() < 1) {
                        return null;
                    }
                    StringBuffer stringBuffer = new StringBuffer(tile.getLevel().getService());
                    if (stringBuffer.lastIndexOf("?") != stringBuffer.length() - 1) {
                        stringBuffer.append("?");
                    }
                    stringBuffer.append("T=");
                    stringBuffer.append(tile.getLevel().getDataset());
                    stringBuffer.append("&L=");
                    stringBuffer.append(tile.getLevel().getLevelName());
                    stringBuffer.append("&X=");
                    stringBuffer.append(tile.getColumn());
                    stringBuffer.append("&Y=");
                    stringBuffer.append(tile.getRow());
                    return new URL(string == null ? stringBuffer.toString() : stringBuffer.toString().replace("dds", ""));
                }
            });
        }
        if (this.sectorLevelLimits != null) {
            Arrays.sort(this.sectorLevelLimits, new Comparator<SectorResolution>(){

                @Override
                public int compare(SectorResolution sectorResolution, SectorResolution sectorResolution2) {
                    return sectorResolution.levelNumber < sectorResolution2.levelNumber ? 1 : (sectorResolution.levelNumber == sectorResolution2.levelNumber ? 0 : -1);
                }
            });
        }
        this.numLevelZeroColumns = (int)Math.max(1L, Math.round(this.sector.getDeltaLon().divide(this.levelZeroTileDelta.getLongitude())));
        if (collection != null) {
            this.levels.addAll(collection);
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                aVList.setValue("gov.nasa.worldwind.avkey.LevelNameKey", n2 < n22 ? "" : Integer.toString(n2 - n22));
                aVList.setValue("gov.nasa.worldwind.avkey.LevelNumberKey", n2);
                Angle angle = this.levelZeroTileDelta.getLatitude().divide(Math.pow(2.0, n2));
                Angle angle2 = this.levelZeroTileDelta.getLongitude().divide(Math.pow(2.0, n2));
                aVList.setValue("gov.nasa.worldwind.avkey.TileDeltaKey", new LatLon(angle, angle2));
                this.levels.add(new Level(aVList));
            }
        }
        if (stringArray != null) {
            void var12_20;
            String[] stringArray2 = stringArray;
            n = stringArray2.length;
            boolean bl = false;
            while (var12_20 < n) {
                string = stringArray2[var12_20];
                int n4 = Integer.parseInt(string);
                this.getLevel(n4).setActive(false);
                ++var12_20;
            }
        }
    }

    public LevelSet(LevelSet levelSet) {
        if (levelSet == null) {
            String string = Logging.getMessage("nullValue.LevelSetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.levelZeroTileDelta = levelSet.levelZeroTileDelta;
        this.sector = levelSet.sector;
        this.numLevelZeroColumns = levelSet.numLevelZeroColumns;
        this.sectorLevelLimits = levelSet.sectorLevelLimits;
        for (Level level : levelSet.levels) {
            this.levels.add(level);
        }
    }

    public final Sector getSector() {
        return this.sector;
    }

    public final LatLon getLevelZeroTileDelta() {
        return this.levelZeroTileDelta;
    }

    public final ArrayList<Level> getLevels() {
        return this.levels;
    }

    public final Level getLevel(int n) {
        return n >= 0 && n < this.levels.size() ? this.levels.get(n) : null;
    }

    public final int getNumLevels() {
        return this.levels.size();
    }

    public final Level getFirstLevel() {
        return this.getLevel(0);
    }

    public final Level getLastLevel() {
        return this.getLevel(this.getNumLevels() - 1);
    }

    public final Level getNextToLastLevel() {
        return this.getLevel(this.getNumLevels() > 1 ? this.getNumLevels() - 2 : 0);
    }

    public final Level getLastLevel(Sector sector) {
        Level level = this.getLevel(this.getNumLevels() - 1);
        if (this.sectorLevelLimits != null) {
            for (SectorResolution sectorResolution : this.sectorLevelLimits) {
                if (!sectorResolution.sector.intersects(sector) || sectorResolution.levelNumber > level.getLevelNumber()) continue;
                level = this.getLevel(sectorResolution.levelNumber);
                break;
            }
        }
        return level;
    }

    public final Level getLastLevel(Angle angle, Angle angle2) {
        Level level = this.getLevel(this.getNumLevels() - 1);
        if (this.sectorLevelLimits != null) {
            for (SectorResolution sectorResolution : this.sectorLevelLimits) {
                if (!sectorResolution.sector.contains(angle, angle2) || sectorResolution.levelNumber > level.getLevelNumber()) continue;
                level = this.getLevel(sectorResolution.levelNumber);
                break;
            }
        }
        return level;
    }

    public final boolean isFinalLevel(int n) {
        return n == this.getNumLevels() - 1;
    }

    public final boolean isLevelEmpty(int n) {
        return this.levels.get(n).isEmpty();
    }

    private int numColumnsInLevel(Level level) {
        int n = level.getLevelNumber() - this.getFirstLevel().getLevelNumber();
        double d = Math.pow(2.0, n);
        return (int)(d * (double)this.numLevelZeroColumns);
    }

    private long getTileNumber(Tile tile) {
        return tile.getRow() * this.numColumnsInLevel(tile.getLevel()) + tile.getColumn();
    }

    public final void markResourceAbsent(Tile tile) {
        if (tile == null) {
            String string = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        tile.getLevel().markResourceAbsent(this.getTileNumber(tile));
    }

    public final boolean isResourceAbsent(Tile tile) {
        if (tile == null) {
            String string = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (tile.getLevel().isEmpty()) {
            return true;
        }
        int n = tile.getRow() * this.numColumnsInLevel(tile.getLevel()) + tile.getColumn();
        return tile.getLevel().isResourceAbsent(n);
    }

    public final void unmarkResourceAbsent(Tile tile) {
        if (tile == null) {
            String string = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        tile.getLevel().unmarkResourceAbsent(this.getTileNumber(tile));
    }

    public Sector computeSectorForKey(TileKey tileKey) {
        if (tileKey == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Level level = this.getLevel(tileKey.getLevelNumber());
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = Tile.computeRowLatitude(tileKey.getRow(), angle);
        Angle angle4 = Tile.computeColumnLongitude(tileKey.getColumn(), angle2);
        return new Sector(angle3, angle3.add(angle), angle4, angle4.add(angle2));
    }

    public Tile createTile(TileKey tileKey) {
        if (tileKey == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Level level = this.getLevel(tileKey.getLevelNumber());
        Angle angle = level.getTileDelta().getLatitude();
        Angle angle2 = level.getTileDelta().getLongitude();
        Angle angle3 = Tile.computeRowLatitude(tileKey.getRow(), angle);
        Angle angle4 = Tile.computeColumnLongitude(tileKey.getColumn(), angle2);
        Sector sector = new Sector(angle3, angle3.add(angle), angle4, angle4.add(angle2));
        return new Tile(sector, level, tileKey.getRow(), tileKey.getColumn());
    }

    public static final class SectorResolution {
        private final int levelNumber;
        private final Sector sector;

        public SectorResolution(Sector sector, int n) {
            this.levelNumber = n;
            this.sector = sector;
        }
    }
}

