/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.util.Logging;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TextRendererCache
implements Disposable {
    private ConcurrentHashMap<Object, TextRenderer> renderers = new ConcurrentHashMap();

    public void dispose() {
        for (Map.Entry<Object, TextRenderer> entry : this.renderers.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().dispose();
        }
        this.renderers.clear();
    }

    public void add(Object object, TextRenderer textRenderer) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.renderers.put(object, textRenderer);
    }

    public void remove(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.renderers.remove(object);
    }

    public TextRenderer get(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.renderers.get(object);
    }
}

