/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.globes.SectorGeometry;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceTile;
import gov.nasa.worldwind.util.Logging;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SurfaceTileRenderer
implements Disposable {
    private static final int DEFAULT_ALPHA_TEXTURE_SIZE = 2;
    private Texture alphaTexture;
    private Texture outlineTexture;
    private boolean showImageTileOutlines = false;

    @Override
    public void dispose() {
        if (this.alphaTexture != null) {
            this.alphaTexture.dispose();
        }
        this.alphaTexture = null;
        if (this.outlineTexture != null) {
            this.outlineTexture.dispose();
        }
        this.outlineTexture = null;
    }

    public boolean isShowImageTileOutlines() {
        return this.showImageTileOutlines;
    }

    public void setShowImageTileOutlines(boolean bl) {
        this.showImageTileOutlines = bl;
    }

    public void renderTile(DrawContext drawContext, SurfaceTile surfaceTile) {
        if (surfaceTile == null) {
            String string = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        ArrayList<SurfaceTile> arrayList = new ArrayList<SurfaceTile>(1);
        arrayList.add(surfaceTile);
        this.renderTiles(drawContext, arrayList);
        arrayList.clear();
    }

    protected abstract void preComputeTransform(DrawContext var1, SectorGeometry var2);

    protected abstract void computeTransform(DrawContext var1, SurfaceTile var2, Transform var3);

    protected abstract Iterable<SurfaceTile> getIntersectingTiles(DrawContext var1, SectorGeometry var2, Iterable<? extends SurfaceTile> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderTiles(DrawContext drawContext, Iterable<? extends SurfaceTile> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.TileIterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL gL = drawContext.getGL();
        gL.glPushAttrib(291073);
        try {
            boolean bl;
            this.alphaTexture = drawContext.getTextureCache().get(this);
            if (this.alphaTexture == null) {
                this.initAlphaTexture(2);
                drawContext.getTextureCache().put(this, this.alphaTexture);
            }
            boolean bl2 = bl = this.showImageTileOutlines && drawContext.getNumTextureUnits() > 2;
            if (bl && this.outlineTexture == null) {
                this.initOutlineTexture(128);
            }
            gL.glEnable(2929);
            gL.glDepthFunc(515);
            gL.glEnable(3008);
            gL.glAlphaFunc(516, 0.01f);
            gL.glActiveTexture(33984);
            gL.glEnable(3553);
            gL.glMatrixMode(5890);
            gL.glPushMatrix();
            if (!drawContext.isPickingMode()) {
                gL.glTexEnvi(8960, 8704, 8448);
            } else {
                gL.glTexEnvf(8960, 8704, 34160.0f);
                gL.glTexEnvf(8960, 34176, 34168.0f);
                gL.glTexEnvf(8960, 34161, 7681.0f);
            }
            int n = 2;
            int n2 = 33985;
            if (bl) {
                n = 3;
                n2 = 33986;
                gL.glActiveTexture(33985);
                gL.glEnable(3553);
                gL.glMatrixMode(5890);
                gL.glPushMatrix();
                gL.glTexEnvi(8960, 8704, 260);
            }
            gL.glActiveTexture(n2);
            gL.glEnable(3553);
            gL.glMatrixMode(5890);
            gL.glPushMatrix();
            gL.glTexEnvi(8960, 8704, 8448);
            Transform transform = new Transform();
            for (SectorGeometry sectorGeometry : drawContext.getSurfaceGeometry()) {
                Iterable<SurfaceTile> iterable2 = this.getIntersectingTiles(drawContext, sectorGeometry, iterable);
                if (iterable2 == null) continue;
                this.preComputeTransform(drawContext, sectorGeometry);
                for (SurfaceTile surfaceTile : iterable2) {
                    gL.glActiveTexture(33984);
                    if (!surfaceTile.bind(drawContext)) continue;
                    gL.glMatrixMode(5890);
                    gL.glLoadIdentity();
                    surfaceTile.applyInternalTransform(drawContext);
                    this.computeTransform(drawContext, surfaceTile, transform);
                    gL.glScaled(transform.HScale, transform.VScale, 1.0);
                    gL.glTranslated(transform.HShift, transform.VShift, 0.0);
                    if (bl) {
                        gL.glActiveTexture(33985);
                        this.outlineTexture.bind();
                        gL.glMatrixMode(5890);
                        gL.glLoadIdentity();
                        gL.glScaled(transform.HScale, transform.VScale, 1.0);
                        gL.glTranslated(transform.HShift, transform.VShift, 0.0);
                    }
                    gL.glActiveTexture(n2);
                    this.alphaTexture.bind();
                    gL.glMatrixMode(5890);
                    gL.glLoadIdentity();
                    gL.glScaled(transform.HScale, transform.VScale, 1.0);
                    gL.glTranslated(transform.HShift, transform.VShift, 0.0);
                    sectorGeometry.renderMultiTexture(drawContext, n);
                }
            }
            gL.glActiveTexture(n2);
            gL.glMatrixMode(5890);
            gL.glPopMatrix();
            gL.glDisable(3553);
            gL.glActiveTexture(33984);
            gL.glMatrixMode(5890);
            gL.glPopMatrix();
            gL.glDisable(3553);
            if (bl) {
                gL.glActiveTexture(33985);
                gL.glMatrixMode(5890);
                gL.glPopMatrix();
                gL.glDisable(3553);
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("generic.ExceptionWhileRenderingLayer", this.getClass().getName()), exception);
        }
        finally {
            gL.glPopAttrib();
        }
    }

    private static void fillByteBuffer(ByteBuffer byteBuffer, byte by) {
        for (int i = 0; i < byteBuffer.capacity(); ++i) {
            byteBuffer.put(by);
        }
    }

    private void initAlphaTexture(int n) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(n * n);
        SurfaceTileRenderer.fillByteBuffer(byteBuffer, (byte)-1);
        TextureData textureData = new TextureData(6406, n, n, 0, 6406, 5121, false, false, false, byteBuffer.rewind(), null);
        this.alphaTexture = TextureIO.newTexture(textureData);
        this.alphaTexture.bind();
        this.alphaTexture.setTexParameteri(10240, 9728);
        this.alphaTexture.setTexParameteri(10241, 9728);
        this.alphaTexture.setTexParameteri(10242, 33069);
        this.alphaTexture.setTexParameteri(10243, 33069);
    }

    private void initOutlineTexture(int n) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer(n * n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                byte by = i == 0 || j == 0 || i == n - 1 || j == n - 1 ? (byte)-1 : 0;
                byteBuffer.put(i * n + j, by);
            }
        }
        TextureData textureData = new TextureData(6409, n, n, 0, 6409, 5121, false, false, false, byteBuffer.rewind(), null);
        this.outlineTexture = TextureIO.newTexture(textureData);
        this.outlineTexture.bind();
        this.outlineTexture.setTexParameteri(10240, 9728);
        this.outlineTexture.setTexParameteri(10241, 9728);
        this.outlineTexture.setTexParameteri(10242, 33071);
        this.outlineTexture.setTexParameteri(10243, 33071);
    }

    protected static class Transform {
        double HScale;
        double VScale;
        double HShift;
        double VShift;

        protected Transform() {
        }
    }
}

