/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.TextureCache;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceTile;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.retrieve.RetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.Retriever;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class SurfaceImage
implements SurfaceTile,
Renderable,
Movable {
    private static final String DEFAULT_CACHE_DIRECTORY = "SurfaceImages";
    private Object imageSource;
    private Sector sector;
    private Position referencePosition;
    private Extent extent;
    private double extentVerticalExaggertion = Double.MIN_VALUE;
    private double opacity = 1.0;
    private TextureData textureData = null;
    private boolean reload = false;
    private boolean useCache = true;
    private boolean loading = false;
    private boolean hasProblem = false;
    private Layer layer;
    private String cacheDirectory = "SurfaceImages";

    public SurfaceImage(Object object, Sector sector) {
        this.initialize(object, sector, null, this.cacheDirectory);
    }

    public SurfaceImage(Object object, Sector sector, Layer layer) {
        this.initialize(object, sector, layer, this.cacheDirectory);
    }

    public SurfaceImage(Object object, Sector sector, Layer layer, String string) {
        this.initialize(object, sector, layer, string);
    }

    private void initialize(Object object, Sector sector, Layer layer, String string) {
        if (object == null) {
            String string2 = Logging.getMessage("nullValue.ImageSourceIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (sector == null) {
            String string3 = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = Logging.getMessage("nullValue.DirectionIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        this.imageSource = object;
        this.sector = sector;
        this.referencePosition = new Position(sector.getCentroid(), 0.0);
        this.layer = layer;
        this.cacheDirectory = string;
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    public Sector getSector() {
        return this.sector;
    }

    public void setSector(Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.sector = sector;
        this.extent = null;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public boolean hasProblem() {
        return this.hasProblem;
    }

    public boolean reload(boolean bl) {
        if (this.loading) {
            return false;
        }
        this.reload = true;
        this.useCache = bl;
        this.loading = false;
        this.hasProblem = false;
        return true;
    }

    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.extent == null || this.extentVerticalExaggertion != drawContext.getVerticalExaggeration()) {
            this.extent = drawContext.getGlobe().computeBoundingCylinder(drawContext.getVerticalExaggeration(), this.getSector());
            this.extentVerticalExaggertion = drawContext.getVerticalExaggeration();
        }
        return this.extent;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        this.opacity = d;
    }

    public Layer getLayer() {
        return this.layer;
    }

    private void setTexture(TextureCache textureCache, Texture texture) {
        if (textureCache == null) {
            String string = Logging.getMessage("nullValue.TextureCacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        textureCache.put(this.imageSource, texture);
    }

    private Texture getTexture(TextureCache textureCache) {
        if (textureCache == null) {
            String string = Logging.getMessage("nullValue.TextureCacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return textureCache.get(this.imageSource);
    }

    private Texture initializeTexture(DrawContext drawContext) {
        Object object;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = null;
        if (this.imageSource instanceof String) {
            object = (String)this.imageSource;
            if (((String)object).toLowerCase().startsWith("http")) {
                if (this.loading) {
                    return null;
                }
                if (this.textureData != null && !this.reload) {
                    texture = TextureIO.newTexture(this.textureData);
                } else if (!this.hasProblem) {
                    this.sendLoadRequests((String)object);
                    return null;
                }
            } else {
                Object object2 = WWIO.getFileOrResourceAsStream((String)object, this.getClass());
                if (object2 == null || object2 instanceof Exception) {
                    Logging.logger().log(Level.SEVERE, "layers.TextureLayer.ExceptionAttemptingToReadTextureFile", object2 != null ? object2 : "");
                    return null;
                }
                try {
                    texture = TextureIO.newTexture((InputStream)object2, true, null);
                }
                catch (Exception exception) {
                    Logging.logger().log(Level.SEVERE, "layers.TextureLayer.ExceptionAttemptingToReadTextureFile", exception);
                    return null;
                }
            }
        } else if (this.imageSource instanceof BufferedImage) {
            try {
                texture = TextureIO.newTexture((BufferedImage)this.imageSource, true);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.IOExceptionDuringTextureInitialization");
                Logging.logger().log(Level.SEVERE, string, exception);
                return null;
            }
        } else {
            Logging.logger().log(Level.SEVERE, "SurfaceImage.UnknownSourceType", this.imageSource.getClass().getName());
            return null;
        }
        if (texture == null) {
            Logging.logger().log(Level.SEVERE, "generic.TextureUnreadable", this.imageSource instanceof String ? this.imageSource : this.imageSource.getClass().getName());
            return null;
        }
        this.setTexture(drawContext.getTextureCache(), texture);
        texture.bind();
        object = drawContext.getGL();
        object.glTexParameteri(3553, 10241, 9729);
        object.glTexParameteri(3553, 10240, 9729);
        object.glTexParameteri(3553, 10242, 33071);
        object.glTexParameteri(3553, 10243, 33071);
        return texture;
    }

    public boolean bind(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = this.getTexture(drawContext.getTextureCache());
        if ((texture == null || this.reload) && (texture = this.initializeTexture(drawContext)) != null) {
            return true;
        }
        if (texture != null) {
            texture.bind();
        }
        return texture != null;
    }

    public void applyInternalTransform(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = this.getTexture(drawContext.getTextureCache());
        if (texture == null) {
            texture = this.initializeTexture(drawContext);
        }
        if (texture != null && texture.getMustFlipVertically()) {
            GL gL = GLContext.getCurrent().getGL();
            gL.glMatrixMode(5890);
            gL.glLoadIdentity();
            gL.glScaled(1.0, -1.0, 1.0);
            gL.glTranslated(0.0, -1.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!this.sector.intersects(drawContext.getVisibleSector())) {
            return;
        }
        GL gL = drawContext.getGL();
        try {
            if (!drawContext.isPickingMode()) {
                double d;
                double d2 = d = this.layer != null ? this.getOpacity() * this.layer.getOpacity() : this.getOpacity();
                if (d < 1.0) {
                    gL.glPushAttrib(16393);
                    gL.glColor4d(1.0, 1.0, 1.0, d);
                } else {
                    gL.glPushAttrib(16392);
                }
                gL.glEnable(3042);
                gL.glBlendFunc(770, 771);
            } else {
                gL.glPushAttrib(8);
            }
            gL.glPolygonMode(1028, 6914);
            gL.glEnable(2884);
            gL.glCullFace(1029);
            drawContext.getGeographicSurfaceTileRenderer().renderTile(drawContext, this);
        }
        finally {
            gL.glPopAttrib();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SurfaceImage surfaceImage = (SurfaceImage)object;
        return this.imageSource.equals(surfaceImage.imageSource) && this.sector.equals(surfaceImage.sector);
    }

    public int hashCode() {
        int n = this.imageSource.hashCode();
        n = 31 * n + this.sector.hashCode();
        return n;
    }

    private void sendLoadRequests(String string) {
        if (WorldWind.getTaskService().isFull()) {
            return;
        }
        this.reload = false;
        this.loading = true;
        WorldWind.getTaskService().addTask(new RequestTask(string));
    }

    private String getCachePath(String string) {
        try {
            URL uRL = new URL(string);
            if (DEFAULT_CACHE_DIRECTORY.equals(this.cacheDirectory)) {
                return this.cacheDirectory + "/" + WWIO.formPath(uRL.getHost()) + uRL.getPath();
            }
            return this.cacheDirectory + "/" + new File(uRL.getFile()).getName();
        }
        catch (MalformedURLException malformedURLException) {
            return WWIO.formPath(this.cacheDirectory, string);
        }
    }

    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.sector.getMinLatitude().getDegrees();
        double d2 = this.sector.getMinLongitude().getDegrees();
        double d3 = this.sector.getMaxLatitude().getDegrees();
        double d4 = this.sector.getMaxLongitude().getDegrees();
        double d5 = position.getLatitude().getDegrees();
        double d6 = position.getLongitude().getDegrees();
        d += d5;
        d2 += d6;
        d4 += d6;
        if ((d3 += d5) > 90.0 || d3 < -90.0 || d > 90.0 || d < -90.0 || d4 > 180.0 || d4 < -180.0 || d2 > 180.0 || d2 < -180.0) {
            return;
        }
        this.referencePosition.add(position);
        this.setSector(Sector.fromDegrees(d, d3, d2, d4));
    }

    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = position.getLatitude().getDegrees();
        double d2 = position.getLongitude().getDegrees();
        double d3 = this.sector.getDeltaLatDegrees() / 2.0;
        double d4 = this.sector.getDeltaLonDegrees() / 2.0;
        double d5 = d - d3;
        double d6 = d + d3;
        double d7 = d2 - d4;
        double d8 = d2 + d4;
        if (d6 > 90.0 || d6 < -90.0 || d5 > 90.0 || d5 < -90.0 || d8 > 180.0 || d8 < -180.0 || d7 > 180.0 || d7 < -180.0) {
            return;
        }
        this.referencePosition = position;
        this.setSector(Sector.fromDegrees(d5, d6, d7, d8));
    }

    public Position getReferencePosition() {
        return this.referencePosition;
    }

    private class DownloadPostProcessor
    implements RetrievalPostProcessor {
        private DownloadPostProcessor() {
        }

        public ByteBuffer run(Retriever retriever) {
            if (retriever == null) {
                SurfaceImage.this.loading = false;
                SurfaceImage.this.hasProblem = true;
                String string = Logging.getMessage("nullValue.RetrieverIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (!retriever.getState().equals("gov.nasa.worldwind.RetrieverStatusSuccessful")) {
                SurfaceImage.this.loading = false;
                SurfaceImage.this.hasProblem = true;
                return null;
            }
            HTTPRetriever hTTPRetriever = (HTTPRetriever)retriever;
            if (hTTPRetriever.getResponseCode() == 204) {
                SurfaceImage.this.loading = false;
                SurfaceImage.this.hasProblem = true;
                return null;
            }
            if (hTTPRetriever.getResponseCode() != 200) {
                SurfaceImage.this.loading = false;
                SurfaceImage.this.hasProblem = true;
                return null;
            }
            URLRetriever uRLRetriever = (URLRetriever)retriever;
            ByteBuffer byteBuffer = uRLRetriever.getBuffer();
            if (byteBuffer != null) {
                try {
                    String string = SurfaceImage.this.getCachePath(hTTPRetriever.getUrl().toString());
                    File file = WorldWind.getDataFileCache().newFile(string);
                    if (file == null) {
                        String string2 = Logging.getMessage("generic.CantCreateCacheFile", string);
                        Logging.logger().warning(string2);
                        return null;
                    }
                    WWIO.saveBuffer(byteBuffer, file);
                    SurfaceImage.this.textureData = TextureIO.newTextureData(new ByteArrayInputStream(byteBuffer.array()), true, null);
                    SurfaceImage.this.hasProblem = false;
                    if (SurfaceImage.this.layer != null) {
                        SurfaceImage.this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                    }
                }
                catch (Exception exception) {
                    Logging.logger().log(Level.SEVERE, Logging.getMessage("layers.TextureLayer.ExceptionSavingRetrievedTextureFile", hTTPRetriever.getUrl().toString()), exception);
                    SurfaceImage.this.hasProblem = true;
                }
            }
            SurfaceImage.this.loading = false;
            return null;
        }
    }

    private class RequestTask
    implements Runnable {
        private final String path;

        public RequestTask(String string) {
            this.path = string;
        }

        public void run() {
            URL uRL = WorldWind.getDataFileCache().findFile(SurfaceImage.this.getCachePath(this.path), false);
            if (uRL != null && SurfaceImage.this.useCache) {
                this.loadCachedTexture(uRL);
            } else {
                this.downloadTexture(this.path);
            }
        }

        private boolean loadCachedTexture(URL uRL) {
            TextureData textureData = null;
            try {
                textureData = TextureIO.newTextureData(uRL, true, null);
                SurfaceImage.this.textureData = textureData;
                SurfaceImage.this.hasProblem = false;
                if (SurfaceImage.this.layer != null) {
                    SurfaceImage.this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                }
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "layers.TextureLayer.ExceptionAttemptingToReadTextureFile", exception);
                SurfaceImage.this.hasProblem = true;
            }
            SurfaceImage.this.loading = false;
            return textureData != null;
        }

        private void downloadTexture(String string) {
            if (!WorldWind.getRetrievalService().isAvailable()) {
                return;
            }
            try {
                URL uRL = new URL(string);
                if ("http".equalsIgnoreCase(uRL.getProtocol())) {
                    if (WorldWind.getNetworkStatus().isHostUnavailable(uRL)) {
                        return;
                    }
                    HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, new DownloadPostProcessor());
                    if (SurfaceImage.this.layer != null) {
                        Integer n;
                        Integer n2;
                        Integer n3 = AVListImpl.getIntegerValue(SurfaceImage.this.layer, "gov.nasa.worldwind.avkey.URLConnectTimeout");
                        if (n3 != null && n3 > 0) {
                            hTTPRetriever.setConnectTimeout(n3);
                        }
                        if ((n2 = AVListImpl.getIntegerValue(SurfaceImage.this.layer, "gov.nasa.worldwind.avkey.URLReadTimeout")) != null && n2 > 0) {
                            hTTPRetriever.setReadTimeout(n2);
                        }
                        if ((n = AVListImpl.getIntegerValue(SurfaceImage.this.layer, "gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit")) != null && n > 0) {
                            hTTPRetriever.setStaleRequestLimit(n);
                        }
                    }
                    WorldWind.getRetrievalService().runRetriever(hTTPRetriever);
                } else {
                    SurfaceImage.this.loading = false;
                    SurfaceImage.this.hasProblem = true;
                    Logging.logger().severe(Logging.getMessage("layers.TextureLayer.UnknownRetrievalProtocol", string));
                }
            }
            catch (MalformedURLException malformedURLException) {
                SurfaceImage.this.loading = false;
                SurfaceImage.this.hasProblem = true;
                Logging.logger().severe(Logging.getMessage("layers.TextureLayer.UnknownRetrievalProtocol", string));
            }
        }
    }
}

