/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.Restorable;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Quaternion;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polyline
implements Renderable,
Movable,
Restorable {
    public static final int GREAT_CIRCLE = 0;
    public static final int LINEAR = 1;
    public static final int RHUMB_LINE = 2;
    public static final int LOXODROME = 2;
    public static final int ANTIALIAS_DONT_CARE = 4352;
    public static final int ANTIALIAS_FASTEST = 4353;
    public static final int ANTIALIAS_NICEST = 4354;
    private ArrayList<Position> positions;
    private Vec4 referenceCenterPoint;
    private Position referenceCenterPosition = Position.ZERO;
    private int antiAliasHint = 4353;
    private Color color = Color.WHITE;
    private double lineWidth = 1.0;
    private boolean filled = false;
    private boolean closed = false;
    private boolean followTerrain = false;
    private double offset = 0.0;
    private double terrainConformance = 10.0;
    private int pathType = 0;
    private ArrayList<ArrayList<Vec4>> currentSpans;
    private double length;
    private short stipplePattern = (short)-21846;
    private int stippleFactor = 0;
    private Globe globe;
    private int numSubsegments = 10;
    private boolean highlighted = false;
    private Color highlightColor = new Color(1.0f, 1.0f, 1.0f, 0.5f);

    public Polyline() {
        this.setPositions(null);
    }

    public Polyline(Iterable<Position> iterable) {
        this.setPositions(iterable);
    }

    public Polyline(Iterable<LatLon> iterable, double d) {
        this.setPositions(iterable, d);
    }

    private void reset() {
        if (this.currentSpans != null) {
            this.currentSpans.clear();
        }
        this.currentSpans = null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
    }

    public int getAntiAliasHint() {
        return this.antiAliasHint;
    }

    public void setAntiAliasHint(int n) {
        if (n != 4352 && n != 4353 && n != 4354) {
            String string = Logging.getMessage("generic.InvalidHint");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.antiAliasHint = n;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean bl) {
        this.filled = bl;
    }

    public int getPathType() {
        return this.pathType;
    }

    public void setPathType(int n) {
        this.reset();
        this.pathType = n;
    }

    public boolean isFollowTerrain() {
        return this.followTerrain;
    }

    public void setFollowTerrain(boolean bl) {
        this.reset();
        this.followTerrain = bl;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double d) {
        this.reset();
        this.offset = d;
    }

    public double getTerrainConformance() {
        return this.terrainConformance;
    }

    public void setTerrainConformance(double d) {
        this.terrainConformance = d;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double d) {
        this.lineWidth = d;
    }

    public double getLength() {
        return this.length;
    }

    public short getStipplePattern() {
        return this.stipplePattern;
    }

    public void setStipplePattern(short s) {
        this.stipplePattern = s;
    }

    public int getStippleFactor() {
        return this.stippleFactor;
    }

    public void setStippleFactor(int n) {
        this.stippleFactor = n;
    }

    public int getNumSubsegments() {
        return this.numSubsegments;
    }

    public void setNumSubsegments(int n) {
        this.reset();
        this.numSubsegments = n;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.highlightColor = color;
    }

    public void setPositions(Iterable<Position> iterable) {
        this.reset();
        this.positions = new ArrayList();
        if (iterable != null) {
            for (Position position : iterable) {
                this.positions.add(position);
            }
        }
        if (this.filled && this.positions.size() < 3) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    public void setPositions(Iterable<LatLon> iterable, double d) {
        this.reset();
        this.positions = new ArrayList();
        if (iterable != null) {
            for (LatLon latLon : iterable) {
                this.positions.add(new Position(latLon, d));
            }
        }
        if (this.filled && this.positions.size() < 3) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    public Iterable<Position> getPositions() {
        return this.positions;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.globe = drawContext.getGlobe();
        if (this.positions.size() < 2) {
            return;
        }
        if (this.currentSpans == null || this.followTerrain) {
            this.computeReferenceCenter(drawContext);
            this.makeVertices(drawContext);
        }
        if (this.currentSpans == null || this.currentSpans.size() < 1) {
            return;
        }
        GL gL = drawContext.getGL();
        int n = 32773;
        if (!drawContext.isPickingMode() && this.color.getAlpha() != 255) {
            n |= 0x4000;
        }
        gL.glPushAttrib(n);
        drawContext.getView().pushReferenceCenter(drawContext, this.referenceCenterPoint);
        try {
            if (!drawContext.isPickingMode()) {
                if (this.color.getAlpha() != 255) {
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                }
                drawContext.getGL().glColor4ub((byte)this.color.getRed(), (byte)this.color.getGreen(), (byte)this.color.getBlue(), (byte)this.color.getAlpha());
            }
            if (this.stippleFactor > 0) {
                gL.glEnable(2852);
                gL.glLineStipple(this.stippleFactor, this.stipplePattern);
            } else {
                gL.glDisable(2852);
            }
            int n2 = 3154;
            if (this.filled) {
                n2 = 3155;
            }
            gL.glHint(n2, this.antiAliasHint);
            int n3 = 3;
            if (this.filled) {
                n3 = 9;
            }
            if (drawContext.isPickingMode()) {
                gL.glLineWidth((float)this.lineWidth + 8.0f);
            } else {
                gL.glLineWidth((float)this.lineWidth);
            }
            if (this.followTerrain) {
                this.pushOffest(drawContext);
            }
            for (ArrayList<Vec4> arrayList : this.currentSpans) {
                if (arrayList == null) continue;
                gL.glBegin(n3);
                for (Vec4 vec4 : arrayList) {
                    gL.glVertex3d(vec4.x, vec4.y, vec4.z);
                }
                gL.glEnd();
            }
            if (this.highlighted && !drawContext.isPickingMode()) {
                if (this.highlightColor.getAlpha() != 255) {
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                }
                drawContext.getGL().glColor4ub((byte)this.highlightColor.getRed(), (byte)this.highlightColor.getGreen(), (byte)this.highlightColor.getBlue(), (byte)this.highlightColor.getAlpha());
                gL.glLineWidth((float)this.lineWidth + 2.0f);
                for (ArrayList<Vec4> arrayList : this.currentSpans) {
                    if (arrayList == null) continue;
                    gL.glBegin(n3);
                    for (Vec4 vec4 : arrayList) {
                        gL.glVertex3d(vec4.x, vec4.y, vec4.z);
                    }
                    gL.glEnd();
                }
            }
            if (this.followTerrain) {
                this.popOffest(drawContext);
            }
        }
        finally {
            gL.glPopAttrib();
            drawContext.getView().popReferenceCenter(drawContext);
        }
    }

    private void pushOffest(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        float[] fArray = new float[16];
        gL.glGetFloatv(2983, fArray, 0);
        fArray[10] = (float)((double)fArray[10] * 0.99);
        gL.glPushAttrib(4096);
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadMatrixf(fArray, 0);
    }

    private void popOffest(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    protected void makeVertices(DrawContext drawContext) {
        if (this.currentSpans == null) {
            this.currentSpans = new ArrayList();
        } else {
            this.currentSpans.clear();
        }
        this.length = 0.0;
        if (this.positions.size() < 1) {
            return;
        }
        Position position = this.positions.get(0);
        Vec4 vec4 = this.computePoint(drawContext, position, true);
        for (int i = 1; i <= this.positions.size(); ++i) {
            Position position2;
            if (i < this.positions.size()) {
                position2 = this.positions.get(i);
            } else {
                if (!this.closed) break;
                position2 = this.positions.get(0);
            }
            Vec4 vec42 = this.computePoint(drawContext, position2, true);
            if (this.followTerrain && !this.isSegmentVisible(drawContext, position, position2, vec4, vec42)) {
                position = position2;
                vec4 = vec42;
                continue;
            }
            ArrayList<Vec4> arrayList = this.makeSegment(drawContext, position, position2, vec4, vec42);
            if (arrayList != null) {
                this.addSpan(arrayList);
            }
            position = position2;
            vec4 = vec42;
        }
    }

    private void addSpan(ArrayList<Vec4> arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            this.currentSpans.add(arrayList);
        }
    }

    private boolean isSegmentVisible(DrawContext drawContext, Position position, Position position2, Vec4 vec4, Vec4 vec42) {
        Frustum frustum = drawContext.getView().getFrustumInModelCoordinates();
        if (frustum.contains(vec4)) {
            return true;
        }
        if (frustum.contains(vec42)) {
            return true;
        }
        if (vec4.equals(vec42)) {
            return false;
        }
        Position position3 = Position.interpolate(0.5, position, position2);
        Vec4 vec43 = this.computePoint(drawContext, position3, true);
        if (frustum.contains(vec43)) {
            return true;
        }
        double d = Line.distanceToSegment(vec4, vec42, vec43);
        Cylinder cylinder = new Cylinder(vec4, vec42, d == 0.0 ? 1.0 : d);
        return cylinder.intersects(drawContext.getView().getFrustumInModelCoordinates());
    }

    private Vec4 computePoint(DrawContext drawContext, Position position, boolean bl) {
        if (this.followTerrain) {
            double d = !bl ? 0.0 : this.offset;
            return this.computeTerrainPoint(drawContext, position.getLatitude(), position.getLongitude(), d);
        }
        double d = position.getElevation() + (bl ? this.offset : 0.0);
        return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
    }

    private double computeSegmentLength(DrawContext drawContext, Position position, Position position2) {
        LatLon latLon = new LatLon(position.getLatitude(), position.getLongitude());
        LatLon latLon2 = new LatLon(position2.getLatitude(), position2.getLongitude());
        Angle angle = LatLon.greatCircleDistance(latLon, latLon2);
        if (this.followTerrain) {
            return angle.radians * (drawContext.getGlobe().getRadius() + this.offset);
        }
        double d = this.offset + 0.5 * (position.getElevation() + position2.getElevation());
        return angle.radians * (drawContext.getGlobe().getRadius() + d);
    }

    private ArrayList<Vec4> makeSegment(DrawContext drawContext, Position position, Position position2, Vec4 vec4, Vec4 vec42) {
        ArrayList<Vec4> arrayList = null;
        double d = this.computeSegmentLength(drawContext, position, position2);
        if (d <= 0.0) {
            arrayList = this.addPointToSpan(vec4, arrayList);
            if (!vec4.equals(vec42)) {
                arrayList = this.addPointToSpan(vec42, arrayList);
            }
            return arrayList;
        }
        Angle angle = null;
        Angle angle2 = null;
        double d2 = 0.0;
        double d3 = 0.0;
        while (d2 < 1.0) {
            LatLon latLon;
            Angle angle3;
            Position position3;
            d3 = this.followTerrain ? (d3 += this.terrainConformance * drawContext.getView().computePixelSizeAtDistance(vec4.distanceTo3(drawContext.getView().getEyePoint()))) : (d3 += d / (double)this.numSubsegments);
            d2 = d3 / d;
            if (d2 >= 1.0) {
                position3 = position2;
            } else if (this.pathType == 1) {
                position3 = Position.interpolate(d2, position, position2);
            } else if (this.pathType == 2) {
                if (angle == null) {
                    angle = LatLon.rhumbAzimuth(position.getLatLon(), position2.getLatLon());
                    angle2 = LatLon.rhumbDistance(position.getLatLon(), position2.getLatLon());
                }
                angle3 = Angle.fromRadians(d2 * angle2.radians);
                latLon = LatLon.rhumbEndPosition(position.getLatLon(), angle, angle3);
                position3 = new Position(latLon, (1.0 - d2) * position.getElevation() + d2 * position2.getElevation());
            } else {
                if (angle == null) {
                    angle = LatLon.greatCircleAzimuth(position.getLatLon(), position2.getLatLon());
                    angle2 = LatLon.greatCircleDistance(position.getLatLon(), position2.getLatLon());
                }
                angle3 = Angle.fromRadians(d2 * angle2.radians);
                latLon = LatLon.greatCircleEndPosition(position.getLatLon(), angle, angle3);
                position3 = new Position(latLon, (1.0 - d2) * position.getElevation() + d2 * position2.getElevation());
            }
            vec42 = this.computePoint(drawContext, position3, true);
            arrayList = this.clipAndAdd(drawContext, vec4, vec42, arrayList);
            this.length += vec4.distanceTo3(vec42);
            vec4 = vec42;
        }
        return arrayList;
    }

    private ArrayList<Vec4> clipAndAdd(DrawContext drawContext, Vec4 vec4, Vec4 vec42, ArrayList<Vec4> arrayList) {
        if (arrayList == null) {
            arrayList = this.addPointToSpan(vec4, arrayList);
        }
        return this.addPointToSpan(vec42, arrayList);
    }

    private ArrayList<Vec4> addPointToSpan(Vec4 vec4, ArrayList<Vec4> arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.add(vec4.subtract3(this.referenceCenterPoint));
        return arrayList;
    }

    private void computeReferenceCenter(DrawContext drawContext) {
        if (this.positions.size() < 1) {
            return;
        }
        this.referenceCenterPosition = this.positions.size() < 3 ? this.positions.get(0) : this.positions.get(this.positions.size() / 2);
        this.referenceCenterPoint = this.computeTerrainPoint(drawContext, this.referenceCenterPosition.getLatitude(), this.referenceCenterPosition.getLongitude(), this.offset);
    }

    @Override
    public Position getReferencePosition() {
        return this.referenceCenterPosition;
    }

    private Vec4 computeTerrainPoint(DrawContext drawContext, Angle angle, Angle angle2, double d) {
        Vec4 vec4 = drawContext.getSurfaceGeometry().getSurfacePoint(angle, angle2, d);
        if (vec4 == null) {
            vec4 = drawContext.getGlobe().computePointFromPosition(angle, angle2, d + drawContext.getGlobe().getElevation(angle, angle2) * drawContext.getVerticalExaggeration());
        }
        return vec4;
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.moveTo(this.getReferencePosition().add(position));
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.reset();
        if (this.positions.size() < 1) {
            return;
        }
        Vec4 vec4 = this.referenceCenterPoint;
        Vec4 vec42 = this.globe.computePointFromPosition(position);
        Angle angle = LatLon.greatCircleDistance(this.referenceCenterPosition.getLatLon(), position.getLatLon());
        Vec4 vec43 = vec4.cross3(vec42).normalize3();
        Quaternion quaternion = Quaternion.fromAxisAngle(angle, vec43);
        for (int i = 0; i < this.positions.size(); ++i) {
            Position position2 = this.positions.get(i);
            Vec4 vec44 = this.globe.computePointFromPosition(position2);
            vec44 = vec44.transformBy3(quaternion);
            position2 = this.globe.computePositionFromPoint(vec44);
            this.positions.set(i, position2);
        }
    }

    @Override
    public String getRestorableState() {
        Object object;
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        if (this.color != null && (object = RestorableSupport.encodeColor(this.color)) != null) {
            restorableSupport.addStateValueAsString("color", (String)object);
        }
        if (this.highlightColor != null && (object = RestorableSupport.encodeColor(this.highlightColor)) != null) {
            restorableSupport.addStateValueAsString("highlightColor", (String)object);
        }
        if (this.positions != null && (object = restorableSupport.addStateObject("positions")) != null) {
            for (Position position : this.positions) {
                RestorableSupport.StateObject stateObject;
                if (position == null || position.getLatitude() == null || position.getLongitude() == null || (stateObject = restorableSupport.addStateObject((RestorableSupport.StateObject)object, "position")) == null) continue;
                restorableSupport.addStateValueAsDouble(stateObject, "latitudeDegrees", position.getLatitude().degrees);
                restorableSupport.addStateValueAsDouble(stateObject, "longitudeDegrees", position.getLongitude().degrees);
                restorableSupport.addStateValueAsDouble(stateObject, "elevation", position.getElevation());
            }
        }
        restorableSupport.addStateValueAsInteger("antiAliasHint", this.antiAliasHint);
        restorableSupport.addStateValueAsBoolean("filled", this.filled);
        restorableSupport.addStateValueAsBoolean("closed", this.closed);
        restorableSupport.addStateValueAsBoolean("highlighted", this.highlighted);
        restorableSupport.addStateValueAsInteger("pathType", this.pathType);
        restorableSupport.addStateValueAsBoolean("followTerrain", this.followTerrain);
        restorableSupport.addStateValueAsDouble("offset", this.offset);
        restorableSupport.addStateValueAsDouble("terrainConformance", this.terrainConformance);
        restorableSupport.addStateValueAsDouble("lineWidth", this.lineWidth);
        restorableSupport.addStateValueAsInteger("stipplePattern", this.stipplePattern);
        restorableSupport.addStateValueAsInteger("stippleFactor", this.stippleFactor);
        restorableSupport.addStateValueAsInteger("numSubsegments", this.numSubsegments);
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Boolean bl;
        Double d;
        Double d2;
        Double d3;
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        String string4 = restorableSupport.getStateValueAsString("color");
        if (string4 != null && (object4 = RestorableSupport.decodeColor(string4)) != null) {
            this.setColor((Color)object4);
        }
        if ((string4 = restorableSupport.getStateValueAsString("highlightColor")) != null && (object4 = RestorableSupport.decodeColor(string4)) != null) {
            this.setHighlightColor((Color)object4);
        }
        if ((object4 = restorableSupport.getStateObject("positions")) != null) {
            serializable = new ArrayList();
            object3 = restorableSupport.getAllStateObjects((RestorableSupport.StateObject)object4, "position");
            if (object3 != null && ((RestorableSupport.StateObject[])object3).length != 0) {
                object2 = object3;
                int n5 = ((Object)object2).length;
                for (int i = 0; i < n5; ++i) {
                    object = object2[i];
                    if (object == null) continue;
                    d3 = restorableSupport.getStateValueAsDouble((RestorableSupport.StateObject)object, "latitudeDegrees");
                    d2 = restorableSupport.getStateValueAsDouble((RestorableSupport.StateObject)object, "longitudeDegrees");
                    d = restorableSupport.getStateValueAsDouble((RestorableSupport.StateObject)object, "elevation");
                    if (d3 == null || d2 == null || d == null) continue;
                    ((ArrayList)serializable).add(Position.fromDegrees(d3, d2, d));
                }
            }
            this.setPositions((Iterable<Position>)((Object)serializable));
        }
        if ((serializable = restorableSupport.getStateValueAsInteger("antiAliasHint")) != null) {
            this.setAntiAliasHint((Integer)serializable);
        }
        if ((object3 = restorableSupport.getStateValueAsBoolean("filled")) != null) {
            this.setFilled((Boolean)object3);
        }
        if ((object2 = restorableSupport.getStateValueAsBoolean("closed")) != null) {
            this.setClosed((Boolean)object2);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean("highlighted")) != null) {
            this.setHighlighted(bl);
        }
        if ((n4 = restorableSupport.getStateValueAsInteger("pathType")) != null) {
            this.setPathType(n4);
        }
        if ((object = restorableSupport.getStateValueAsBoolean("followTerrain")) != null) {
            this.setFollowTerrain((Boolean)object);
        }
        if ((d3 = restorableSupport.getStateValueAsDouble("offset")) != null) {
            this.setOffset(d3);
        }
        if ((d2 = restorableSupport.getStateValueAsDouble("terrainConformance")) != null) {
            this.setTerrainConformance(d2);
        }
        if ((d = restorableSupport.getStateValueAsDouble("lineWidth")) != null) {
            this.setLineWidth(d);
        }
        if ((n3 = restorableSupport.getStateValueAsInteger("stipplePattern")) != null) {
            this.setStipplePattern(n3.shortValue());
        }
        if ((n2 = restorableSupport.getStateValueAsInteger("stippleFactor")) != null) {
            this.setStippleFactor(n2);
        }
        if ((n = restorableSupport.getStateValueAsInteger("numSubsegments")) != null) {
            this.setNumSubsegments(n);
        }
    }
}

