/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.SectorGeometry;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceTile;
import gov.nasa.worldwind.render.SurfaceTileRenderer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeographicSurfaceTileRenderer
extends SurfaceTileRenderer {
    private double sgWidth;
    private double sgHeight;
    private double sgMinWE;
    private double sgMinSN;

    @Override
    protected void preComputeTransform(DrawContext drawContext, SectorGeometry sectorGeometry) {
        Sector sector = sectorGeometry.getSector();
        this.sgWidth = sector.getDeltaLonRadians();
        this.sgHeight = sector.getDeltaLatRadians();
        this.sgMinWE = sector.getMinLongitude().radians;
        this.sgMinSN = sector.getMinLatitude().radians;
    }

    @Override
    protected void computeTransform(DrawContext drawContext, SurfaceTile surfaceTile, SurfaceTileRenderer.Transform transform) {
        Sector sector = surfaceTile.getSector();
        double d = sector.getDeltaLonRadians();
        double d2 = sector.getDeltaLatRadians();
        double d3 = sector.getMinLongitude().radians;
        double d4 = sector.getMinLatitude().radians;
        transform.VScale = d2 > 0.0 ? this.sgHeight / d2 : 1.0;
        transform.HScale = d > 0.0 ? this.sgWidth / d : 1.0;
        transform.VShift = -(d4 - this.sgMinSN) / this.sgHeight;
        transform.HShift = -(d3 - this.sgMinWE) / this.sgWidth;
    }

    @Override
    protected Iterable<SurfaceTile> getIntersectingTiles(DrawContext drawContext, SectorGeometry sectorGeometry, Iterable<? extends SurfaceTile> iterable) {
        ArrayList<SurfaceTile> arrayList = null;
        for (SurfaceTile surfaceTile : iterable) {
            if (!surfaceTile.getSector().intersects(sectorGeometry.getSector())) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<SurfaceTile>();
            }
            arrayList.add(surfaceTile);
        }
        if (arrayList == null) {
            return null;
        }
        return arrayList;
    }
}

