/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.rpf.wizard;

import gov.nasa.worldwind.layers.rpf.wizard.DataChooserPanel;
import gov.nasa.worldwind.layers.rpf.wizard.FileSet;
import gov.nasa.worldwind.layers.rpf.wizard.RPFWizardUtil;
import gov.nasa.worldwind.layers.rpf.wizard.SizeFormatter;
import gov.nasa.worldwind.layers.rpf.wizard.TimeFormatter;
import gov.nasa.worldwind.util.wizard.DefaultPanelDescriptor;
import gov.nasa.worldwind.util.wizard.Wizard;
import gov.nasa.worldwind.util.wizard.WizardModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataChooserPanelDescriptor
extends DefaultPanelDescriptor {
    private DataChooserPanel panelComponent = new DataChooserPanel();
    private PropertyEvents propertyEvents = new PropertyEvents();
    public static final String IDENTIFIER = "gov.nasa.worldwind.rpf.wizard.DataChooserPanel";

    public DataChooserPanelDescriptor() {
        this.panelComponent.addPropertyChangeListener(this.propertyEvents);
        this.setPanelIdentifier(IDENTIFIER);
        this.setPanelComponent(this.panelComponent);
    }

    @Override
    public Object getBackPanelDescriptor() {
        return "gov.nasa.worldwind.rpf.wizard.FileChooserPanel";
    }

    @Override
    public Object getNextPanelDescriptor() {
        return "gov.nasa.worldwind.rpf.wizard.PreprocessPanel";
    }

    @Override
    public void registerPanel(Wizard wizard) {
        WizardModel wizardModel = this.getWizardModel();
        if (wizardModel != null) {
            wizardModel.removePropertyChangeListener(this.propertyEvents);
        }
        super.registerPanel(wizard);
        WizardModel wizardModel2 = this.getWizardModel();
        if (wizardModel2 != null) {
            wizardModel2.addPropertyChangeListener(this.propertyEvents);
        }
    }

    @Override
    public void aboutToDisplayPanel() {
        this.setNextButtonAccordingToSelection();
    }

    private void setNextButtonAccordingToSelection() {
        Wizard wizard = this.getWizard();
        if (wizard != null) {
            boolean bl = false;
            List<FileSet> list = RPFWizardUtil.getFileSetList(wizard.getModel());
            if (list != null && list.size() > 0) {
                for (FileSet fileSet : list) {
                    bl |= fileSet.isSelected();
                }
            }
            wizard.setNextButtonEnabled(bl);
            wizard.giveFocusToNextButton();
        }
    }

    private void fileSetListChanged() {
        WizardModel wizardModel = this.getWizardModel();
        if (wizardModel != null) {
            List<FileSet> list = RPFWizardUtil.getFileSetList(wizardModel);
            this.updatePanelTitle(list);
            this.updatePanelData(list);
            this.updatePanelDataDescription(list);
        }
    }

    private void fileSetSelectionChanged() {
        this.setNextButtonAccordingToSelection();
        WizardModel wizardModel = this.getWizardModel();
        if (wizardModel != null) {
            List<FileSet> list = RPFWizardUtil.getFileSetList(wizardModel);
            this.updatePanelDataDescription(list);
        }
    }

    private void updatePanelTitle(Collection<FileSet> collection) {
        if (collection != null && collection.size() > 0) {
            this.panelComponent.setTitle(RPFWizardUtil.makeLarger("Select Imagery to Import"));
        } else {
            this.panelComponent.setTitle(RPFWizardUtil.makeLarger("No Imagery Found"));
        }
    }

    private void updatePanelData(Collection<FileSet> collection) {
        this.panelComponent.setFileSetList(collection);
    }

    private void updatePanelDataDescription(Collection<FileSet> collection) {
        Object object;
        int n = 0;
        int n2 = 0;
        if (collection != null && collection.size() > 0) {
            for (FileSet wizardProperties : collection) {
                if (wizardProperties == null) continue;
                int file = wizardProperties.getFileCount();
                n += file;
                if (!wizardProperties.isSelected()) continue;
                n2 += file;
            }
        }
        if (n > 0) {
            object = new StringBuilder();
            if (n2 > 0) {
                Object object2;
                long l = 262160L;
                long l2 = 200L;
                long l3 = (long)n2 * l;
                long l4 = (long)n2 * l2;
                ((StringBuilder)object).append("Selected files: ");
                ((StringBuilder)object).append(String.format("%,d", n2));
                if (l3 > 0L) {
                    object2 = new SizeFormatter();
                    if (((StringBuilder)object).length() > 0) {
                        ((StringBuilder)object).append(" - ");
                    }
                    ((StringBuilder)object).append("Disk space required: ~");
                    ((StringBuilder)object).append(((SizeFormatter)object2).formatEstimate(l3));
                }
                if (l4 > 0L) {
                    object2 = new TimeFormatter();
                    if (((StringBuilder)object).length() > 0) {
                        ((StringBuilder)object).append(" - ");
                    }
                    ((StringBuilder)object).append("Processing time: ");
                    ((StringBuilder)object).append(((TimeFormatter)object2).formatEstimate(l4));
                }
            } else {
                ((StringBuilder)object).append("No files selected");
            }
            this.panelComponent.setDataDescription(RPFWizardUtil.makeSmaller(((StringBuilder)object).toString()));
        } else {
            File file;
            object = new StringBuilder();
            ((StringBuilder)object).append("No Imagery");
            WizardModel wizardModel = this.getWizardModel();
            if (wizardModel != null && (file = RPFWizardUtil.getSelectedFile(wizardModel)) != null) {
                ((StringBuilder)object).append(" in '").append(file.getAbsolutePath()).append(File.separator).append("'");
            }
            this.panelComponent.setDataDescription(RPFWizardUtil.makeBold(((StringBuilder)object).toString()));
        }
    }

    private class PropertyEvents
    implements PropertyChangeListener {
        private PropertyEvents() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent != null && propertyChangeEvent.getPropertyName() != null) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("fileSetList")) {
                    DataChooserPanelDescriptor.this.fileSetListChanged();
                } else if (string.equals("fileSet.Selected")) {
                    DataChooserPanelDescriptor.this.fileSetSelectionChanged();
                }
            }
        }
    }
}

