/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.media.opengl.GL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldMapLayer
extends RenderableLayer {
    public static final String NORTHWEST = "gov.nasa.worldwind.WorldmapLayer.NorthWest";
    public static final String SOUTHWEST = "gov.nasa.worldwind.WorldmapLayer.SouthWest";
    public static final String NORTHEAST = "gov.nasa.worldwind.WorldmapLayer.NorthEast";
    public static final String SOUTHEAST = "gov.nasa.worldwind.WorldmapLayer.SouthEast";
    public static final String RESIZE_STRETCH = "gov.nasa.worldwind.WorldmapLayer.Stretch";
    public static final String RESIZE_SHRINK_ONLY = "gov.nasa.worldwind.WorldmapLayer.ShrinkOnly";
    public static final String RESIZE_KEEP_FIXED_SIZE = "gov.nasa.worldwind.WorldmapLayer.FixedSize";
    private String iconFilePath;
    private double toViewportScale = 0.2;
    private double iconScale = 0.5;
    private int borderWidth = 20;
    private String position = "gov.nasa.worldwind.WorldmapLayer.NorthWest";
    private String resizeBehavior = "gov.nasa.worldwind.WorldmapLayer.ShrinkOnly";
    private int iconWidth;
    private int iconHeight;
    private Vec4 locationCenter = null;
    private Color color = Color.white;
    private Color backColor = new Color(0.0f, 0.0f, 0.0f, 0.4f);
    private boolean showFootprint = true;
    private PickSupport pickSupport = new PickSupport();
    private double pickAltitude = 1000000.0;
    private OrderedIcon orderedImage = new OrderedIcon();

    public WorldMapLayer() {
        this.setName(Logging.getMessage("layers.Earth.WorldMapLayer.Name"));
        this.setOpacity(0.6);
        this.setIconFilePath(Configuration.getStringValue("gov.nasa.worldwind.avkey.WorldMapImagePath"));
    }

    public WorldMapLayer(String string) {
        this.setName(Logging.getMessage("layers.Earth.WorldMapLayer.Name"));
        this.setOpacity(0.6);
        this.setIconFilePath(string);
    }

    public String getIconFilePath() {
        return this.iconFilePath;
    }

    public void setIconFilePath(String string) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.iconFilePath = string;
    }

    public double getToViewportScale() {
        return this.toViewportScale;
    }

    public void setToViewportScale(double d) {
        this.toViewportScale = d;
    }

    public double getIconScale() {
        return this.iconScale;
    }

    public void setIconScale(double d) {
        this.iconScale = d;
    }

    public String getResizeBehavior() {
        return this.resizeBehavior;
    }

    public void setResizeBehavior(String string) {
        this.resizeBehavior = string;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = n;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.position = string;
    }

    public Vec4 getLocationCenter() {
        return this.locationCenter;
    }

    public void setLocationCenter(Vec4 vec4) {
        this.locationCenter = vec4;
    }

    public Color getBackgrounColor() {
        return this.backColor;
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.backColor = color;
    }

    public boolean getShowFootprint() {
        return this.showFootprint;
    }

    public void setShowFootprint(boolean bl) {
        this.showFootprint = bl;
    }

    @Override
    public void doRender(DrawContext drawContext) {
        drawContext.addOrderedRenderable(this.orderedImage);
    }

    @Override
    public void doPick(DrawContext drawContext, Point point) {
        drawContext.addOrderedRenderable(this.orderedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawIcon(DrawContext drawContext) {
        if (this.iconFilePath == null) {
            return;
        }
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            gL.glPushAttrib(293121);
            bl = true;
            Texture texture = drawContext.getTextureCache().get(this);
            if (texture == null) {
                this.initializeTexture(drawContext);
                texture = drawContext.getTextureCache().get(this);
                if (texture == null) {
                    return;
                }
            }
            gL.glEnable(3042);
            gL.glBlendFunc(770, 771);
            gL.glDisable(2929);
            double d = this.getScaledIconWidth();
            double d2 = this.getScaledIconHeight();
            Rectangle rectangle = drawContext.getView().getViewport();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadIdentity();
            double d3 = d > d2 ? d : d2;
            gL.glOrtho(0.0, rectangle.width, 0.0, rectangle.height, -0.6 * d3, 0.6 * d3);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            bl2 = true;
            gL.glLoadIdentity();
            double d4 = this.computeScale(rectangle);
            Vec4 vec4 = this.computeLocation(rectangle, d4);
            gL.glTranslated(vec4.x(), vec4.y(), vec4.z());
            gL.glScaled(d4, d4, 1.0);
            gL.glScaled(d, d2, 1.0);
            if (!drawContext.isPickingMode()) {
                ArrayList<LatLon> arrayList;
                gL.glColor4ub((byte)this.backColor.getRed(), (byte)this.backColor.getGreen(), (byte)this.backColor.getBlue(), (byte)((double)this.backColor.getAlpha() * this.getOpacity()));
                gL.glDisable(3553);
                gL.glBegin(9);
                gL.glVertex3d(0.0, 0.0, 0.0);
                gL.glVertex3d(1.0, 0.0, 0.0);
                gL.glVertex3d(1.0, 1.0, 0.0);
                gL.glVertex3d(0.0, 1.0, 0.0);
                gL.glVertex3d(0.0, 0.0, 0.0);
                gL.glEnd();
                gL.glColor4d(1.0, 1.0, 1.0, this.getOpacity());
                gL.glEnable(3553);
                texture.bind();
                TextureCoords textureCoords = texture.getImageTexCoords();
                drawContext.drawUnitQuad(textureCoords);
                gL.glLoadIdentity();
                gL.glTranslated(vec4.x(), vec4.y(), vec4.z());
                gL.glScaled(d4, d4, 1.0);
                float[] fArray = this.color.getRGBColorComponents(null);
                gL.glColor4d(fArray[0], fArray[1], fArray[2], this.getOpacity());
                gL.glDisable(3553);
                Position position = this.computeGroundPosition(drawContext, drawContext.getView());
                if (position != null) {
                    int n = (int)(d * (position.getLongitude().degrees + 180.0) / 360.0);
                    int n2 = (int)(d2 * (position.getLatitude().degrees + 90.0) / 180.0);
                    int n3 = 10;
                    gL.glBegin(3);
                    gL.glVertex3d(n - n3, n2, 0.0);
                    gL.glVertex3d(n + n3 + 1, n2, 0.0);
                    gL.glEnd();
                    gL.glBegin(3);
                    gL.glVertex3d(n, n2 - n3, 0.0);
                    gL.glVertex3d(n, n2 + n3 + 1, 0.0);
                    gL.glEnd();
                }
                if (this.showFootprint && (arrayList = this.computeViewFootPrint(drawContext, 32)).size() > 0) {
                    gL.glBegin(3);
                    LatLon latLon = arrayList.get(0);
                    for (LatLon latLon2 : arrayList) {
                        int n = (int)(d * (latLon2.getLongitude().degrees + 180.0) / 360.0);
                        int n4 = (int)(d2 * (latLon2.getLatitude().degrees + 90.0) / 180.0);
                        if (LatLon.positionsCrossLongitudeBoundary(latLon, latLon2)) {
                            int n5 = (int)(d2 * (latLon.getLatitude().degrees + 90.0) / 180.0);
                            gL.glVertex3d((double)n < d / 2.0 ? d : 0.0, (n5 + n4) / 2, 0.0);
                            gL.glEnd();
                            gL.glBegin(3);
                            gL.glVertex3d((double)n < d / 2.0 ? 0.0 : d, (n5 + n4) / 2, 0.0);
                        }
                        gL.glVertex3d(n, n4, 0.0);
                        latLon = latLon2;
                    }
                    gL.glEnd();
                }
                gL.glBegin(3);
                gL.glVertex3d(0.0, 0.0, 0.0);
                gL.glVertex3d(d, 0.0, 0.0);
                gL.glVertex3d(d, d2 - 1.0, 0.0);
                gL.glVertex3d(0.0, d2 - 1.0, 0.0);
                gL.glVertex3d(0.0, 0.0, 0.0);
                gL.glEnd();
            } else {
                this.pickSupport.clearPickList();
                this.pickSupport.beginPicking(drawContext);
                Position position = this.computePickPosition(drawContext, vec4, new Dimension((int)(d * d4), (int)(d2 * d4)));
                Color color = drawContext.getUniquePickColor();
                int n = color.getRGB();
                this.pickSupport.addPickableObject(n, this, position, false);
                gL.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                gL.glBegin(9);
                gL.glVertex3d(0.0, 0.0, 0.0);
                gL.glVertex3d(1.0, 0.0, 0.0);
                gL.glVertex3d(1.0, 1.0, 0.0);
                gL.glVertex3d(0.0, 1.0, 0.0);
                gL.glVertex3d(0.0, 0.0, 0.0);
                gL.glEnd();
                this.pickSupport.endPicking(drawContext);
                this.pickSupport.resolvePick(drawContext, drawContext.getPickPoint(), this);
            }
        }
        finally {
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    private double computeScale(Rectangle rectangle) {
        if (this.resizeBehavior.equals(RESIZE_SHRINK_ONLY)) {
            return Math.min(1.0, this.toViewportScale * (double)rectangle.width / this.getScaledIconWidth());
        }
        if (this.resizeBehavior.equals(RESIZE_STRETCH)) {
            return this.toViewportScale * (double)rectangle.width / this.getScaledIconWidth();
        }
        if (this.resizeBehavior.equals(RESIZE_KEEP_FIXED_SIZE)) {
            return 1.0;
        }
        return 1.0;
    }

    private double getScaledIconWidth() {
        return (double)this.iconWidth * this.iconScale;
    }

    private double getScaledIconHeight() {
        return (double)this.iconHeight * this.iconScale;
    }

    private Vec4 computeLocation(Rectangle rectangle, double d) {
        double d2;
        double d3;
        double d4 = this.getScaledIconWidth();
        double d5 = this.getScaledIconHeight();
        double d6 = d * d4;
        double d7 = d * d5;
        if (this.locationCenter != null) {
            d3 = rectangle.getWidth() - d6 / 2.0 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 / 2.0 - (double)this.borderWidth;
        } else if (this.position.equals(NORTHEAST)) {
            d3 = rectangle.getWidth() - d6 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 - (double)this.borderWidth;
        } else if (this.position.equals(SOUTHEAST)) {
            d3 = rectangle.getWidth() - d6 - (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderWidth;
        } else if (this.position.equals(NORTHWEST)) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 - (double)this.borderWidth;
        } else if (this.position.equals(SOUTHWEST)) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderWidth;
        } else {
            d3 = rectangle.getWidth() - d6 / 2.0 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 / 2.0 - (double)this.borderWidth;
        }
        return new Vec4(d3, d2, 0.0);
    }

    private void initializeTexture(DrawContext drawContext) {
        Object object;
        Object object2;
        Texture texture = drawContext.getTextureCache().get(this);
        if (texture != null) {
            return;
        }
        try {
            object2 = this.getClass().getResourceAsStream("/" + this.iconFilePath);
            if (object2 == null && ((File)(object = new File(this.iconFilePath))).exists()) {
                object2 = new FileInputStream((File)object);
            }
            texture = TextureIO.newTexture((InputStream)object2, false, null);
            texture.bind();
            this.iconWidth = texture.getWidth();
            this.iconHeight = texture.getHeight();
            drawContext.getTextureCache().put(this, texture);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("layers.IOExceptionDuringInitialization");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string, iOException);
        }
        object2 = drawContext.getGL();
        object2.glTexEnvf(8960, 8704, 8448.0f);
        object2.glTexParameteri(3553, 10241, 9729);
        object2.glTexParameteri(3553, 10240, 9729);
        object2.glTexParameteri(3553, 10242, 33071);
        object2.glTexParameteri(3553, 10243, 33071);
        object = new int[1];
        object2.glGetIntegerv(34047, (int[])object, 0);
        object2.glTexParameteri(3553, 34046, (int)object[0]);
    }

    private Position computeGroundPosition(DrawContext drawContext, View view) {
        if (view == null) {
            return null;
        }
        Position position = view.computePositionFromScreenPoint(view.getViewport().getWidth() / 2.0, view.getViewport().getHeight() / 2.0);
        if (position == null) {
            return null;
        }
        double d = drawContext.getGlobe().getElevation(position.getLatitude(), position.getLongitude());
        return new Position(position.getLatitude(), position.getLongitude(), d * drawContext.getVerticalExaggeration());
    }

    private Position computePickPosition(DrawContext drawContext, Vec4 vec4, Dimension dimension) {
        Position position = null;
        Point point = drawContext.getPickPoint();
        if (point != null) {
            Rectangle rectangle = drawContext.getView().getViewport();
            if (point.getX() >= vec4.getX() && point.getX() < vec4.getX() + (double)dimension.width && (double)rectangle.height - point.getY() >= vec4.getY() && (double)rectangle.height - point.getY() < vec4.getY() + (double)dimension.height) {
                double d = (point.getX() - vec4.getX()) / (double)dimension.width * 360.0 - 180.0;
                double d2 = ((double)rectangle.height - point.getY() - vec4.getY()) / (double)dimension.height * 180.0 - 90.0;
                position = new Position(Angle.fromDegrees(d2), Angle.fromDegrees(d), this.pickAltitude);
            }
        }
        return position;
    }

    private ArrayList<LatLon> computeViewFootPrint(DrawContext drawContext, int n) {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        Position position = drawContext.getView().getEyePosition();
        Angle angle = Angle.fromRadians(Math.asin(drawContext.getView().computeHorizonDistance() / (drawContext.getGlobe().getRadius() + position.getElevation())));
        if (angle.degrees > 10.0) {
            double d = 360.0 / (double)n;
            Angle angle2 = Angle.ZERO;
            for (int i = 0; i <= n; ++i) {
                LatLon latLon = LatLon.greatCircleEndPosition(position.getLatLon(), angle2, angle);
                arrayList.add(latLon);
                angle2 = angle2.addDegrees(d);
            }
        }
        return arrayList;
    }

    @Override
    public void dispose() {
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private class OrderedIcon
    implements OrderedRenderable {
        private OrderedIcon() {
        }

        public double getDistanceFromEye() {
            return 0.0;
        }

        public void pick(DrawContext drawContext, Point point) {
            WorldMapLayer.this.drawIcon(drawContext);
        }

        public void render(DrawContext drawContext) {
            WorldMapLayer.this.drawIcon(drawContext);
        }
    }
}

