/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.layers.TrackLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.PipeRenderer;
import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.tracks.TrackPointIterator;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackPipesLayer
extends TrackLayer {
    private PipeRenderer pipeRenderer = new PipeRenderer();

    public TrackPipesLayer(Collection<Track> collection) {
        super(collection);
    }

    @Override
    public void setLowerLimit(int n) {
        super.setLowerLimit(n);
        this.pipeRenderer.setLowerLimit(this.getLowerLimit());
    }

    @Override
    public void setUpperLimit(int n) {
        super.setUpperLimit(n);
        this.pipeRenderer.setUpperLimit(this.getUpperLimit());
    }

    public Material getPipeMaterial() {
        return this.pipeRenderer.getPipeMaterial();
    }

    public void setPipeMaterial(Material material) {
        this.pipeRenderer.setPipeMaterial(material);
    }

    public Material getJunctionMaterial() {
        return this.pipeRenderer.getJunctionMaterial();
    }

    public void setJunctionMaterial(Material material) {
        this.pipeRenderer.setJunctionMaterial(material);
    }

    public void setJunctionShape(String string) {
        this.pipeRenderer.setJunctionShape(string);
    }

    public String getJunctionShape() {
        return this.pipeRenderer.getJunctionShape();
    }

    @Override
    public void setElevation(double d) {
        super.setElevation(d);
        this.pipeRenderer.setElevation(d);
    }

    @Override
    public void setOverrideElevation(boolean bl) {
        super.setOverrideElevation(bl);
        this.pipeRenderer.setOverrideElevation(bl);
    }

    @Override
    protected void doDraw(DrawContext drawContext, TrackPointIterator trackPointIterator, Point point) {
        this.pipeRenderer.render(drawContext, trackPointIterator);
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.TrackPipesLayer.Name");
    }
}

