/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.TrackLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.IconRenderer;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.TrackRenderer;
import gov.nasa.worldwind.render.UserFacingIcon;
import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.tracks.TrackPointIterator;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackMarkerLayer
extends TrackLayer {
    private TrackRenderer trackRenderer = new TrackRenderer();
    private IconRenderer iconRenderer = new IconRenderer();
    private UserFacingIcon icon;

    public TrackMarkerLayer(Collection<Track> collection) {
        super(collection);
        this.trackRenderer.setClient(this);
    }

    @Override
    public void dispose() {
        this.trackRenderer.dispose();
    }

    public double getMarkerPixels() {
        return this.trackRenderer.getMarkerPixels();
    }

    public void setMarkerPixels(double d) {
        this.trackRenderer.setMarkerPixels(d);
    }

    public double getMinMarkerSize() {
        return this.trackRenderer.getMinMarkerSize();
    }

    public void setMinMarkerSize(double d) {
        this.trackRenderer.setMinMarkerSize(d);
    }

    @Override
    public void setElevation(double d) {
        super.setElevation(d);
        this.trackRenderer.setElevation(d);
    }

    @Override
    public void setOverrideElevation(boolean bl) {
        super.setOverrideElevation(bl);
        this.trackRenderer.setOverrideElevation(bl);
    }

    public Material getMaterial() {
        return this.trackRenderer.getMaterial();
    }

    public void setMaterial(Material material) {
        this.trackRenderer.setMaterial(material);
    }

    public String getIconFilePath() {
        return this.icon != null ? this.icon.getPath() : null;
    }

    public void setIconFilePath(String string) {
        this.icon = string != null ? new UserFacingIcon(string, null) : null;
    }

    public void setMarkerShape(String string) {
        this.trackRenderer.setShapeType(string);
    }

    @Override
    public void setLowerLimit(int n) {
        super.setLowerLimit(n);
        this.trackRenderer.setLowerLimit(this.getLowerLimit());
    }

    @Override
    public void setUpperLimit(int n) {
        super.setUpperLimit(n);
        this.trackRenderer.setUpperLimit(this.getUpperLimit());
    }

    @Override
    protected void doDraw(DrawContext drawContext, TrackPointIterator trackPointIterator, Point point) {
        Vec4 vec4 = drawContext.isPickingMode() ? this.trackRenderer.pick(drawContext, trackPointIterator, point, this) : this.trackRenderer.render(drawContext, trackPointIterator);
        if (this.icon != null && vec4 != null) {
            if (drawContext.isPickingMode()) {
                this.iconRenderer.pick(drawContext, this.icon, vec4, point, this);
            } else {
                this.iconRenderer.render(drawContext, this.icon, vec4);
            }
        }
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.TrackMarkerLayer.Name");
    }
}

