/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Moon;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;

public class Clementine30Layer
extends BasicTiledImageLayer {
    public Clementine30Layer() {
        super(Clementine30Layer.makeLevels());
        this.setForceLevelZeroLoads(true);
        this.setRetainLevelZeroTiles(true);
    }

    private static LevelSet makeLevels() {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", "Moon/Clementine30");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "http://worldwind28.arc.nasa.gov/TestWebApp/WebForm1.aspx");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", "clementine30xx");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".dds");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 6);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(36.0), Angle.fromDegrees(36.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.FULL_SPHERE);
        return new LevelSet(aVListImpl);
    }

    public String toString() {
        return Logging.getMessage("layers.Moon.Clementine30.Name");
    }
}

