/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import java.util.GregorianCalendar;

public class LandsatI3
extends BasicTiledImageLayer {
    public LandsatI3() {
        super(LandsatI3.makeLevels());
        this.setUseTransparentTextures(true);
        this.setUseMipMaps(true);
    }

    private static LevelSet makeLevels() {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", "Earth/NASA LandSat I3");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "http://worldwind25.arc.nasa.gov/lstile/lstile.aspx");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", "esat_worlddds");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".dds");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 10);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 4);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(36.0), Angle.fromDegrees(36.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.FULL_SPHERE);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ExpiryTime", new GregorianCalendar(2007, 2, 22).getTimeInMillis());
        return new LevelSet(aVListImpl);
    }

    public String toString() {
        return Logging.getMessage("layers.Earth.LandsatI3Layer.Name");
    }
}

