/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;

public abstract class AbstractLayer
extends WWObjectImpl
implements Layer {
    private boolean enabled = true;
    private boolean pickable = true;
    private double opacity = 1.0;
    private double minActiveAltitude = -1.7976931348623157E308;
    private double maxActiveAltitude = Double.MAX_VALUE;

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPickEnabled() {
        return this.pickable;
    }

    public void setPickEnabled(boolean bl) {
        this.pickable = bl;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public String getName() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        return object != null ? object.toString() : this.toString();
    }

    public void setName(String string) {
        this.setValue("gov.nasa.worldwind.avkey.DisplayName", string);
    }

    public String toString() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.DisplayName");
        return object != null ? object.toString() : super.toString();
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        this.opacity = d;
    }

    public double getMinActiveAltitude() {
        return this.minActiveAltitude;
    }

    public void setMinActiveAltitude(double d) {
        this.minActiveAltitude = d;
    }

    public double getMaxActiveAltitude() {
        return this.maxActiveAltitude;
    }

    public void setMaxActiveAltitude(double d) {
        this.maxActiveAltitude = d;
    }

    public double getScale() {
        Object object = this.getValue("gov.nasa.worldwind.avkey.MapScale");
        return object != null && object instanceof Double ? (Double)object : 1.0;
    }

    public boolean isLayerInView(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return true;
    }

    public boolean isLayerActive(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getView()) {
            String string = Logging.getMessage("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Position position = drawContext.getView().getEyePosition();
        if (position == null) {
            return false;
        }
        double d = position.getElevation();
        return d >= this.minActiveAltitude && d <= this.maxActiveAltitude;
    }

    public void render(DrawContext drawContext) {
        if (!this.enabled) {
            return;
        }
        if (null == drawContext) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getGlobe()) {
            String string = Logging.getMessage("layers.AbstractLayer.NoGlobeSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getView()) {
            String string = Logging.getMessage("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!this.isLayerActive(drawContext)) {
            return;
        }
        if (!this.isLayerInView(drawContext)) {
            return;
        }
        this.doRender(drawContext);
    }

    public void pick(DrawContext drawContext, Point point) {
        if (!this.enabled) {
            return;
        }
        if (null == drawContext) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getGlobe()) {
            String string = Logging.getMessage("layers.AbstractLayer.NoGlobeSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (null == drawContext.getView()) {
            String string = Logging.getMessage("layers.AbstractLayer.NoViewSpecifiedInDrawingContext");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!this.isLayerActive(drawContext)) {
            return;
        }
        if (!this.isLayerInView(drawContext)) {
            return;
        }
        this.doPick(drawContext, point);
    }

    protected void doPick(DrawContext drawContext, Point point) {
    }

    public void dispose() {
    }

    protected abstract void doRender(DrawContext var1);

    public boolean isAtMaxResolution() {
        return !this.isMultiResolution();
    }

    public boolean isMultiResolution() {
        return false;
    }

    public String getRestorableState() {
        return null;
    }

    public void restoreState(String string) {
        String string2 = Logging.getMessage("RestorableSupport.RestoreNotSupported");
        Logging.logger().severe(string2);
        throw new UnsupportedOperationException(string2);
    }
}

