/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.WWObject;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.SectorGeometryList;
import gov.nasa.worldwind.globes.Tessellator;
import gov.nasa.worldwind.render.DrawContext;

public interface Globe
extends WWObject,
Extent {
    public Vec4 computePointFromPosition(Angle var1, Angle var2, double var3);

    public Vec4 computeSurfaceNormalAtPoint(Vec4 var1);

    public ElevationModel getElevationModel();

    public Extent getExtent();

    public double getEquatorialRadius();

    public double getPolarRadius();

    public double getMaximumRadius();

    public double getRadiusAt(Angle var1, Angle var2);

    public double getElevation(Angle var1, Angle var2);

    public double getMaxElevation();

    public double getMinElevation();

    public Position getIntersectionPosition(Line var1);

    public double getEccentricitySquared();

    public Position computePositionFromPoint(Vec4 var1);

    public Vec4 computePointFromPosition(Position var1);

    public double getRadiusAt(LatLon var1);

    public double[] getMinAndMaxElevations(Sector var1);

    public Intersection[] intersect(Line var1, double var2);

    public Cylinder computeBoundingCylinder(double var1, Sector var3);

    public Double getBestElevation(Angle var1, Angle var2);

    public Double getElevationAtResolution(Angle var1, Angle var2, double var3);

    public Tessellator getTessellator();

    public void setTessellator(Tessellator var1);

    public SectorGeometryList tessellate(DrawContext var1);

    public Object getStateKey();
}

