/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.BasicElevationModel;
import gov.nasa.worldwind.util.LevelSet;

public class EarthElevationModel
extends BasicElevationModel {
    private static double HEIGHT_OF_MT_EVEREST = 8850.0;
    private static double DEPTH_OF_MARIANAS_TRENCH = -11000.0;

    public EarthElevationModel() {
        super(EarthElevationModel.makeLevels(), DEPTH_OF_MARIANAS_TRENCH, HEIGHT_OF_MT_EVEREST);
        this.setNumExpectedValuesPerTile(22500L);
        String string = Configuration.getStringValue("gov.nasa.worldwind.avkey.ExtremeElevations.SRTM30Plus.FileName");
        if (string != null) {
            this.loadExtremeElevations(string);
        }
    }

    private static LevelSet makeLevels() {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 150);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 150);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", "Earth/srtm30pluszip");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "http://worldwind25.arc.nasa.gov/wwelevation/wwelevation.aspx");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", "srtm30pluszip");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".bil");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 10);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(20.0), Angle.fromDegrees(20.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.FULL_SPHERE);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.SectorResolutionLimits", new LevelSet.SectorResolution[]{new LevelSet.SectorResolution(Sector.fromDegrees(24.0, 50.0, -125.0, -66.8), 9), new LevelSet.SectorResolution(Sector.fromDegrees(18.5, 22.5, -160.5, -154.5), 9), new LevelSet.SectorResolution(Sector.fromDegrees(17.8, 18.7, -67.4, -64.5), 9), new LevelSet.SectorResolution(Sector.fromDegrees(48.0, 108.0, -179.9, -128.0), 9), new LevelSet.SectorResolution(Sector.fromDegrees(-54.0, 60.0, -180.0, 180.0), 8), new LevelSet.SectorResolution(Sector.FULL_SPHERE, 4)});
        return new LevelSet(aVListImpl);
    }
}

