/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

import gov.nasa.worldwind.geom.coords.PolarConverter;

public class UPSConverter {
    public static final int UPS_NO_ERROR = 0;
    private static final int UPS_LAT_ERROR = 1;
    private static final int UPS_LON_ERROR = 2;
    public static final int UPS_HEMISPHERE_ERROR = 4;
    public static final int UPS_EASTING_ERROR = 8;
    public static final int UPS_NORTHING_ERROR = 16;
    private static final int UPS_A_ERROR = 32;
    private static final int UPS_INV_F_ERROR = 64;
    private static final double PI = Math.PI;
    private static final double MAX_LAT = 1.5707963267948966;
    private static final double MIN_NORTH_LAT = 1.4573499254152653;
    private static final double MIN_SOUTH_LAT = -1.387536755335492;
    private static final double MAX_ORIGIN_LAT = 1.4157155848011311;
    private static final double MIN_EAST_NORTH = 0.0;
    private static final double MAX_EAST_NORTH = 4000000.0;
    private static double UPS_Origin_Latitude = 1.4157155848011311;
    private static double UPS_Origin_Longitude = 0.0;
    private static double UPS_a = 6378137.0;
    private static double UPS_f = 0.0033528106647474805;
    private static double UPS_False_Easting = 2000000.0;
    private static double UPS_False_Northing = 2000000.0;
    private static double false_easting = 0.0;
    private static double false_northing = 0.0;
    private static double UPS_Easting = 0.0;
    private static double UPS_Northing = 0.0;
    private static double Easting = 0.0;
    private static double Northing = 0.0;
    private static char Hemisphere = (char)78;
    private static double Latitude = 0.0;
    private static double Longitude = 0.0;

    private UPSConverter() {
    }

    public static long SetUPSParameters(double d, double d2) {
        double d3 = 1.0 / d2;
        if (d <= 0.0) {
            return 32L;
        }
        if (d3 < 250.0 || d3 > 350.0) {
            return 64L;
        }
        UPS_a = d;
        UPS_f = d2;
        return 0L;
    }

    public static long convertGeodeticToUPS(double d, double d2) {
        if (d < -1.5707963267948966 || d > 1.5707963267948966) {
            return 1L;
        }
        if (d < 0.0 && d > -1.387536755335492) {
            return 1L;
        }
        if (d >= 0.0 && d < 1.4573499254152653) {
            return 1L;
        }
        if (d2 < -Math.PI || d2 > Math.PI * 2) {
            return 2L;
        }
        if (d < 0.0) {
            UPS_Origin_Latitude = -1.4157155848011311;
            Hemisphere = (char)83;
        } else {
            UPS_Origin_Latitude = 1.4157155848011311;
            Hemisphere = (char)78;
        }
        PolarConverter.setPolarStereographicParameters(UPS_a, UPS_f, UPS_Origin_Latitude, UPS_Origin_Longitude, false_easting, false_northing);
        PolarConverter.Convert_Geodetic_To_Polar_Stereographic(d, d2);
        UPS_Easting = UPS_False_Easting + PolarConverter.getEasting();
        UPS_Northing = UPS_False_Northing + PolarConverter.getNorthing();
        Easting = UPS_Easting;
        Northing = UPS_Northing;
        return 0L;
    }

    public static double getEasting() {
        return Easting;
    }

    public static double getNorthing() {
        return Northing;
    }

    public static char getHemisphere() {
        return Hemisphere;
    }

    public static long convertUPSToGeodetic(char c, double d, double d2) {
        long l = 0L;
        if (c != 'N' && c != 'S') {
            l |= 4L;
        }
        if (d < 0.0 || d > 4000000.0) {
            l |= 8L;
        }
        if (d2 < 0.0 || d2 > 4000000.0) {
            l |= 0x10L;
        }
        if (c == 'N') {
            UPS_Origin_Latitude = 1.4157155848011311;
        }
        if (c == 'S') {
            UPS_Origin_Latitude = -1.4157155848011311;
        }
        if (l == 0L) {
            PolarConverter.setPolarStereographicParameters(UPS_a, UPS_f, UPS_Origin_Latitude, UPS_Origin_Longitude, UPS_False_Easting, UPS_False_Northing);
            PolarConverter.Convert_Polar_Stereographic_To_Geodetic(d, d2);
            Latitude = PolarConverter.getLatitude();
            Longitude = PolarConverter.getLongitude();
            if (Latitude < 0.0 && Latitude > -1.387536755335492) {
                l |= 1L;
            }
            if (Latitude >= 0.0 && Latitude < 1.4573499254152653) {
                l |= 1L;
            }
        }
        return l;
    }

    public static double getLatitude() {
        return Latitude;
    }

    public static double getLongitude() {
        return Longitude;
    }
}

