/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.formats.tiff.TiffIFDEntry;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeotiffImageReader
extends ImageReader {
    private ImageInputStream theStream = null;
    private ArrayList<TiffIFDEntry[]> ifds = new ArrayList(1);

    public GeotiffImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int n) throws IOException {
        if (n < 0 || n >= this.getNumImages(true)) {
            throw new IllegalArgumentException(this.getClass().getName() + ".getWidth(): illegal imageIndex: " + n);
        }
        TiffIFDEntry tiffIFDEntry = this.getByTag(this.ifds.get(n), 256);
        return (int)tiffIFDEntry.asLong();
    }

    @Override
    public int getHeight(int n) throws IOException {
        if (n < 0 || n >= this.getNumImages(true)) {
            throw new IllegalArgumentException(this.getClass().getName() + ".getHeight(): illegal imageIndex: " + n);
        }
        TiffIFDEntry tiffIFDEntry = this.getByTag(this.ifds.get(n), 257);
        return (int)tiffIFDEntry.asLong();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        if (n != 0) {
            throw new IllegalArgumentException(this.getClass().getName() + ".read(): illegal imageIndex: " + n);
        }
        this.readIFDs();
        TiffIFDEntry tiffIFDEntry = null;
        TiffIFDEntry tiffIFDEntry2 = null;
        TiffIFDEntry tiffIFDEntry3 = null;
        TiffIFDEntry tiffIFDEntry4 = null;
        TiffIFDEntry tiffIFDEntry5 = null;
        TiffIFDEntry tiffIFDEntry6 = null;
        TiffIFDEntry tiffIFDEntry7 = null;
        TiffIFDEntry tiffIFDEntry8 = null;
        TiffIFDEntry tiffIFDEntry9 = null;
        TiffIFDEntry[] tiffIFDEntryArray = this.ifds.get(n);
        block11: for (n2 = 0; n2 < tiffIFDEntryArray.length; ++n2) {
            TiffIFDEntry tiffIFDEntry10 = tiffIFDEntryArray[n2];
            switch (tiffIFDEntry10.tag) {
                case 256: {
                    tiffIFDEntry = tiffIFDEntry10;
                    continue block11;
                }
                case 257: {
                    tiffIFDEntry2 = tiffIFDEntry10;
                    continue block11;
                }
                case 258: {
                    tiffIFDEntry3 = tiffIFDEntry10;
                    continue block11;
                }
                case 277: {
                    tiffIFDEntry4 = tiffIFDEntry10;
                    continue block11;
                }
                case 262: {
                    tiffIFDEntry5 = tiffIFDEntry10;
                    continue block11;
                }
                case 273: {
                    tiffIFDEntry6 = tiffIFDEntry10;
                    continue block11;
                }
                case 279: {
                    tiffIFDEntry7 = tiffIFDEntry10;
                    continue block11;
                }
                case 278: {
                    tiffIFDEntry8 = tiffIFDEntry10;
                    continue block11;
                }
                case 284: {
                    tiffIFDEntry9 = tiffIFDEntry10;
                }
            }
        }
        if (tiffIFDEntry == null || tiffIFDEntry2 == null || tiffIFDEntry4 == null || tiffIFDEntry5 == null || tiffIFDEntry6 == null || tiffIFDEntry7 == null || tiffIFDEntry8 == null || tiffIFDEntry9 == null) {
            throw new IIOException(this.getClass().getName() + ".read(): unable to decipher image organization");
        }
        n2 = (int)tiffIFDEntry.asLong();
        int n3 = (int)tiffIFDEntry2.asLong();
        int n4 = (int)tiffIFDEntry4.asLong();
        long l = tiffIFDEntry5.asLong();
        long l2 = tiffIFDEntry8.asLong();
        long l3 = tiffIFDEntry9.asLong();
        int[] nArray = this.getBitsPerSample(tiffIFDEntry3);
        long[] lArray = this.getStripsArray(tiffIFDEntry6);
        long[] lArray2 = this.getStripsArray(tiffIFDEntry7);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 8) continue;
            throw new IIOException(this.getClass().getName() + ".read(): only expecting 8 bits/sample; found " + nArray[i]);
        }
        ColorSpace colorSpace = n4 > 1 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003);
        int n5 = 1;
        boolean bl = false;
        if (n4 == 4) {
            n5 = 3;
            bl = true;
        }
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray2[i] = i;
        }
        int[] nArray3 = new int[l3 == 1L ? 1 : n4];
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = 0;
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, bl, false, n5, 0);
        ComponentSampleModel componentSampleModel = n4 == 1 ? new ComponentSampleModel(0, n2, n3, 1, n2, nArray2) : (l3 == 1L ? new PixelInterleavedSampleModel(0, n2, n3, n4, n2 * n4, nArray2) : new BandedSampleModel(0, n2, n3, n2, nArray2, nArray3));
        byte[][] byArray = l3 == 1L ? this.readPixelInterleaved(n2, n3, n4, lArray, lArray2) : this.readPlanar(n2, n3, n4, lArray, lArray2, l2);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n2 * n3, nArray3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, false, null);
    }

    private void readIFDs() throws IOException {
        byte[] byArray;
        block6: {
            if (this.theStream != null) {
                return;
            }
            if (this.input == null || !(this.input instanceof ImageInputStream)) {
                throw new IIOException(this.getClass().getName() + ": null/invalid ImageInputStream");
            }
            this.theStream = (ImageInputStream)this.input;
            byArray = new byte[2];
            try {
                this.theStream.readFully(byArray);
                if (byArray[0] == 77 && byArray[1] == 77) {
                    this.theStream.setByteOrder(ByteOrder.BIG_ENDIAN);
                    break block6;
                }
                if (byArray[0] == 73 && byArray[1] == 73) {
                    this.theStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                    break block6;
                }
                throw new IOException();
            }
            catch (IOException iOException) {
                throw new IIOException(this.getClass().getName() + ": error reading signature");
            }
        }
        this.theStream.readFully(byArray);
        long l = this.theStream.readUnsignedInt();
        this.readIFD(l);
    }

    private void readIFD(long l) throws IIOException {
        try {
            this.theStream.seek(l);
            int n = this.theStream.readUnsignedShort();
            TiffIFDEntry[] tiffIFDEntryArray = new TiffIFDEntry[n];
            byte[] byArray = new byte[4];
            for (int i = 0; i < n; ++i) {
                int n2 = this.theStream.readUnsignedShort();
                int n3 = this.theStream.readUnsignedShort();
                long l2 = this.theStream.readUnsignedInt();
                this.theStream.readFully(byArray);
                tiffIFDEntryArray[i] = new TiffIFDEntry(n2, n3, l2, byArray);
            }
            this.ifds.add(tiffIFDEntryArray);
        }
        catch (Exception exception) {
            throw new IIOException("Error reading Tiff IFD: " + exception.getMessage());
        }
    }

    private byte[][] readPixelInterleaved(int n, int n2, int n3, long[] lArray, long[] lArray2) throws IOException {
        byte[][] byArray = new byte[1][n * n2 * n3];
        int n4 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            this.theStream.seek(lArray[i]);
            int n5 = (int)lArray2[i];
            if (n4 + n5 >= byArray[0].length) {
                n5 = byArray[0].length - n4;
            }
            this.theStream.readFully(byArray[0], n4, n5);
            n4 = (int)((long)n4 + lArray2[i]);
        }
        return byArray;
    }

    private byte[][] readPlanar(int n, int n2, int n3, long[] lArray, long[] lArray2, long l) throws IOException {
        byte[][] byArray = new byte[n3][n * n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            this.theStream.seek(lArray[i]);
            int n7 = (int)lArray2[i];
            if (n5 + n7 >= byArray[n4].length) {
                n7 = byArray[n4].length - n5;
            }
            this.theStream.readFully(byArray[n4], n5, n7);
            n5 = (int)((long)n5 + lArray2[i]);
            n6 = (int)((long)n6 + l);
            if (n6 < n2) continue;
            ++n4;
            n6 = 0;
            n5 = 0;
        }
        return byArray;
    }

    private TiffIFDEntry getByTag(TiffIFDEntry[] tiffIFDEntryArray, int n) {
        for (int i = 0; i < tiffIFDEntryArray.length; ++i) {
            if (tiffIFDEntryArray[i].tag != n) continue;
            return tiffIFDEntryArray[i];
        }
        return null;
    }

    private long[] getStripsArray(TiffIFDEntry tiffIFDEntry) throws IOException {
        long[] lArray = new long[(int)tiffIFDEntry.count];
        long l = tiffIFDEntry.asLong();
        this.theStream.seek(l);
        if (tiffIFDEntry.type == 3) {
            int n = 0;
            while ((long)n < tiffIFDEntry.count) {
                lArray[n] = this.theStream.readUnsignedShort();
                ++n;
            }
        } else {
            int n = 0;
            while ((long)n < tiffIFDEntry.count) {
                lArray[n] = this.theStream.readUnsignedInt();
                ++n;
            }
        }
        return lArray;
    }

    private int[] getBitsPerSample(TiffIFDEntry tiffIFDEntry) throws IOException {
        if (tiffIFDEntry == null) {
            return new int[]{1};
        }
        if (tiffIFDEntry.count == 1L) {
            return new int[]{(int)tiffIFDEntry.asLong()};
        }
        long[] lArray = this.getStripsArray(tiffIFDEntry);
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }
}

