/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.csv;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.util.Logging;

public class CSVTrackPoint
implements TrackPoint {
    String time = "";
    private double latitude;
    private double longitude;
    private double altitude;

    public CSVTrackPoint(String[] stringArray) {
        if (stringArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (stringArray.length < 2) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", stringArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doValues(stringArray);
    }

    private void doValues(String[] stringArray) {
        this.latitude = this.parseLatitude(stringArray[1]);
        this.longitude = this.parseLongitude(stringArray[2]);
        if (stringArray.length > 2) {
            this.altitude = this.parseElevation(stringArray[3], "M");
        }
    }

    private double parseLatitude(String string) {
        return string.length() == 0 ? 0.0 : Double.parseDouble(string);
    }

    private double parseLongitude(String string) {
        return string.length() == 0 ? 0.0 : Double.parseDouble(string);
    }

    private double parseElevation(String string, String string2) {
        return string.length() == 0 ? 0.0 : Double.parseDouble(string) * this.unitsToMeters(string2);
    }

    private double unitsToMeters(String string) {
        double d = string.equals("M") ? 1.0 : (string.equals("f") ? 3.2808399 : (string.equals("F") ? 0.5468066528 : 1.0));
        return d;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double d) {
        if (d > 90.0 || d < -90.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = d;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double d) {
        if (d > 180.0 || d < -180.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.longitude = d;
    }

    public Position getPosition() {
        return Position.fromDegrees(this.latitude, this.longitude, this.altitude);
    }

    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = position.getLatitude().getDegrees();
        this.longitude = position.getLongitude().getDegrees();
        this.altitude = position.getElevation();
    }

    public double getElevation() {
        return this.altitude;
    }

    public void setElevation(double d) {
        this.altitude = d;
    }

    public String getTime() {
        return null;
    }

    public void setTime(String string) {
        this.time = string;
    }

    public String toString() {
        return String.format("(%10.8f\u00b0, %11.8f\u00b0, %10.4g m, %s)", this.latitude, this.longitude, this.altitude, this.time);
    }
}

