/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.formats.gpx.GpxReader;
import gov.nasa.worldwind.layers.TrackLayer;
import gov.nasa.worldwind.layers.TrackMarkerLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.tracks.Track;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Tracks
extends ApplicationTemplate {
    private static final String TRACK_FILE = "demodata/tuolumne.gpx";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Tracks", AppFrame.class);
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            TrackMarkerLayer trackMarkerLayer = this.buildTracksLayer();
            trackMarkerLayer.setMaterial(Material.WHITE);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), trackMarkerLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().addSelectListener(new SelectListener(){

                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.getTopObject() != null && selectEvent.getTopPickedObject().getParentLayer() instanceof TrackLayer) {
                        PickedObject pickedObject = selectEvent.getTopPickedObject();
                        System.out.printf("Track position %s, %s\n", pickedObject.getValue("gov.nasa.worldwind.avkey.PickedObject.ID").toString(), pickedObject.getPosition());
                    }
                }
            });
        }

        private TrackMarkerLayer buildTracksLayer() {
            try {
                GpxReader gpxReader = new GpxReader();
                gpxReader.readFile(Tracks.TRACK_FILE);
                List<Track> list = gpxReader.getTracks();
                TrackMarkerLayer trackMarkerLayer = new TrackMarkerLayer(list);
                trackMarkerLayer.setOverrideElevation(true);
                trackMarkerLayer.setElevation(0.0);
                return trackMarkerLayer;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return null;
        }
    }
}

