/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.globes.FlatGlobe;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class FlatWorldPanel
extends JPanel {
    private WorldWindow wwd;
    private FlatGlobe globe;
    private String projection;
    private JComboBox projectionCombo;

    public FlatWorldPanel(WorldWindow worldWindow) {
        super(new GridLayout(0, 1, 0, 0));
        this.wwd = worldWindow;
        this.globe = (FlatGlobe)worldWindow.getModel().getGlobe();
        this.makePanel();
    }

    private JPanel makePanel() {
        FlatWorldPanel flatWorldPanel = this;
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(new JLabel("  Projection:"));
        this.projectionCombo = new JComboBox<String>(new String[]{"Mercator", "Lat-Lon", "Modified Sin.", "Sinusoidal"});
        this.projectionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)FlatWorldPanel.this.projectionCombo.getSelectedItem();
                if (string.equals("Lat-Lon")) {
                    FlatWorldPanel.this.projection = "gov.nasa.worldwind.globes.projectionLatLon";
                } else if (string.equals("Mercator")) {
                    FlatWorldPanel.this.projection = "gov.nasa.worldwind.globes.projectionMercator";
                } else if (string.equals("Sinusoidal")) {
                    FlatWorldPanel.this.projection = "gov.nasa.worldwind.globes.projectionSinusoidal";
                } else if (string.equals("Modified Sin.")) {
                    FlatWorldPanel.this.projection = "gov.nasa.worldwind.globes.projectionModifiedSinusoidal";
                }
                FlatWorldPanel.this.update();
            }
        });
        jPanel.add(this.projectionCombo);
        flatWorldPanel.add(jPanel);
        flatWorldPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Flat World")));
        flatWorldPanel.setToolTipText("Set the current projection");
        return flatWorldPanel;
    }

    private void update() {
        this.globe.setProjection(this.projection);
        this.wwd.redraw();
    }
}

