/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.BasicDragger;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.AnnotationLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.FrameFactory;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwind.render.ScreenAnnotation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Annotations
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Annotations", AppFrame.class);
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private AnnotationLayer layer;
        private Annotation currentAnnotation;
        private static final String IMAGE_WWJ_SPLASH = "images/400x230-splash-nww.png";
        private static final String IMAGE_NASA = "images/32x32-icon-nasa.png";
        private static final String IMAGE_EARTH = "images/32x32-icon-earth.png";
        private JTextArea inputTextArea;
        private JCheckBox cbAdjustWidth;
        private JSlider widthSlider;
        private JSlider heightSlider;
        private JSlider scaleSlider;
        private JSlider opacitySlider;
        private JSlider cornerRadiusSlider;
        private JSlider borderWidthSlider;
        private JSlider stippleFactorSlider;
        private JComboBox cbFontName;
        private JComboBox cbFontStyle;
        private JComboBox cbFontSize;
        private JComboBox cbTextAlign;
        private JComboBox cbShape;
        private JComboBox cbLeader;
        private JComboBox cbImage;
        private JComboBox cbImageRepeat;
        private JComboBox cbAntialias;
        private JComboBox cbTextEffect;
        private JSlider imageOpacitySlider;
        private JSlider imageScaleSlider;
        private JSlider imageOffsetXSlider;
        private JSlider imageOffsetYSlider;
        private JSlider offsetXSlider;
        private JSlider offsetYSlider;
        private JSlider distanceMinScaleSlider;
        private JSlider distanceMaxScaleSlider;
        private JSlider distanceMinOpacitySlider;
        private JSlider highlightScaleSlider;
        private JSpinner insetsTop;
        private JSpinner insetsRight;
        private JSpinner insetsBottom;
        private JSpinner insetsLeft;
        private JButton btTextColor;
        private JButton btBackColor;
        private JButton btBorderColor;
        private JComboBox cbTextColorAlpha;
        private JComboBox cbBackColorAlpha;
        private JComboBox cbBorderColorAlpha;
        private JButton btAdd;
        private JButton btApply;
        private JButton btRemove;
        private boolean suspendUpdate = false;
        private Color savedBorderColor;
        private BufferedImage savedImage;
        private Annotation lastPickedObject;

        public AppFrame() {
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.addRenderable(new GlobeAnnotation("Lat-Lon zero", Position.fromDegrees(0.0, 0.0, 0.0)));
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), renderableLayer);
            this.layer = new AnnotationLayer();
            this.layer.addAnnotation(new GlobeAnnotation("MONACO", Position.fromDegrees(43.734, 7.4211, 0.0), Font.decode("Arial-BOLD-12")));
            this.layer.addAnnotation(new GlobeAnnotation("NICE", Position.fromDegrees(43.696, 7.27, 0.0), Font.decode("Arial-BOLD-12")));
            this.layer.addAnnotation(new GlobeAnnotation("ANTIBES", Position.fromDegrees(43.581, 7.1248, 0.0), Font.decode("Arial-BOLD-12")));
            this.layer.addAnnotation(new GlobeAnnotation("CANNES", Position.fromDegrees(43.5536, 7.0171, 0.0), Font.decode("Arial-BOLD-12")));
            this.layer.addAnnotation(new GlobeAnnotation("GRASSE", Position.fromDegrees(43.659, 6.924, 0.0), Font.decode("Arial-BOLD-12")));
            this.layer.addAnnotation(new GlobeAnnotation("FREJUS", Position.fromDegrees(43.4326, 6.7356, 0.0), Font.decode("Arial-BOLD-12")));
            this.layer.addAnnotation(new GlobeAnnotation("SAINTE MAXIME", Position.fromDegrees(43.3087, 6.6353, 0.0), Font.decode("Arial-BOLD-12")));
            this.layer.addAnnotation(new GlobeAnnotation("SAINT TROPEZ", Position.fromDegrees(43.271, 6.6386, 0.0), Font.decode("Arial-BOLD-12")));
            this.layer.addAnnotation(new GlobeAnnotation("TOULON", Position.fromDegrees(43.1264, 5.9126, 0.0), Font.decode("Arial-BOLD-12")));
            this.layer.addAnnotation(new GlobeAnnotation("MARSEILLE", Position.fromDegrees(43.2904, 5.3806, 0.0), Font.decode("Arial-BOLD-12")));
            this.layer.addAnnotation(new GlobeAnnotation("AIX EN PROVENCE", Position.fromDegrees(43.5286, 5.4485, 0.0), Font.decode("Arial-BOLD-12")));
            this.layer.addAnnotation(new GlobeAnnotation("A\u00e9roport International\nNice C\u00f4te d'Azur", Position.fromDegrees(43.6582, 7.2167, 0.0), Font.decode("Arial-BOLDITALIC-10"), Color.YELLOW));
            this.layer.addAnnotation(new GlobeAnnotation("Sophia Antipolis", Position.fromDegrees(43.6222, 7.0474, 0.0), Font.decode("Arial-BOLDITALIC-10"), Color.YELLOW));
            AnnotationAttributes annotationAttributes = new AnnotationAttributes();
            annotationAttributes.setFrameShape("Render.FrameFactory.ShapeNone");
            annotationAttributes.setFont(Font.decode("Arial-ITALIC-10"));
            annotationAttributes.setTextColor(Color.GREEN);
            annotationAttributes.setTextAlign(1);
            annotationAttributes.setDrawOffset(new Point(0, 5));
            annotationAttributes.setEffect("render.MultiLineTextRenderer.EffectOutline");
            annotationAttributes.setBackgroundColor(Color.BLACK);
            this.layer.addAnnotation(new GlobeAnnotation("Mont Chauve\nFort militaire\nAlt: 853m", Position.fromDegrees(43.7701, 7.2544, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Mont Agel\nFort militaire\nAlt: 1148m", Position.fromDegrees(43.7704, 7.4203, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Cap Ferrat", Position.fromDegrees(43.682, 7.329, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Gorges du Loup", Position.fromDegrees(43.7351, 6.9988, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Cap d'Antibes", Position.fromDegrees(43.5526, 7.1297, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Iles de L\u00e9rins", Position.fromDegrees(43.5125, 7.0467, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Montagne du Cheiron\nAlt: 1778m", Position.fromDegrees(43.8149, 6.9669, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Giens", Position.fromDegrees(43.0394, 6.1384, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Iles de Porquerolles", Position.fromDegrees(42.9974, 6.2147, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Ile du Levent", Position.fromDegrees(43.0315, 6.4702, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Ile de Port Cros", Position.fromDegrees(43.0045, 6.3959, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Montagne Sainte Victoire\nAlt: 1010m", Position.fromDegrees(43.5319, 5.612, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Sainte Baume\nAlt: 1147m", Position.fromDegrees(43.3373, 5.8008, 0.0), annotationAttributes));
            this.layer.addAnnotation(new GlobeAnnotation("Pic de l'Ours\nAlt: 496m", Position.fromDegrees(43.4763, 6.9042, 0.0), annotationAttributes));
            GlobeAnnotation globeAnnotation = new GlobeAnnotation("Lac de Sainte Croix", Position.fromDegrees(43.772, 6.1879, 0.0), Font.decode("Arial-ITALIC-10"), Color.CYAN);
            globeAnnotation.getAttributes().setFrameShape("Render.FrameFactory.ShapeEllipse");
            globeAnnotation.getAttributes().setTextAlign(1);
            globeAnnotation.getAttributes().setInsets(new Insets(8, 12, 9, 12));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Lac de Castillon", Position.fromDegrees(43.9008, 6.5348, 0.0), Font.decode("Arial-ITALIC-10"), Color.CYAN);
            globeAnnotation.getAttributes().setFrameShape("Render.FrameFactory.ShapeEllipse");
            globeAnnotation.getAttributes().setTextAlign(1);
            globeAnnotation.getAttributes().setInsets(new Insets(8, 12, 9, 12));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Lac de Serre Pon\u00e7on", Position.fromDegrees(44.5081, 6.3242, 0.0), Font.decode("Arial-ITALIC-10"), Color.CYAN);
            globeAnnotation.getAttributes().setFrameShape("Render.FrameFactory.ShapeEllipse");
            globeAnnotation.getAttributes().setTextAlign(1);
            globeAnnotation.getAttributes().setInsets(new Insets(8, 12, 9, 12));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Transition Permien-Trias\nDate: 251Ma \nPlus grand \u00e9pisode d'extinction massive.", Position.fromDegrees(44.0551, 7.1215, 0.0), Font.decode("Arial-ITALIC-12"), Color.DARK_GRAY);
            globeAnnotation.getAttributes().setTextAlign(2);
            globeAnnotation.getAttributes().setBackgroundColor(new Color(0.8f, 0.8f, 0.8f, 0.7f));
            globeAnnotation.getAttributes().setBorderColor(Color.BLACK);
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("<p>\n<b><font color=\"#664400\">LA CLAPI\u00c8RE</font></b><br />\n<i>Alt: 1100-1700m</i>\n</p>\n<p>\n<b>Glissement de terrain majeur</b> dans la haute Tin\u00e9e, sur un flanc du <a href=\"http://www.mercantour.eu\">Parc du Mercantour</a>, Alpes Maritimes.\n</p>\n<p>\nRisque aggrav\u00e9 d'<b>inondation</b> du village de <i>Saint \u00c9tienne de Tin\u00e9e</i> juste en amont.\n</p>", Position.fromDegrees(44.2522, 6.9424, 0.0), Font.decode("Serif-PLAIN-14"), Color.DARK_GRAY);
            globeAnnotation.getAttributes().setTextAlign(2);
            globeAnnotation.getAttributes().setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 0.7f));
            globeAnnotation.getAttributes().setBorderColor(Color.BLACK);
            globeAnnotation.getAttributes().setSize(new Dimension(220, 0));
            globeAnnotation.getAttributes().setImageSource(IMAGE_EARTH);
            globeAnnotation.getAttributes().setImageRepeat("render.Annotation.RepeatNone");
            globeAnnotation.getAttributes().setImageOpacity(0.6);
            globeAnnotation.getAttributes().setImageScale(0.7);
            globeAnnotation.getAttributes().setImageOffset(new Point(7, 7));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Latitude: 44.0 N\nLongitude: 7.0 W", Position.fromDegrees(44.0, 7.0, 0.0), Font.decode("Arial-ITALIC-12"), Color.DARK_GRAY);
            globeAnnotation.getAttributes().setTextAlign(1);
            globeAnnotation.getAttributes().setBackgroundColor(new Color(0.9f, 0.9f, 0.8f, 0.7f));
            globeAnnotation.getAttributes().setBorderColor(Color.BLACK);
            globeAnnotation.getAttributes().setBorderWidth(2.0);
            globeAnnotation.getAttributes().setBorderStippleFactor(3);
            globeAnnotation.getAttributes().setAntiAliasHint(4354);
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("SAHARA DESERT\n\nThe Sahara is technically the world's second largest desert after Antarctica.\n\nAt over 9,000,000 square kilometres (3,500,000 sq mi), it covers most parts of northern Africa. ", Position.fromDegrees(22.0, 12.0, 0.0), Font.decode("Arial-BOLD-12"));
            globeAnnotation.getAttributes().setImageSource(IMAGE_NASA);
            globeAnnotation.getAttributes().setImageRepeat("render.Annotation.RepeatY");
            globeAnnotation.getAttributes().setImageOpacity(0.6);
            globeAnnotation.getAttributes().setImageScale(0.7);
            globeAnnotation.getAttributes().setImageOffset(new Point(1, 1));
            globeAnnotation.getAttributes().setInsets(new Insets(6, 28, 6, 6));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Java SDK", Position.fromDegrees(20.0, 0.0, 0.0), Font.decode("Arial-BOLD-14"));
            globeAnnotation.getAttributes().setTextAlign(2);
            globeAnnotation.getAttributes().setImageSource(IMAGE_WWJ_SPLASH);
            globeAnnotation.getAttributes().setImageRepeat("render.Annotation.RepeatNone");
            globeAnnotation.getAttributes().setImageOpacity(0.7);
            globeAnnotation.getAttributes().setImageScale(0.5);
            globeAnnotation.getAttributes().setSize(new Dimension(200, 115));
            globeAnnotation.getAttributes().setAdjustWidthToText("render.Annotation.SizeFixed");
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees(10.0, 100.0, 0.0), Font.decode("Arial-BOLD-16"), Color.GRAY);
            globeAnnotation.getAttributes().setImageSource(PatternFactory.createPattern("PatternFactory.GradientVLinear", new Dimension(32, 128), 1.0f, Color.WHITE, new Color(0.0f, 0.0f, 0.0f, 0.0f)));
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees(10.0, 110.0, 0.0), Font.decode("Arial-BOLD-16"), Color.GRAY);
            globeAnnotation.getAttributes().setImageSource(PatternFactory.createPattern("PatternFactory.GradientVLinear", new Dimension(32, 64), 1.0f, Color.LIGHT_GRAY, Color.WHITE));
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees(10.0, 120.0, 0.0), Font.decode("Arial-BOLD-16"), Color.BLACK);
            globeAnnotation.getAttributes().setImageSource(PatternFactory.createPattern("PatternFactory.PatternDiagonalUp", Color.YELLOW));
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees(0.0, 100.0, 0.0), Font.decode("Arial-BOLD-16"), Color.GRAY);
            globeAnnotation.getAttributes().setImageSource(PatternFactory.createPattern("PatternFactory.GradientHLinear", new Dimension(256, 32), 1.0f, Color.WHITE, new Color(0.0f, 0.0f, 0.0f, 0.0f)));
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees(0.0, 110.0, 0.0), Font.decode("Arial-BOLD-16"), Color.GRAY);
            globeAnnotation.getAttributes().setImageSource(PatternFactory.createPattern("PatternFactory.GradientHLinear", new Dimension(32, 64), 1.0f, Color.LIGHT_GRAY, Color.WHITE));
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees(0.0, 120.0, 0.0), Font.decode("Arial-BOLD-16"), Color.BLACK);
            globeAnnotation.getAttributes().setImageSource(PatternFactory.createPattern("PatternFactory.PatternSquares", Color.YELLOW));
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees(-10.0, 100.0, 0.0), Font.decode("Arial-BOLD-16"), Color.GRAY);
            globeAnnotation.getAttributes().setImageSource(PatternFactory.createPattern("PatternFactory.GradientHLinear", new Dimension(16, 16), 1.0f, Color.BLACK, Color.WHITE));
            globeAnnotation.getAttributes().setImageRepeat("render.Annotation.RepeatY");
            globeAnnotation.getAttributes().setBackgroundColor(Color.WHITE);
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees(-10.0, 110.0, 0.0), Font.decode("Arial-BOLD-16"), Color.GRAY);
            globeAnnotation.getAttributes().setImageSource(PatternFactory.createPattern("PatternFactory.GradientVLinear", new Dimension(16, 16), 1.0f, Color.BLACK, Color.WHITE));
            globeAnnotation.getAttributes().setImageRepeat("render.Annotation.RepeatX");
            globeAnnotation.getAttributes().setBackgroundColor(Color.WHITE);
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Background patterns...", Position.fromDegrees(-10.0, 120.0, 0.0), Font.decode("Arial-BOLD-16"), Color.BLACK);
            globeAnnotation.getAttributes().setImageSource(PatternFactory.createPattern("PatternFactory.PatternHVLine", 0.15f, Color.GREEN));
            globeAnnotation.getAttributes().setImageScale(0.4);
            globeAnnotation.getAttributes().setSize(new Dimension(200, 128));
            this.layer.addAnnotation(globeAnnotation);
            for (int i = 1; i <= 10; ++i) {
                globeAnnotation = new GlobeAnnotation("Pattern scale:" + (float)i / 10.0f, Position.fromDegrees(-20.0, 97 + i * 3, 0.0), Font.decode("Arial-BOLD-16"), Color.GRAY);
                globeAnnotation.getAttributes().setImageSource(PatternFactory.createPattern("PatternFactory.PatternCircles", (float)i / 10.0f, Color.LIGHT_GRAY));
                globeAnnotation.getAttributes().setImageScale(0.4);
                globeAnnotation.getAttributes().setSize(new Dimension(160, 60));
                this.layer.addAnnotation(globeAnnotation);
            }
            class SimpleGlobeAnnotation
            extends GlobeAnnotation {
                TextRenderer textRenderer;
                Font font;

                public SimpleGlobeAnnotation(String string, Position position) {
                    super(string, position);
                    this.font = Font.decode("Arial-PLAIN-12");
                }

                public void drawAnnotation(DrawContext drawContext, Point point, double d, double d2, Position position) {
                    if (this.textRenderer == null) {
                        this.textRenderer = this.getTextRenderer(drawContext, this.font);
                    }
                    String string = this.getText().split("\n")[0];
                    int n = (int)this.textRenderer.getBounds(string).getWidth();
                    Color color = this.getAttributes().getTextColor();
                    Color color2 = this.getAttributes().getBackgroundColor();
                    this.textRenderer.begin3DRendering();
                    this.textRenderer.setColor(color2);
                    this.textRenderer.draw(string, -n / 2 + 1, 11);
                    this.textRenderer.setColor(color);
                    this.textRenderer.draw(string, -n / 2, 12);
                    this.textRenderer.end3DRendering();
                    Color color3 = this.getAttributes().getBorderColor();
                    this.setDrawColor(drawContext, color3);
                    drawContext.getGL().glTranslated(-1.0, -1.0, 0.0);
                    FrameFactory.drawShape(drawContext, "Render.FrameFactory.ShapeRectangle", 3.0, 3.0, 3, 0);
                }
            }
            globeAnnotation = new SimpleGlobeAnnotation("Mount Rainier\nAlt: 4392m", Position.fromDegrees(46.8534, -121.7609, 0.0));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new SimpleGlobeAnnotation("Mount Adams\nAlt: 3742m", Position.fromDegrees(46.2018, -121.4931, 0.0));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new SimpleGlobeAnnotation("Mount Saint Helens\nAlt: 4392m", Position.fromDegrees(46.1991, -122.1882, 0.0));
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("DRAG ME!", Position.fromDegrees(42.0, -118.0, 0.0), Font.decode("Arial-BOLD-18")){

                public void drawAnnotation(DrawContext drawContext, Point point, double d, double d2, Position position) {
                    if (this.getPosition().getLatitude().degrees != 42.0 || this.getPosition().getLongitude().degrees != -118.0) {
                        this.setText(String.format("Lat %7.4f\u00b0\nLon %7.4f\u00b0", this.getPosition().getLatitude().degrees, this.getPosition().getLongitude().degrees));
                    }
                    super.drawAnnotation(drawContext, point, d, d2, position);
                }
            };
            this.layer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("Annotation with extra frames drawn by a render delegate.", Position.fromDegrees(40.0, -116.0, 0.0), Font.decode("Serif-BOLD-18"), Color.DARK_GRAY){

                public void drawAnnotation(DrawContext drawContext, Point point, double d, double d2, Position position) {
                    super.drawAnnotation(drawContext, point, d, d2, position);
                    this.setDrawColor(drawContext, new Color(0.0f, 0.0f, 0.0f, 0.5f * (float)this.alphaFactor));
                    drawContext.getGL().glLineWidth((float)this.scaleFactor);
                    drawContext.getGL().glTranslated(-point.x + this.drawRectangle.x - 3, -point.y + this.drawRectangle.y - 3, 0.0);
                    FrameFactory.drawShape(drawContext, "Render.FrameFactory.ShapeRectangle", this.drawRectangle.width + 6, this.drawRectangle.height + 6, 3, 4);
                    if (this.freeRectangle.height > 0) {
                        drawContext.getGL().glTranslated(3.0, 3.0, 0.0);
                        FrameFactory.drawShape(drawContext, "Render.FrameFactory.ShapeEllipse", this.freeRectangle.width, this.freeRectangle.height, 6, 0);
                    }
                }
            };
            globeAnnotation.getAttributes().setTextAlign(1);
            globeAnnotation.getAttributes().setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 0.7f));
            globeAnnotation.getAttributes().setBorderColor(Color.BLACK);
            globeAnnotation.getAttributes().setSize(new Dimension(160, 200));
            this.layer.addAnnotation(globeAnnotation);
            ScreenAnnotation screenAnnotation = new ScreenAnnotation("Fixed position annotation", new Point(20, 20));
            screenAnnotation.getAttributes().setCornerRadius(0);
            screenAnnotation.getAttributes().setSize(new Dimension(200, 0));
            screenAnnotation.getAttributes().setAdjustWidthToText("render.Annotation.SizeFixed");
            screenAnnotation.getAttributes().setDrawOffset(new Point(100, 0));
            screenAnnotation.getAttributes().setHighlightScale(1.0);
            this.layer.addAnnotation(screenAnnotation);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.layer);
            this.getLayerPanel().update(this.getWwd());
            this.getLayerPanel().add((Component)this.makeControlPanel(), "South");
            this.getWwd().addSelectListener(new SelectListener(){
                private BasicDragger dragger;
                {
                    this.dragger = new BasicDragger(AppFrame.this.getWwd());
                }

                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                        if (selectEvent.hasObjects()) {
                            if (selectEvent.getTopObject() instanceof Annotation) {
                                PickedObject pickedObject = selectEvent.getTopPickedObject();
                                if (pickedObject.getValue("gov.nasa.worldwind.avkey.Text") != null) {
                                    System.out.println("Text: \"" + pickedObject.getValue("gov.nasa.worldwind.avkey.Text") + "\" Hyperlink: " + pickedObject.getValue("gov.nasa.worldwind.avkey.URL"));
                                    if (AppFrame.this.currentAnnotation == selectEvent.getTopObject()) {
                                        return;
                                    }
                                }
                                if (AppFrame.this.currentAnnotation != null) {
                                    AppFrame.this.currentAnnotation.getAttributes().setBorderColor(AppFrame.this.savedBorderColor);
                                }
                                if (AppFrame.this.currentAnnotation != selectEvent.getTopObject()) {
                                    AppFrame.this.currentAnnotation = (Annotation)selectEvent.getTopObject();
                                    AppFrame.this.savedBorderColor = AppFrame.this.currentAnnotation.getAttributes().getBorderColor();
                                    AppFrame.this.savedImage = AppFrame.this.currentAnnotation.getAttributes().getImageSource() instanceof BufferedImage ? (BufferedImage)AppFrame.this.currentAnnotation.getAttributes().getImageSource() : null;
                                    AppFrame.this.currentAnnotation.getAttributes().setBorderColor(Color.YELLOW);
                                } else {
                                    AppFrame.this.currentAnnotation = null;
                                }
                                AppFrame.this.updateControlPanel();
                            } else {
                                System.out.println("Left click on " + selectEvent.getTopObject());
                            }
                        }
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && !this.dragger.isDragging()) {
                        AppFrame.this.highlight(selectEvent.getTopObject());
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
                        PickedObjectList pickedObjectList;
                        if (selectEvent.hasObjects() && selectEvent.getTopObject() == AppFrame.this.currentAnnotation) {
                            this.dragger.selected(selectEvent);
                        }
                        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") && (pickedObjectList = AppFrame.this.getWwd().getObjectsAtCurrentPosition()) != null) {
                            AppFrame.this.highlight(pickedObjectList.getTopObject());
                            AppFrame.this.getWwd().repaint();
                        }
                    }
                }
            });
        }

        private void highlight(Object object) {
            if (this.lastPickedObject == object) {
                return;
            }
            if (this.lastPickedObject != null) {
                this.lastPickedObject.getAttributes().setHighlighted(false);
                this.lastPickedObject = null;
            }
            if (object != null && object instanceof Annotation) {
                this.lastPickedObject = (Annotation)object;
                this.lastPickedObject.getAttributes().setHighlighted(true);
            }
        }

        private JPanel makeControlPanel() {
            this.inputTextArea = new JTextArea();
            this.inputTextArea.setFont(new Font("Sans_Serif", 0, 16));
            this.inputTextArea.setLineWrap(true);
            this.inputTextArea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane(this.inputTextArea);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setPreferredSize(new Dimension(200, 100));
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Width and Height")));
            this.widthSlider = new JSlider(0, 0, 800, 160);
            this.widthSlider.setMajorTickSpacing(100);
            this.widthSlider.setMinorTickSpacing(10);
            this.widthSlider.setPaintLabels(true);
            this.widthSlider.setToolTipText("Preferred annotation width");
            this.widthSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel.add(this.widthSlider);
            this.heightSlider = new JSlider(0, 0, 800, 0);
            this.heightSlider.setMajorTickSpacing(100);
            this.heightSlider.setMinorTickSpacing(10);
            this.heightSlider.setPaintLabels(true);
            this.heightSlider.setToolTipText("Preferred annotation height, zero = no limit");
            this.heightSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel.add(this.heightSlider);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel2.add(new JLabel("Corner radius:"));
            jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
            this.cornerRadiusSlider = new JSlider(0, 0, 50, 10);
            this.cornerRadiusSlider.setMajorTickSpacing(10);
            this.cornerRadiusSlider.setMinorTickSpacing(1);
            this.cornerRadiusSlider.setPaintLabels(true);
            this.cornerRadiusSlider.setToolTipText("Rounded corners radius");
            this.cornerRadiusSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel2.add(this.cornerRadiusSlider);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel3.add(new JLabel("Insets:"));
            jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
            this.insetsTop = new JSpinner();
            this.insetsTop.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            this.insetsRight = new JSpinner();
            this.insetsRight.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            this.insetsBottom = new JSpinner();
            this.insetsBottom.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            this.insetsLeft = new JSpinner();
            this.insetsLeft.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel3.add(this.insetsTop);
            jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel3.add(this.insetsRight);
            jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel3.add(this.insetsBottom);
            jPanel3.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel3.add(this.insetsLeft);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel4.add(new JLabel("Border width:"));
            jPanel4.add(Box.createRigidArea(new Dimension(10, 0)));
            this.borderWidthSlider = new JSlider(0, 0, 50, 10);
            this.borderWidthSlider.setMajorTickSpacing(10);
            this.borderWidthSlider.setMinorTickSpacing(1);
            this.borderWidthSlider.setPaintLabels(true);
            this.borderWidthSlider.setToolTipText("Border width 1/10th");
            this.borderWidthSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel4.add(this.borderWidthSlider);
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel5.add(new JLabel("Stipple factor:"));
            jPanel5.add(Box.createRigidArea(new Dimension(10, 0)));
            this.stippleFactorSlider = new JSlider(0, 0, 10, 0);
            this.stippleFactorSlider.setMajorTickSpacing(1);
            this.stippleFactorSlider.setPaintLabels(true);
            this.stippleFactorSlider.setToolTipText("Border line pattern repeat factor");
            this.stippleFactorSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel5.add(this.stippleFactorSlider);
            JPanel jPanel6 = new JPanel(new GridLayout(0, 2, 5, 5));
            jPanel6.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel6.add(new JLabel("Antialias:"));
            this.cbAntialias = new JComboBox<String>(new String[]{"Dont care", "Fastest", "Nicest"});
            this.cbAntialias.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel6.add(this.cbAntialias);
            JPanel jPanel7 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel7.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Scale and Opacity")));
            this.scaleSlider = new JSlider(0, 0, 30, 10);
            this.scaleSlider.setMajorTickSpacing(10);
            this.scaleSlider.setMinorTickSpacing(1);
            this.scaleSlider.setPaintLabels(true);
            this.scaleSlider.setToolTipText("Annotation scaling");
            this.scaleSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel7.add(this.scaleSlider);
            this.opacitySlider = new JSlider(0, 0, 10, 10);
            this.opacitySlider.setMajorTickSpacing(1);
            this.opacitySlider.setPaintLabels(true);
            this.opacitySlider.setToolTipText("Annotation opacity");
            this.opacitySlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel7.add(this.opacitySlider);
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout(new BoxLayout(jPanel8, 0));
            jPanel8.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel8.add(new JLabel("Font"));
            jPanel8.add(Box.createRigidArea(new Dimension(10, 0)));
            this.cbFontName = new JComboBox<String>(new String[]{"Arial", "SansSerif", "Serif", "Courier", "Times", "Helvetica", "Trebuchet", "Tahoma"});
            this.cbFontName.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel8.add(this.cbFontName);
            jPanel8.add(Box.createRigidArea(new Dimension(10, 0)));
            this.cbFontStyle = new JComboBox<String>(new String[]{"Plain", "Bold", "Italic", "BoldItalic"});
            this.cbFontStyle.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel8.add(this.cbFontStyle);
            jPanel8.add(Box.createRigidArea(new Dimension(10, 0)));
            this.cbFontSize = new JComboBox<String>(new String[]{"10", "12", "14", "16", "18", "20", "24", "28", "34", "48", "64"});
            this.cbFontSize.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel8.add(this.cbFontSize);
            JPanel jPanel9 = new JPanel(new GridLayout(0, 3, 5, 5));
            jPanel9.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel9.add(new JLabel("Align & Effect:"));
            this.cbTextAlign = new JComboBox<String>(new String[]{"Left", "Center", "Right"});
            this.cbTextAlign.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel9.add(this.cbTextAlign);
            this.cbTextEffect = new JComboBox<String>(new String[]{"None", "Shadow", "Outline"});
            this.cbTextEffect.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel9.add(this.cbTextEffect);
            JPanel jPanel10 = new JPanel(new GridLayout(0, 1, 5, 5));
            jPanel10.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.cbAdjustWidth = new JCheckBox("Adjust width to text");
            this.cbAdjustWidth.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            this.cbAdjustWidth.setSelected(true);
            jPanel10.add(this.cbAdjustWidth);
            JPanel jPanel11 = new JPanel(new GridLayout(0, 2, 5, 5));
            jPanel11.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel11.add(new JLabel("Shape:"));
            this.cbShape = new JComboBox<String>(new String[]{"Rectangle", "Ellipse", "None"});
            this.cbShape.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel11.add(this.cbShape);
            jPanel11.add(new JLabel("Leader:"));
            this.cbLeader = new JComboBox<String>(new String[]{"Triangle", "None"});
            this.cbLeader.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel11.add(this.cbLeader);
            JPanel jPanel12 = new JPanel(new GridLayout(0, 2, 5, 5));
            jPanel12.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel12.add(new JLabel("Image:"));
            this.cbImage = new JComboBox<String>(new String[]{"None", "Earth", "NASA", "WWJ Splash", "Custom"});
            this.cbImage.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel12.add(this.cbImage);
            jPanel12.add(new JLabel("Repeat:"));
            this.cbImageRepeat = new JComboBox<String>(new String[]{"None", "Repeat-X", "Repeat-Y", "Repeat-XY"});
            this.cbImageRepeat.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel12.add(this.cbImageRepeat);
            JPanel jPanel13 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel13.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Scale and Opacity")));
            this.imageScaleSlider = new JSlider(0, 0, 30, 10);
            this.imageScaleSlider.setMajorTickSpacing(10);
            this.imageScaleSlider.setMinorTickSpacing(1);
            this.imageScaleSlider.setPaintLabels(true);
            this.imageScaleSlider.setToolTipText("Background image scaling");
            this.imageScaleSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel13.add(this.imageScaleSlider);
            this.imageOpacitySlider = new JSlider(0, 0, 10, 10);
            this.imageOpacitySlider.setMajorTickSpacing(1);
            this.imageOpacitySlider.setPaintLabels(true);
            this.imageOpacitySlider.setToolTipText("Background image opacity");
            this.imageOpacitySlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel13.add(this.imageOpacitySlider);
            JPanel jPanel14 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel14.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Offset")));
            this.imageOffsetXSlider = new JSlider(0, -200, 200, 0);
            this.imageOffsetXSlider.setMajorTickSpacing(100);
            this.imageOffsetXSlider.setMinorTickSpacing(1);
            this.imageOffsetXSlider.setPaintLabels(true);
            this.imageOffsetXSlider.setToolTipText("Background image horizontal offset (X)");
            this.imageOffsetXSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel14.add(this.imageOffsetXSlider);
            this.imageOffsetYSlider = new JSlider(0, -200, 200, 0);
            this.imageOffsetYSlider.setMajorTickSpacing(100);
            this.imageOffsetXSlider.setMinorTickSpacing(1);
            this.imageOffsetYSlider.setPaintLabels(true);
            this.imageOffsetYSlider.setToolTipText("Background image vertical offset (Y)");
            this.imageOffsetYSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel14.add(this.imageOffsetYSlider);
            JPanel jPanel15 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel15.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Draw offset")));
            this.offsetXSlider = new JSlider(0, -200, 200, 0);
            this.offsetXSlider.setMajorTickSpacing(100);
            this.offsetXSlider.setMinorTickSpacing(1);
            this.offsetXSlider.setPaintLabels(true);
            this.offsetXSlider.setToolTipText("Annotation horizontal offset (X)");
            this.offsetXSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel15.add(this.offsetXSlider);
            this.offsetYSlider = new JSlider(0, 0, 200, 0);
            this.offsetYSlider.setMajorTickSpacing(100);
            this.offsetYSlider.setMinorTickSpacing(1);
            this.offsetYSlider.setPaintLabels(true);
            this.offsetYSlider.setToolTipText("Annotation vertical offset (Y)");
            this.offsetYSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel15.add(this.offsetYSlider);
            JPanel jPanel16 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel16.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Distance min/max scale and opacity")));
            this.distanceMinScaleSlider = new JSlider(0, 0, 30, 10);
            this.distanceMinScaleSlider.setMajorTickSpacing(10);
            this.distanceMinScaleSlider.setMinorTickSpacing(1);
            this.distanceMinScaleSlider.setPaintLabels(true);
            this.distanceMinScaleSlider.setToolTipText("Minimum scale 1/10th");
            this.distanceMinScaleSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel16.add(this.distanceMinScaleSlider);
            this.distanceMaxScaleSlider = new JSlider(0, 0, 30, 10);
            this.distanceMaxScaleSlider.setMajorTickSpacing(10);
            this.distanceMaxScaleSlider.setMinorTickSpacing(1);
            this.distanceMaxScaleSlider.setPaintLabels(true);
            this.distanceMaxScaleSlider.setToolTipText("Maximum scale 1/10th");
            this.distanceMaxScaleSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel16.add(this.distanceMaxScaleSlider);
            this.distanceMinOpacitySlider = new JSlider(0, 0, 10, 10);
            this.distanceMinOpacitySlider.setMajorTickSpacing(1);
            this.distanceMinOpacitySlider.setPaintLabels(true);
            this.distanceMinOpacitySlider.setToolTipText("Minimum opacity");
            this.distanceMinOpacitySlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel16.add(this.distanceMinOpacitySlider);
            JPanel jPanel17 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel17.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new TitledBorder("Highlight scale")));
            this.highlightScaleSlider = new JSlider(0, 0, 30, 10);
            this.highlightScaleSlider.setMajorTickSpacing(10);
            this.highlightScaleSlider.setMinorTickSpacing(1);
            this.highlightScaleSlider.setPaintLabels(true);
            this.highlightScaleSlider.setToolTipText("Highlight scale 1/10th");
            this.highlightScaleSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel17.add(this.highlightScaleSlider);
            final JPanel jPanel18 = new JPanel(new GridLayout(0, 3, 5, 5));
            jPanel18.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel18.add(new JLabel("Text color:"));
            this.btTextColor = new JButton("");
            this.btTextColor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(jPanel18, "Choose a color...", ((JButton)actionEvent.getSource()).getBackground());
                    if (color != null) {
                        ((JButton)actionEvent.getSource()).setBackground(color);
                        if (AppFrame.this.currentAnnotation != null) {
                            AppFrame.this.updateAnnotation();
                        }
                    }
                }
            });
            jPanel18.add(this.btTextColor);
            this.cbTextColorAlpha = new JComboBox<String>(new String[]{"10", "9", "8", "7", "6", "5", "4", "3", "2", "1", "0"});
            this.cbTextColorAlpha.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel18.add(this.cbTextColorAlpha);
            jPanel18.add(new JLabel("Back color:"));
            this.btBackColor = new JButton("");
            this.btBackColor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(jPanel18, "Choose a color...", ((JButton)actionEvent.getSource()).getBackground());
                    if (color != null) {
                        ((JButton)actionEvent.getSource()).setBackground(color);
                        if (AppFrame.this.currentAnnotation != null) {
                            AppFrame.this.updateAnnotation();
                        }
                    }
                }
            });
            jPanel18.add(this.btBackColor);
            this.cbBackColorAlpha = new JComboBox<String>(new String[]{"10", "9", "8", "7", "6", "5", "4", "3", "2", "1", "0"});
            this.cbBackColorAlpha.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel18.add(this.cbBackColorAlpha);
            jPanel18.add(new JLabel("Border color:"));
            this.btBorderColor = new JButton("");
            this.btBorderColor.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(jPanel18, "Choose a color...", ((JButton)actionEvent.getSource()).getBackground());
                    if (color != null) {
                        ((JButton)actionEvent.getSource()).setBackground(color);
                        if (AppFrame.this.currentAnnotation != null) {
                            AppFrame.this.updateAnnotation();
                        }
                    }
                }
            });
            jPanel18.add(this.btBorderColor);
            this.cbBorderColorAlpha = new JComboBox<String>(new String[]{"10", "9", "8", "7", "6", "5", "4", "3", "2", "1", "0"});
            this.cbBorderColorAlpha.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            jPanel18.add(this.cbBorderColorAlpha);
            JPanel jPanel19 = new JPanel();
            jPanel19.setLayout(new BoxLayout(jPanel19, 0));
            jPanel19.setBorder(BorderFactory.createEmptyBorder(14, 4, 4, 4));
            this.btApply = new JButton("Apply");
            this.btApply.setEnabled(false);
            this.btApply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.updateAnnotation();
                    }
                }
            });
            this.btAdd = new JButton("Add new");
            this.btAdd.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Position position = AppFrame.this.computeGroundPosition(AppFrame.this.getWwd());
                    if (position != null && AppFrame.this.inputTextArea.getText().length() > 0) {
                        Annotation annotation = AppFrame.this.currentAnnotation;
                        AppFrame.this.currentAnnotation = new GlobeAnnotation(AppFrame.this.inputTextArea.getText(), position);
                        AppFrame.this.updateAnnotation();
                        AppFrame.this.layer.addAnnotation(AppFrame.this.currentAnnotation);
                        AppFrame.this.currentAnnotation = annotation;
                        AppFrame.this.getWwd().repaint();
                    }
                }
            });
            this.btRemove = new JButton("Remove");
            this.btRemove.setEnabled(false);
            this.btRemove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (AppFrame.this.currentAnnotation != null) {
                        AppFrame.this.layer.removeAnnotation(AppFrame.this.currentAnnotation);
                        AppFrame.this.currentAnnotation = null;
                        AppFrame.this.inputTextArea.setText("");
                        AppFrame.this.widthSlider.setEnabled(false);
                        AppFrame.this.btApply.setEnabled(false);
                        AppFrame.this.btRemove.setEnabled(false);
                        AppFrame.this.getWwd().repaint();
                    }
                }
            });
            jPanel19.add(this.btAdd);
            jPanel19.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel19.add(this.btApply);
            jPanel19.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel19.add(this.btRemove);
            JTabbedPane jTabbedPane = new JTabbedPane();
            JPanel jPanel20 = new JPanel();
            jPanel20.setLayout(new BoxLayout(jPanel20, 1));
            jPanel20.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
            jPanel20.setToolTipText("Text and Colors");
            jPanel20.add(jScrollPane);
            jPanel20.add(jPanel8);
            jPanel20.add(jPanel9);
            jPanel20.add(jPanel18);
            jTabbedPane.add(jPanel20);
            jTabbedPane.setTitleAt(0, "Text");
            jPanel20 = new JPanel();
            jPanel20.setLayout(new BoxLayout(jPanel20, 1));
            jPanel20.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
            jPanel20.setToolTipText("Size, scale and opacity");
            jPanel20.add(jPanel10);
            jPanel20.add(jPanel);
            jPanel20.add(jPanel7);
            jTabbedPane.add(jPanel20);
            jTabbedPane.setTitleAt(1, "Size");
            jPanel20 = new JPanel();
            jPanel20.setLayout(new BoxLayout(jPanel20, 1));
            jPanel20.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
            jPanel20.setToolTipText("Shape, insets, corner radius, border width and patterns");
            jPanel20.add(jPanel11);
            jPanel20.add(jPanel2);
            jPanel20.add(jPanel3);
            jPanel20.add(jPanel4);
            jPanel20.add(jPanel5);
            jPanel20.add(jPanel6);
            jTabbedPane.add(jPanel20);
            jTabbedPane.setTitleAt(2, "Shape");
            jPanel20 = new JPanel();
            jPanel20.setLayout(new BoxLayout(jPanel20, 1));
            jPanel20.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
            jPanel20.setToolTipText("Background image texture controls");
            jPanel20.add(jPanel12);
            jPanel20.add(jPanel13);
            jPanel20.add(jPanel14);
            jTabbedPane.add(jPanel20);
            jTabbedPane.setTitleAt(3, "Image");
            jPanel20 = new JPanel();
            jPanel20.setLayout(new BoxLayout(jPanel20, 1));
            jPanel20.setBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9));
            jPanel20.setToolTipText("Offset, distance scaling and fading, highlight");
            jPanel20.add(jPanel15);
            jPanel20.add(jPanel16);
            jPanel20.add(jPanel17);
            jTabbedPane.add(jPanel20);
            jTabbedPane.setTitleAt(4, "Misc.");
            jPanel20 = new JPanel();
            jPanel20.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Annotation")));
            jPanel20.setToolTipText("Current or new annotation");
            jPanel20.setLayout(new BorderLayout());
            jPanel20.add((Component)jTabbedPane, "North");
            jPanel20.add((Component)jPanel19, "South");
            return jPanel20;
        }

        private void updateControlPanel() {
            if (this.currentAnnotation != null) {
                String string;
                this.suspendUpdate = true;
                this.inputTextArea.setText(this.currentAnnotation.getText());
                this.widthSlider.setValue(this.currentAnnotation.getAttributes().getSize().width);
                this.heightSlider.setValue(this.currentAnnotation.getAttributes().getSize().height);
                this.scaleSlider.setValue((int)(this.currentAnnotation.getAttributes().getScale() * 10.0));
                this.opacitySlider.setValue((int)(this.currentAnnotation.getAttributes().getOpacity() * 10.0));
                this.cbAdjustWidth.setSelected(this.currentAnnotation.getAttributes().getAdjustWidthToText().equals("render.Annotation.SizeFitText"));
                Font font = this.currentAnnotation.getAttributes().getFont();
                if (font != null) {
                    this.cbFontName.setSelectedItem(font.getName());
                    this.cbFontStyle.setSelectedIndex(font.getStyle());
                    this.cbFontSize.setSelectedItem(String.valueOf(font.getSize()));
                } else {
                    this.cbFontName.setSelectedItem("Arial");
                    this.cbFontStyle.setSelectedItem("Plain");
                    this.cbFontSize.setSelectedItem("12");
                }
                Color color = this.currentAnnotation.getAttributes().getTextColor();
                String string2 = color != null ? String.valueOf(Math.round((float)color.getAlpha() / 25.5f)) : "8";
                this.btTextColor.setBackground(color != null ? new Color(color.getRed(), color.getGreen(), color.getBlue()) : Color.WHITE);
                this.cbTextColorAlpha.setSelectedItem(string2);
                color = this.currentAnnotation.getAttributes().getBackgroundColor();
                string2 = color != null ? String.valueOf(Math.round((float)color.getAlpha() / 25.5f)) : "4";
                this.btBackColor.setBackground(color != null ? new Color(color.getRed(), color.getGreen(), color.getBlue()) : Color.BLACK);
                this.cbBackColorAlpha.setSelectedItem(string2);
                color = this.savedBorderColor;
                string2 = color != null ? String.valueOf(Math.round((float)color.getAlpha() / 25.5f)) : "7";
                this.btBorderColor.setBackground(color != null ? new Color(color.getRed(), color.getGreen(), color.getBlue()) : Color.WHITE);
                this.cbBorderColorAlpha.setSelectedItem(string2);
                switch (this.currentAnnotation.getAttributes().getTextAlign()) {
                    case 0: {
                        this.cbTextAlign.setSelectedIndex(0);
                        break;
                    }
                    case 1: {
                        this.cbTextAlign.setSelectedIndex(1);
                        break;
                    }
                    case 2: {
                        this.cbTextAlign.setSelectedIndex(2);
                    }
                }
                if (this.currentAnnotation.getAttributes().getEffect().equals("render.MultiLineTextRenderer.EffectNone")) {
                    this.cbTextEffect.setSelectedIndex(0);
                } else if (this.currentAnnotation.getAttributes().getEffect().equals("render.MultiLineTextRenderer.EffectShadow")) {
                    this.cbTextEffect.setSelectedIndex(1);
                } else if (this.currentAnnotation.getAttributes().getEffect().equals("render.MultiLineTextRenderer.EffectOutline")) {
                    this.cbTextEffect.setSelectedIndex(2);
                }
                if (this.currentAnnotation.getAttributes().getFrameShape().equals("Render.FrameFactory.ShapeRectangle")) {
                    this.cbShape.setSelectedIndex(0);
                } else if (this.currentAnnotation.getAttributes().getFrameShape().equals("Render.FrameFactory.ShapeEllipse")) {
                    this.cbShape.setSelectedIndex(1);
                } else {
                    this.cbShape.setSelectedIndex(2);
                }
                if (this.currentAnnotation.getAttributes().getLeader().equals("Render.FrameFactory.LeaderTriangle")) {
                    this.cbLeader.setSelectedIndex(0);
                } else {
                    this.cbLeader.setSelectedIndex(1);
                }
                this.cornerRadiusSlider.setValue(this.currentAnnotation.getAttributes().getCornerRadius());
                Insets insets = this.currentAnnotation.getAttributes().getInsets();
                this.insetsTop.setValue(insets.top);
                this.insetsRight.setValue(insets.right);
                this.insetsBottom.setValue(insets.bottom);
                this.insetsLeft.setValue(insets.left);
                this.borderWidthSlider.setValue((int)(this.currentAnnotation.getAttributes().getBorderWidth() * 10.0));
                this.stippleFactorSlider.setValue(this.currentAnnotation.getAttributes().getBorderStippleFactor());
                switch (this.currentAnnotation.getAttributes().getAntiAliasHint()) {
                    case 4352: {
                        this.cbAntialias.setSelectedIndex(0);
                        break;
                    }
                    case 4353: {
                        this.cbAntialias.setSelectedIndex(1);
                        break;
                    }
                    case 4354: {
                        this.cbAntialias.setSelectedIndex(2);
                    }
                }
                if (this.currentAnnotation.getAttributes().getImageSource() != null) {
                    if (this.currentAnnotation.getAttributes().getImageSource() instanceof String) {
                        string = (String)this.currentAnnotation.getAttributes().getImageSource();
                        if (string.equals(IMAGE_EARTH)) {
                            this.cbImage.setSelectedIndex(1);
                        } else if (string.equals(IMAGE_NASA)) {
                            this.cbImage.setSelectedIndex(2);
                        } else if (string.equals(IMAGE_WWJ_SPLASH)) {
                            this.cbImage.setSelectedIndex(3);
                        } else {
                            this.cbImage.setSelectedIndex(4);
                        }
                    } else {
                        this.cbImage.setSelectedIndex(4);
                    }
                } else {
                    this.cbImage.setSelectedIndex(0);
                }
                string = this.currentAnnotation.getAttributes().getImageRepeat();
                if (string.equals("render.Annotation.RepeatNone")) {
                    this.cbImageRepeat.setSelectedIndex(0);
                } else if (string.equals("render.Annotation.RepeatX")) {
                    this.cbImageRepeat.setSelectedIndex(1);
                } else if (string.equals("render.Annotation.RepeatY")) {
                    this.cbImageRepeat.setSelectedIndex(2);
                } else if (string.equals("render.Annotation.RepeatXY")) {
                    this.cbImageRepeat.setSelectedIndex(3);
                }
                this.imageScaleSlider.setValue((int)(this.currentAnnotation.getAttributes().getImageScale() * 10.0));
                this.imageOpacitySlider.setValue((int)(this.currentAnnotation.getAttributes().getImageOpacity() * 10.0));
                this.imageOffsetXSlider.setValue(this.currentAnnotation.getAttributes().getImageOffset().x);
                this.imageOffsetYSlider.setValue(this.currentAnnotation.getAttributes().getImageOffset().y);
                this.offsetXSlider.setValue(this.currentAnnotation.getAttributes().getDrawOffset().x);
                this.offsetYSlider.setValue(this.currentAnnotation.getAttributes().getDrawOffset().y);
                this.distanceMinScaleSlider.setValue((int)(this.currentAnnotation.getAttributes().getDistanceMinScale() * 10.0));
                this.distanceMaxScaleSlider.setValue((int)(this.currentAnnotation.getAttributes().getDistanceMaxScale() * 10.0));
                this.distanceMinOpacitySlider.setValue((int)(this.currentAnnotation.getAttributes().getDistanceMinOpacity() * 10.0));
                this.highlightScaleSlider.setValue((int)(this.currentAnnotation.getAttributes().getHighlightScale() * 10.0));
                this.btApply.setEnabled(true);
                this.btRemove.setEnabled(true);
                this.suspendUpdate = false;
            } else {
                this.inputTextArea.setText("");
                this.btApply.setEnabled(false);
                this.btRemove.setEnabled(false);
            }
        }

        private void updateAnnotation() {
            if (this.currentAnnotation != null && !this.suspendUpdate) {
                this.currentAnnotation.setText(this.inputTextArea.getText());
                this.currentAnnotation.getAttributes().setSize(new Dimension(this.widthSlider.getValue(), this.heightSlider.getValue()));
                this.currentAnnotation.getAttributes().setScale((double)this.scaleSlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setOpacity((double)this.opacitySlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setAdjustWidthToText(this.cbAdjustWidth.isSelected() ? "render.Annotation.SizeFitText" : "render.Annotation.SizeFixed");
                String string = this.cbFontName.getSelectedItem() + "-" + this.cbFontStyle.getSelectedItem().toString().toUpperCase() + "-" + this.cbFontSize.getSelectedItem();
                this.currentAnnotation.getAttributes().setFont(Font.decode(string));
                Color color = this.btTextColor.getBackground();
                int n = (int)(Float.valueOf((String)this.cbTextColorAlpha.getSelectedItem()).floatValue() * 25.5f);
                this.currentAnnotation.getAttributes().setTextColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n));
                color = this.btBackColor.getBackground();
                n = (int)(Float.valueOf((String)this.cbBackColorAlpha.getSelectedItem()).floatValue() * 25.5f);
                this.currentAnnotation.getAttributes().setBackgroundColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n));
                color = this.btBorderColor.getBackground();
                n = (int)(Float.valueOf((String)this.cbBorderColorAlpha.getSelectedItem()).floatValue() * 25.5f);
                this.currentAnnotation.getAttributes().setBorderColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n));
                this.savedBorderColor = this.currentAnnotation.getAttributes().getBorderColor();
                switch (this.cbTextAlign.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setTextAlign(0);
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setTextAlign(1);
                        break;
                    }
                    case 2: {
                        this.currentAnnotation.getAttributes().setTextAlign(2);
                    }
                }
                switch (this.cbTextEffect.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setEffect("render.MultiLineTextRenderer.EffectNone");
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setEffect("render.MultiLineTextRenderer.EffectShadow");
                        break;
                    }
                    case 2: {
                        this.currentAnnotation.getAttributes().setEffect("render.MultiLineTextRenderer.EffectOutline");
                    }
                }
                switch (this.cbShape.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setFrameShape("Render.FrameFactory.ShapeRectangle");
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setFrameShape("Render.FrameFactory.ShapeEllipse");
                        break;
                    }
                    case 2: {
                        this.currentAnnotation.getAttributes().setFrameShape("Render.FrameFactory.ShapeNone");
                    }
                }
                switch (this.cbLeader.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setLeader("Render.FrameFactory.LeaderTriangle");
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setLeader("Render.FrameFactory.LeaderNone");
                    }
                }
                this.currentAnnotation.getAttributes().setCornerRadius(this.cornerRadiusSlider.getValue());
                this.currentAnnotation.getAttributes().setInsets(new Insets(Integer.parseInt(this.insetsTop.getValue().toString()), Integer.parseInt(this.insetsLeft.getValue().toString()), Integer.parseInt(this.insetsBottom.getValue().toString()), Integer.parseInt(this.insetsRight.getValue().toString())));
                this.currentAnnotation.getAttributes().setBorderWidth((double)this.borderWidthSlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setBorderStippleFactor(this.stippleFactorSlider.getValue());
                switch (this.cbAntialias.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setAntiAliasHint(4352);
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setAntiAliasHint(4353);
                        break;
                    }
                    case 2: {
                        this.currentAnnotation.getAttributes().setAntiAliasHint(4354);
                    }
                }
                switch (this.cbImage.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setImageSource(null);
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setImageSource(IMAGE_EARTH);
                        break;
                    }
                    case 2: {
                        this.currentAnnotation.getAttributes().setImageSource(IMAGE_NASA);
                        break;
                    }
                    case 3: {
                        this.currentAnnotation.getAttributes().setImageSource(IMAGE_WWJ_SPLASH);
                        break;
                    }
                    case 4: {
                        this.currentAnnotation.getAttributes().setImageSource(this.savedImage);
                    }
                }
                switch (this.cbImageRepeat.getSelectedIndex()) {
                    case 0: {
                        this.currentAnnotation.getAttributes().setImageRepeat("render.Annotation.RepeatNone");
                        break;
                    }
                    case 1: {
                        this.currentAnnotation.getAttributes().setImageRepeat("render.Annotation.RepeatX");
                        break;
                    }
                    case 2: {
                        this.currentAnnotation.getAttributes().setImageRepeat("render.Annotation.RepeatY");
                        break;
                    }
                    case 3: {
                        this.currentAnnotation.getAttributes().setImageRepeat("render.Annotation.RepeatXY");
                    }
                }
                this.currentAnnotation.getAttributes().setImageScale((double)this.imageScaleSlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setImageOpacity((double)this.imageOpacitySlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setImageOffset(new Point(this.imageOffsetXSlider.getValue(), this.imageOffsetYSlider.getValue()));
                this.currentAnnotation.getAttributes().setDrawOffset(new Point(this.offsetXSlider.getValue(), this.offsetYSlider.getValue()));
                this.currentAnnotation.getAttributes().setDistanceMinScale((double)this.distanceMinScaleSlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setDistanceMaxScale((double)this.distanceMaxScaleSlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setDistanceMinOpacity((double)this.distanceMinOpacitySlider.getValue() / 10.0);
                this.currentAnnotation.getAttributes().setHighlightScale((double)this.highlightScaleSlider.getValue() / 10.0);
                this.getWwd().repaint();
            }
        }

        private Position computeGroundPosition(WorldWindowGLCanvas worldWindowGLCanvas) {
            View view = worldWindowGLCanvas.getView();
            if (view == null) {
                return null;
            }
            Position position = view.computePositionFromScreenPoint(view.getViewport().getWidth() / 2.0, view.getViewport().getHeight() / 2.0);
            return position;
        }

        private void save() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            stringBuilder.append("<kml xmlns=\"http://earth.google.com/kml/2.2\">\n");
            stringBuilder.append("<Folder>\n");
            stringBuilder.append("  <name>WWJ Annotations</name>\n");
            for (GlobeAnnotation globeAnnotation : this.layer.getAnnotations()) {
                String string = globeAnnotation.getAttributes().getBackgroundColor() != null ? this.getHexaColorABGR(globeAnnotation.getAttributes().getBackgroundColor()) : "66000000";
                String string2 = globeAnnotation.getAttributes().getTextColor() != null ? this.getHexaColorABGR(globeAnnotation.getAttributes().getTextColor()) : "ccffffff";
                String string3 = globeAnnotation.getAttributes().getBorderColor() != null ? this.getHexaColorABGR(globeAnnotation.getAttributes().getBorderColor()) : "ccffffff";
                stringBuilder.append("  <Placemark>\n");
                stringBuilder.append("    <Style>\n");
                stringBuilder.append("      <BalloonStyle>\n");
                if (string.length() > 0) {
                    stringBuilder.append("        <bgColor>" + string + "</bgColor>\n");
                }
                if (string2.length() > 0) {
                    stringBuilder.append("        <textColor>" + string2 + "</textColor>\n");
                }
                if (string3.length() > 0) {
                    stringBuilder.append("        <borderColor>" + string3 + "</borderColor>\n");
                }
                stringBuilder.append("      </BalloonStyle>\n");
                stringBuilder.append("    </Style>\n");
                stringBuilder.append("    <name>");
                stringBuilder.append(globeAnnotation.getText().length() > 50 ? globeAnnotation.getText().substring(0, 47) + "..." : globeAnnotation.getText());
                stringBuilder.append("</name>\n");
                stringBuilder.append("    <description>");
                stringBuilder.append("<![CDATA[" + globeAnnotation.getText().replaceAll("\n", "<br />") + "]]>");
                stringBuilder.append("</description>\n");
                stringBuilder.append("    <Point>");
                stringBuilder.append("<coordinates>" + globeAnnotation.getPosition().getLongitude().degrees + "," + globeAnnotation.getPosition().getLatitude().degrees + "," + globeAnnotation.getPosition().getElevation() + "</coordinates>");
                stringBuilder.append("</Point>\n");
                stringBuilder.append("\n");
                stringBuilder.append("  </Placemark>\n");
            }
            stringBuilder.append("</Folder>\n");
            stringBuilder.append("</kml>\n");
            System.out.println(stringBuilder);
        }

        private String getHexaColorABGR(Color color) {
            return String.format("%1$02x%2$02x%3$02x%4$02x", color.getAlpha(), color.getBlue(), color.getGreen(), color.getRed());
        }
    }
}

