/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.applications.sar.PositionTable;
import gov.nasa.worldwind.applications.sar.PositionsContextMenu;
import gov.nasa.worldwind.applications.sar.SAR2;
import gov.nasa.worldwind.applications.sar.SARTrack;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TrackPanel
extends JPanel {
    private String elevationUnit;
    private boolean ignoreOffsetChange = false;
    private JPanel panel1;
    private JPanel topPanel;
    private JCheckBox visibilityFlag;
    private JCheckBox checkBox1;
    private JScrollPane scrollPane;
    private PositionTable positionTable;
    private JPanel offsetPanel;
    private JSlider offsetSlider;
    private JPanel panel2;
    private JCheckBox offsetToggleCheckBox;
    private JTextField offsetReadout;

    public TrackPanel() {
        this.initComponents();
        this.scrollPane.addMouseListener(new PositionsContextMenu(this.positionTable));
        this.positionTable.addMouseListener(new PositionsContextMenu(this.positionTable));
    }

    public void setTrack(SARTrack sARTrack) {
        this.positionTable.setSarTrack(sARTrack);
    }

    public SARTrack getTrack() {
        return this.positionTable.getSarTrack();
    }

    public String getElevationUnit() {
        return this.elevationUnit;
    }

    public void setElevationUnit(String string) {
        String string2 = this.elevationUnit;
        this.elevationUnit = string;
        this.positionTable.setElevationUnit(string);
        this.positionTable.updateTableData();
        this.changeOffsetUnit(string2, this.elevationUnit);
    }

    private void enterPositionsItemStateChanged(ItemEvent itemEvent) {
        String string = itemEvent.getStateChange() == 1 ? "TrackController.BeginTrackPointEntry" : "TrackController.EndTrackPointEntry";
        this.positionTable.getSarTrack().firePropertyChange(string, null, this.positionTable.getSarTrack());
    }

    private void visibilityActionPerformed(ActionEvent actionEvent) {
        String string = this.visibilityFlag.isSelected() ? "TrackController.TrackEnabled" : "TrackController.TrackDisabled";
        this.positionTable.getSarTrack().firePropertyChange(string, null, this.positionTable.getSarTrack());
    }

    private void offsetSliderStateChanged(ChangeEvent changeEvent) {
        if (this.ignoreOffsetChange) {
            this.ignoreOffsetChange = false;
            return;
        }
        int n = this.offsetToggleCheckBox.isSelected() ? this.offsetSlider.getValue() : 0;
        this.offsetReadout.setText(Integer.toString(n));
        this.applyTrackOffset(n);
    }

    private void offsetToggleCheckBoxItemStateChanged(ItemEvent itemEvent) {
        double d = this.offsetToggleCheckBox.isSelected() ? Double.parseDouble(this.offsetReadout.getText()) : 0.0;
        this.applyTrackOffset(d);
    }

    private void offsetReadoutActionPerformed(ActionEvent actionEvent) {
        double d = this.offsetToggleCheckBox.isSelected() ? Double.parseDouble(this.offsetReadout.getText()) : 0.0;
        this.offsetReadout.setText(Integer.toString((int)d));
        this.ignoreOffsetChange = true;
        if (d >= (double)this.offsetSlider.getMaximum()) {
            this.offsetSlider.setValue(this.offsetSlider.getMaximum());
        } else if (d <= (double)this.offsetSlider.getMinimum()) {
            this.offsetSlider.setValue(this.offsetSlider.getMinimum());
        } else {
            this.offsetSlider.setValue((int)d);
        }
        this.applyTrackOffset(d);
    }

    private void applyTrackOffset(double d) {
        double d2 = "Imperial".equals(this.elevationUnit) ? SAR2.feetToMeters(d) : d;
        this.positionTable.getSarTrack().setOffset(d2);
        this.positionTable.getSarTrack().firePropertyChange("TrackController.TrackModified", null, this.positionTable.getSarTrack());
    }

    private void initComponents() {
        this.panel1 = new JPanel();
        this.topPanel = new JPanel();
        this.visibilityFlag = new JCheckBox();
        this.checkBox1 = new JCheckBox();
        this.scrollPane = new JScrollPane();
        this.positionTable = new PositionTable();
        this.offsetPanel = new JPanel();
        this.offsetSlider = new JSlider();
        this.panel2 = new JPanel();
        this.offsetToggleCheckBox = new JCheckBox();
        this.offsetReadout = new JTextField();
        this.setToolTipText("Track Positions");
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.panel1.setLayout(new BorderLayout());
        this.topPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.topPanel.setLayout(new BorderLayout(5, 5));
        this.visibilityFlag.setText("Visible");
        this.visibilityFlag.setSelected(true);
        this.visibilityFlag.setToolTipText("Display track on globe");
        this.visibilityFlag.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackPanel.this.visibilityActionPerformed(actionEvent);
            }
        });
        this.topPanel.add((Component)this.visibilityFlag, "West");
        this.checkBox1.setText("Mouse Entry (+ALT)");
        this.checkBox1.setToolTipText("Enter track points with mouse");
        this.checkBox1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TrackPanel.this.enterPositionsItemStateChanged(itemEvent);
            }
        });
        this.topPanel.add((Component)this.checkBox1, "Center");
        this.panel1.add((Component)this.topPanel, "North");
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.positionTable.setPreferredScrollableViewportSize(new Dimension(340, 300));
        this.scrollPane.setViewportView(this.positionTable);
        this.panel1.add((Component)this.scrollPane, "Center");
        this.add((Component)this.panel1, "Center");
        this.offsetPanel.setLayout(new BorderLayout(0, 2));
        this.offsetSlider.setOrientation(1);
        this.offsetSlider.setPaintLabels(true);
        this.offsetSlider.setValue(0);
        this.offsetSlider.setToolTipText("Elevation offset");
        this.offsetSlider.setPaintTicks(true);
        this.offsetSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TrackPanel.this.offsetSliderStateChanged(changeEvent);
            }
        });
        this.offsetPanel.add((Component)this.offsetSlider, "Center");
        this.panel2.setBorder(new EmptyBorder(0, 2, 2, 2));
        this.panel2.setLayout(new BorderLayout());
        this.offsetToggleCheckBox.setText("Offset");
        this.offsetToggleCheckBox.setHorizontalAlignment(0);
        this.offsetToggleCheckBox.setSelected(true);
        this.offsetToggleCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TrackPanel.this.offsetToggleCheckBoxItemStateChanged(itemEvent);
            }
        });
        this.panel2.add((Component)this.offsetToggleCheckBox, "North");
        this.offsetReadout.setText("0");
        this.offsetReadout.setHorizontalAlignment(4);
        this.offsetReadout.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(0, 0, 0, 4)));
        this.offsetReadout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackPanel.this.offsetReadoutActionPerformed(actionEvent);
            }
        });
        this.panel2.add((Component)this.offsetReadout, "South");
        this.offsetPanel.add((Component)this.panel2, "North");
        this.add((Component)this.offsetPanel, "East");
    }

    private void changeOffsetUnit(String string, String string2) {
        int n = this.offsetSlider.getValue();
        if ("Imperial".equals(string2)) {
            this.offsetSlider.setMaximum(16000);
            this.offsetSlider.setMinimum(-16000);
            this.offsetSlider.setMajorTickSpacing(3200);
            Hashtable<Integer, JComponent> hashtable = this.offsetSlider.createStandardLabels(3200);
            this.offsetSlider.setLabelTable(hashtable);
            if ("Metric".equals(string)) {
                n = (int)SAR2.metersToFeet(n);
            }
        } else {
            this.offsetSlider.setMaximum(5000);
            this.offsetSlider.setMinimum(-5000);
            this.offsetSlider.setMajorTickSpacing(1000);
            Hashtable<Integer, JComponent> hashtable = this.offsetSlider.createStandardLabels(1000);
            this.offsetSlider.setLabelTable(hashtable);
            if ("Imperial".equals(string)) {
                n = (int)SAR2.feetToMeters(n);
            }
        }
        if (n > this.offsetSlider.getMaximum()) {
            n = this.offsetSlider.getMaximum();
        }
        if (n < this.offsetSlider.getMinimum()) {
            n = this.offsetSlider.getMinimum();
        }
        this.offsetSlider.setValue(n);
        this.offsetReadout.setText(Integer.toString(n));
    }
}

