/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Polyline;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaneModel
implements Renderable {
    private Position position;
    private Angle heading;
    private Double length = 100.0;
    private Double width = 100.0;
    private Color color = Color.YELLOW;
    private boolean showShadow = true;
    private double shadowScale = 1.0;
    private Color shadowColor = Color.YELLOW;
    private Polyline planeModel;
    private Polyline shadowModel;

    public PlaneModel() {
    }

    public PlaneModel(Double d, Double d2, Color color) {
        this.length = d;
        this.width = d2;
        this.color = color;
    }

    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
        this.clearRenderables();
    }

    public Position getPosition() {
        return this.position;
    }

    public void setHeading(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.heading = angle;
        this.clearRenderables();
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setShowShadow(boolean bl) {
        this.showShadow = bl;
    }

    public boolean getShowShadow() {
        return this.showShadow;
    }

    public double getShadowScale() {
        return this.shadowScale;
    }

    public void setShadowScale(double d) {
        this.shadowScale = d;
        this.clearRenderables();
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color color) {
        this.shadowColor = color;
        this.clearRenderables();
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.position == null || this.heading == null) {
            return;
        }
        if (this.planeModel == null) {
            this.createRenderables(drawContext);
        }
        this.planeModel.render(drawContext);
        if (this.showShadow && this.shadowModel != null) {
            this.shadowModel.render(drawContext);
        }
    }

    private void createRenderables(DrawContext drawContext) {
        ArrayList<LatLon> arrayList = this.computePlaneShape(drawContext, this.width, this.length);
        this.planeModel = new Polyline(arrayList, this.position.getElevation());
        this.planeModel.setPathType(1);
        this.planeModel.setFollowTerrain(false);
        this.planeModel.setNumSubsegments(1);
        this.planeModel.setColor(this.color);
        arrayList = this.computePlaneShape(drawContext, this.shadowScale * this.width, this.shadowScale * this.length);
        this.shadowModel = new Polyline(arrayList, this.position.getElevation());
        this.shadowModel.setPathType(1);
        this.shadowModel.setFollowTerrain(true);
        this.shadowModel.setColor(this.shadowColor);
    }

    private void clearRenderables() {
        this.planeModel = null;
        this.shadowModel = null;
    }

    private ArrayList<LatLon> computePlaneShape(DrawContext drawContext, double d, double d2) {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
        LatLon latLon = this.position.getLatLon();
        double d3 = d2 / 2.0;
        double d4 = d / 2.0;
        double d5 = drawContext.getGlobe().getRadius();
        LatLon latLon2 = LatLon.rhumbEndPosition(latLon, this.heading.radians, d3 / d5);
        arrayList.add(latLon2);
        double d6 = Math.sqrt(d4 * d4 + d3 * d3);
        double d7 = 1.5707963267948966 + Math.asin(d3 / d6);
        latLon2 = LatLon.rhumbEndPosition(latLon, this.heading.radians + d7, d6 / d5);
        arrayList.add(latLon2);
        latLon2 = LatLon.rhumbEndPosition(latLon, this.heading.radians - d7, d6 / d5);
        arrayList.add(latLon2);
        arrayList.add((LatLon)arrayList.get(0));
        return arrayList;
    }
}

