/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.applications.sar;

import gov.nasa.worldwind.applications.sar.SAR2;
import gov.nasa.worldwind.util.Logging;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;

public class AboutDialog {
    private Object content;
    private String contentType;
    private Dimension preferredSize;

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object object) {
        this.content = object;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public void showDialog(Component component) {
        Component component2 = this.makeContentComponent();
        AboutDialog.showContentDialog(component, component2);
    }

    private static void showContentDialog(Component component, Component component2) {
        try {
            final JDialog jDialog = component instanceof Dialog ? new JDialog((Dialog)component) : (component instanceof Frame ? new JDialog((Frame)component) : new JDialog());
            component2.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    jDialog.setVisible(false);
                    jDialog.dispose();
                }
            });
            jDialog.getContentPane().setLayout(new BorderLayout());
            jDialog.getContentPane().add(component2, "Center");
            jDialog.setDefaultCloseOperation(2);
            jDialog.setModal(true);
            jDialog.setResizable(false);
            jDialog.pack();
            SAR2.centerWindowInDesktop(jDialog);
            jDialog.setVisible(true);
        }
        catch (Exception exception) {
            String string = "Exception while displaying content dialog";
            Logging.logger().log(Level.SEVERE, string, exception);
        }
    }

    private Component makeContentComponent() {
        JTextComponent jTextComponent = null;
        try {
            if (this.content != null) {
                URL uRL = this.getClass().getResource(this.content.toString());
                jTextComponent = new JEditorPane();
                if (this.contentType != null) {
                    ((JEditorPane)jTextComponent).setContentType(this.contentType);
                }
                ((JEditorPane)jTextComponent).setPage(uRL);
            }
            if (jTextComponent != null) {
                jTextComponent.setEditable(false);
                if (this.preferredSize != null) {
                    jTextComponent.setPreferredSize(this.preferredSize);
                }
            }
        }
        catch (Exception exception) {
            String string = "Exception while fetching content";
            Logging.logger().log(Level.SEVERE, string, exception);
            jTextComponent = null;
        }
        return jTextComponent;
    }
}

