/*
 * Decompiled with CFR 0.152.
 */
package ngmf.util;

import java.io.FileReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import ngmf.io.CSProperties;
import ngmf.io.DataIO;
import ngmf.util.Conversions;

public class Tables {
    public static TableModel fromCSP(CSProperties p, final int dim) {
        List<String> dims = Tables.keysByMeta(p, "role", "dimension");
        if (dims.size() == 0) {
            return null;
        }
        for (String d : dims) {
            if (Integer.parseInt((String)p.get(d)) != dim) continue;
            final List<String> bounds = Tables.keysByMeta(p, "bound", d);
            final ArrayList<Object> columns = new ArrayList<Object>(bounds.size());
            for (String bound : bounds) {
                columns.add(Conversions.parse((String)p.get(bound), double[].class));
            }
            return new AbstractTableModel(){

                @Override
                public int getRowCount() {
                    return dim;
                }

                @Override
                public int getColumnCount() {
                    return bounds.size();
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    return Array.get(columns.get(columnIndex), rowIndex);
                }

                @Override
                public String getColumnName(int column) {
                    return (String)bounds.get(column);
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    return Double.class;
                }
            };
        }
        return null;
    }

    public static List<String> keysByMeta(CSProperties csp, String mkey, String mval) {
        ArrayList<String> l = new ArrayList<String>();
        for (String key : csp.keySet()) {
            String role;
            if (!csp.getInfo(key).keySet().contains(mkey) || !(role = csp.getInfo(key).get(mkey)).equals(mval)) continue;
            l.add(key);
        }
        return l;
    }

    public static void main(String[] args) throws Exception {
        FileReader r = new FileReader(Tables.class.getResource("TablesTest_test.csd").getFile());
        CSProperties csp = DataIO.properties(r, "data");
        TableModel m = Tables.fromCSP(csp, 57);
        JTable table = new JTable(m);
        JFrame f = new JFrame();
        f.getContentPane().add(new JScrollPane(table));
        f.setDefaultCloseOperation(3);
        f.setSize(800, 600);
        f.setLocation(100, 100);
        f.setVisible(true);
    }
}

