/*
 * Decompiled with CFR 0.152.
 */
package ngmf.io;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import ngmf.io.CSVStrategy;

public class CSVPrinter {
    protected PrintWriter out;
    protected boolean newLine = true;
    private CSVStrategy strategy = CSVStrategy.DEFAULT_STRATEGY;

    public CSVPrinter(OutputStream out) {
        this.out = new PrintWriter(out);
    }

    public CSVPrinter(Writer out) {
        this.out = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
    }

    public CSVPrinter setStrategy(CSVStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public CSVStrategy getStrategy() {
        return this.strategy;
    }

    public void println(String value) {
        this.print(value);
        this.out.println();
        this.out.flush();
        this.newLine = true;
    }

    public void println() {
        this.out.println();
        this.out.flush();
        this.newLine = true;
    }

    public void println(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.print(values[i]);
        }
        this.out.println();
        this.out.flush();
        this.newLine = true;
    }

    public void println(String[][] values) {
        for (int i = 0; i < values.length; ++i) {
            this.println(values[i]);
        }
        if (values.length == 0) {
            this.out.println();
        }
        this.out.flush();
        this.newLine = true;
    }

    public void printlnComment(String comment) {
        if (this.strategy.isCommentingDisabled()) {
            return;
        }
        if (!this.newLine) {
            this.out.println();
        }
        this.out.print(this.strategy.getCommentStart());
        this.out.print(' ');
        block4: for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            switch (c) {
                case '\r': {
                    if (i + 1 < comment.length() && comment.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    this.out.println();
                    this.out.print(this.strategy.getCommentStart());
                    this.out.print(' ');
                    continue block4;
                }
                default: {
                    this.out.print(c);
                }
            }
        }
        this.out.println();
        this.out.flush();
        this.newLine = true;
    }

    public void print(String value) {
        boolean quote = false;
        if (value.length() > 0) {
            char c = value.charAt(0);
            if (this.newLine && (c < '0' || c > '9' && c < 'A' || c > 'Z' && c < 'a' || c > 'z')) {
                quote = true;
            }
            if (c == ' ' || c == '\f' || c == '\t') {
                quote = true;
            }
            for (int i = 0; i < value.length(); ++i) {
                c = value.charAt(i);
                if (c != '\"' && c != this.strategy.getDelimiter() && c != '\n' && c != '\r') continue;
                quote = true;
                c = value.charAt(value.length() - 1);
                break;
            }
            if (c == ' ' || c == '\f' || c == '\t') {
                quote = true;
            }
        } else if (this.newLine) {
            quote = true;
        }
        if (this.newLine) {
            this.newLine = false;
        } else {
            this.out.print(this.strategy.getDelimiter());
        }
        if (quote) {
            this.out.print(this.escapeAndQuote(value));
        } else {
            this.out.print(value);
        }
        this.out.flush();
    }

    private String escapeAndQuote(String value) {
        int count = 2;
        block8: for (int i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': {
                    ++count;
                    continue block8;
                }
            }
        }
        StringBuffer sb = new StringBuffer(value.length() + count);
        sb.append(this.strategy.getEncapsulator());
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == this.strategy.getEncapsulator()) {
                sb.append('\\').append(c);
                continue;
            }
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append(this.strategy.getEncapsulator());
        return sb.toString();
    }
}

