/*
 * Decompiled with CFR 0.152.
 */
package ngmf;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import ngmf.FieldAccess;
import ngmf.Notification;
import ngmf.ann.Execute;
import ngmf.ann.In;
import ngmf.ann.Out;

public class ComponentAccess {
    private static final String COMPINFO = "CompInfo";
    Object cmd;
    Method execute;
    List<FieldAccess> ins;
    List<FieldAccess> outs;
    Notification ens;

    public ComponentAccess(Object cmd) {
        this(cmd, null);
    }

    public ComponentAccess(Object cmd, Notification ens) {
        this.cmd = cmd;
        this.ens = ens;
        this.execute = ComponentAccess.getMethodOfInterest(cmd, Execute.class);
        this.ins = ComponentAccess.findAll(cmd, In.class, FieldAccess.Intent.IN);
        this.outs = ComponentAccess.findAll(cmd, Out.class, FieldAccess.Intent.OUT);
    }

    public Object getComponent() {
        return this.cmd;
    }

    public List<FieldAccess> inputs() {
        return this.ins;
    }

    public List<FieldAccess> outputs() {
        return this.outs;
    }

    public FieldAccess input(String field) {
        return this.access(field, this.ins);
    }

    public FieldAccess output(String field) {
        return this.access(field, this.outs);
    }

    private FieldAccess access(String field, List<FieldAccess> l) {
        for (FieldAccess a : l) {
            if (!a.getField().getName().equals(field)) continue;
            a.setNotification(this.ens);
            return a;
        }
        throw new IllegalArgumentException("No field named '" + field + "' in " + this.cmd.getClass());
    }

    void exec() throws Throwable {
        try {
            this.ens.fireWait(this);
            for (FieldAccess a : this.ins) {
                a.in();
            }
            this.ens.fireStart(this);
            this.execute.invoke(this.cmd, new Object[0]);
            this.ens.fireFinnish(this);
            for (FieldAccess a : this.outs) {
                a.out();
            }
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void callAnnotatedMethod(Class<? extends Annotation> ann, boolean lazy) {
        block4: {
            try {
                ComponentAccess.getMethodOfInterest(this.cmd, ann).invoke(this.cmd, new Object[0]);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex.getCause());
            }
            catch (IllegalArgumentException ex) {
                if (lazy) break block4;
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    static Method getMethodOfInterest(Object cmp, Class<? extends Annotation> ann) {
        Method[] ms;
        Class<?> cmpClass = cmp.getClass();
        Class infoClass = ComponentAccess.infoClass(cmp);
        for (Method m : ms = infoClass.getMethods()) {
            if (m.getAnnotation(ann) == null) continue;
            if (m.getReturnType() != Void.TYPE || m.getParameterTypes().length > 0) {
                throw new IllegalArgumentException("Invalid Method signature: " + m);
            }
            try {
                return cmpClass.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        throw new IllegalArgumentException("No " + ann.getCanonicalName() + " found in " + cmp.getClass());
    }

    static List<FieldAccess> findAll(Object cmp, Class<? extends Annotation> ann, FieldAccess.Intent intent) {
        Class<?> cmpClass = cmp.getClass();
        Class infoClass = ComponentAccess.infoClass(cmp);
        ArrayList<FieldAccess> list = new ArrayList<FieldAccess>();
        for (Field f : infoClass.getFields()) {
            if (f.getAnnotation(ann) == null) continue;
            try {
                list.add(new FieldAccess(cmp, cmpClass.getField(f.getName()), intent));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return list;
    }

    public static Class infoClass(Object cmp) {
        Class<?> infoClass = null;
        try {
            infoClass = Class.forName(cmp.getClass().getName() + COMPINFO);
        }
        catch (ClassNotFoundException E) {
            infoClass = cmp.getClass();
        }
        return infoClass;
    }
}

