/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.TableData;

public abstract class TableHDU
extends BasicHDU {
    private TableData table;
    private int currentColumn;

    TableHDU(TableData tableData) {
        this.table = tableData;
    }

    public Object[] getRow(int n) throws FitsException {
        return this.table.getRow(n);
    }

    public Object getColumn(String string) throws FitsException {
        return this.getColumn(this.findColumn(string));
    }

    public Object getColumn(int n) throws FitsException {
        return this.table.getColumn(n);
    }

    public Object getElement(int n, int n2) throws FitsException {
        return this.table.getElement(n, n2);
    }

    public void setRow(int n, Object[] objectArray) throws FitsException {
        this.table.setRow(n, objectArray);
    }

    public void setColumn(String string, Object object) throws FitsException {
        this.setColumn(this.findColumn(string), object);
    }

    public void setColumn(int n, Object object) throws FitsException {
        this.table.setColumn(n, object);
    }

    public void setElement(int n, int n2, Object object) throws FitsException {
        this.table.setElement(n, n2, object);
    }

    public int addRow(Object[] objectArray) throws FitsException {
        int n = this.table.addRow(objectArray);
        this.myHeader.addValue("NAXIS2", n, (String)null);
        return n;
    }

    public int findColumn(String string) {
        int n = 0;
        while (n < this.getNCols()) {
            String string2 = this.myHeader.getStringValue("TTYPE" + (n + 1));
            if (string2 != null && string2.trim().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public abstract int addColumn(Object var1) throws FitsException;

    public int getNCols() {
        return this.table.getNCols();
    }

    public int getNRows() {
        return this.table.getNRows();
    }

    public String getColumnName(int n) {
        String string = this.myHeader.getStringValue("TTYPE" + (n + 1));
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    public void setColumnName(int n, String string, String string2) throws FitsException {
        if (this.getNCols() > n && n >= 0) {
            this.myHeader.positionAfterIndex("TFORM", n + 1);
            this.myHeader.addValue("TTYPE" + (n + 1), string, string2);
        }
    }

    public String getColumnFormat(int n) throws FitsException {
        int n2 = this.myHeader.getIntValue("TFIELDS", 0);
        if (n < 0 || n >= n2) {
            throw new FitsException("Bad column index " + n + " (only " + n2 + " columns)");
        }
        return this.myHeader.getStringValue("TFORM" + (n + 1)).trim();
    }

    public void setCurrentColumn(int n) {
        this.myHeader.positionAfterIndex("TFORM", n + 1);
    }
}

