/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import java.util.Date;
import nom.tam.fits.Data;
import nom.tam.fits.FitsDate;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;

public abstract class BasicHDU
implements FitsElement {
    public static final int BITPIX_BYTE = 8;
    public static final int BITPIX_SHORT = 16;
    public static final int BITPIX_INT = 32;
    public static final int BITPIX_LONG = 64;
    public static final int BITPIX_FLOAT = -32;
    public static final int BITPIX_DOUBLE = -64;
    protected Header myHeader = null;
    protected Data myData = null;
    protected boolean isPrimary = false;

    abstract Data manufactureData() throws FitsException;

    public static void skipData(ArrayDataInput arrayDataInput, Header header) throws IOException {
        arrayDataInput.skipBytes((int)header.getDataSize());
    }

    public void skipData(ArrayDataInput arrayDataInput) throws IOException {
        BasicHDU.skipData(arrayDataInput, this.myHeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readData(ArrayDataInput arrayDataInput) throws FitsException {
        block5: {
            this.myData = null;
            try {
                this.myData = this.manufactureData();
                Object var3_2 = null;
                if (this.myData != null) break block5;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.myData != null) throw throwable;
                try {
                    BasicHDU.skipData(arrayDataInput, this.myHeader);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            BasicHDU.skipData(arrayDataInput, this.myHeader);
        }
        this.myData.read(arrayDataInput);
    }

    public Header getHeader() {
        return this.myHeader;
    }

    public long getFileOffset() {
        return this.myHeader.getFileOffset();
    }

    public Data getData() {
        return this.myData;
    }

    public Object getKernel() {
        try {
            return this.myData.getKernel();
        }
        catch (FitsException fitsException) {
            return null;
        }
    }

    public long getSize() {
        int n = 0;
        if (this.myHeader != null) {
            n = (int)((long)n + this.myHeader.getSize());
        }
        if (this.myData != null) {
            n = (int)((long)n + this.myData.getSize());
        }
        return n;
    }

    public static boolean isHeader(Header header) {
        return false;
    }

    public abstract void info();

    boolean checkField(String string) {
        String string2 = this.myHeader.getStringValue(string);
        return string2 != null;
    }

    public void read(ArrayDataInput arrayDataInput) throws FitsException, IOException {
        this.myHeader = Header.readHeader(arrayDataInput);
        this.myData = this.myHeader.makeData();
        this.myData.read(arrayDataInput);
    }

    public void write(ArrayDataOutput arrayDataOutput) throws FitsException {
        if (this.myHeader != null) {
            this.myHeader.write(arrayDataOutput);
        }
        if (this.myData != null) {
            this.myData.write(arrayDataOutput);
        }
        try {
            arrayDataOutput.flush();
        }
        catch (IOException iOException) {
            throw new FitsException("Error flushing at end of HDU: " + iOException.getMessage());
        }
    }

    public boolean rewriteable() {
        return this.myHeader.rewriteable() && this.myData.rewriteable();
    }

    public void rewrite() throws FitsException, IOException {
        if (!this.rewriteable()) {
            throw new FitsException("Invalid attempt to rewrite HDU");
        }
        this.myHeader.rewrite();
        this.myData.rewrite();
    }

    public String getTrimmedString(String string) {
        String string2 = this.myHeader.getStringValue(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public int getBitPix() throws FitsException {
        int n = this.myHeader.getIntValue("BITPIX", -1);
        switch (n) {
            case -64: 
            case -32: 
            case 8: 
            case 16: 
            case 32: {
                break;
            }
            default: {
                throw new FitsException("Unknown BITPIX type " + n);
            }
        }
        return n;
    }

    public int[] getAxes() throws FitsException {
        int n = this.myHeader.getIntValue("NAXIS", 0);
        if (n < 0) {
            throw new FitsException("Negative NAXIS value " + n);
        }
        if (n > 999) {
            throw new FitsException("NAXIS value " + n + " too large");
        }
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 1;
        while (n2 <= n) {
            nArray[n - n2] = this.myHeader.getIntValue("NAXIS" + n2, 0);
            ++n2;
        }
        return nArray;
    }

    public int getParameterCount() {
        return this.myHeader.getIntValue("PCOUNT", 0);
    }

    public int getGroupCount() {
        return this.myHeader.getIntValue("GCOUNT", 1);
    }

    public double getBScale() {
        return this.myHeader.getDoubleValue("BSCALE", 1.0);
    }

    public double getBZero() {
        return this.myHeader.getDoubleValue("BZERO", 0.0);
    }

    public String getBUnit() {
        return this.getTrimmedString("BUNIT");
    }

    public int getBlankValue() throws FitsException {
        if (!this.myHeader.containsKey("BLANK")) {
            throw new FitsException("BLANK undefined");
        }
        return this.myHeader.getIntValue("BLANK");
    }

    public Date getCreationDate() {
        try {
            return new FitsDate(this.myHeader.getStringValue("DATE")).toDate();
        }
        catch (FitsException fitsException) {
            return null;
        }
    }

    public Date getObservationDate() {
        try {
            return new FitsDate(this.myHeader.getStringValue("DATE-OBS")).toDate();
        }
        catch (FitsException fitsException) {
            return null;
        }
    }

    public String getOrigin() {
        return this.getTrimmedString("ORIGIN");
    }

    public String getTelescope() {
        return this.getTrimmedString("TELESCOP");
    }

    public String getInstrument() {
        return this.getTrimmedString("INSTRUME");
    }

    public String getObserver() {
        return this.getTrimmedString("OBSERVER");
    }

    public String getObject() {
        return this.getTrimmedString("OBJECT");
    }

    public double getEquinox() {
        return this.myHeader.getDoubleValue("EQUINOX", -1.0);
    }

    public double getEpoch() {
        return this.myHeader.getDoubleValue("EPOCH", -1.0);
    }

    public String getAuthor() {
        return this.getTrimmedString("AUTHOR");
    }

    public String getReference() {
        return this.getTrimmedString("REFERENC");
    }

    public double getMaximumValue() {
        return this.myHeader.getDoubleValue("DATAMAX");
    }

    public double getMinimumValue() {
        return this.myHeader.getDoubleValue("DATAMIN");
    }

    boolean canBePrimary() {
        return false;
    }

    void setPrimaryHDU(boolean bl) throws FitsException {
        Object object;
        if (bl && !this.canBePrimary()) {
            throw new FitsException("Invalid attempt to make HDU of type:" + this.getClass().getName() + " primary.");
        }
        this.isPrimary = bl;
        if (this.isPrimary && !this.myHeader.getBooleanValue("GROUPS", false)) {
            this.myHeader.deleteKey("PCOUNT");
            this.myHeader.deleteKey("GCOUNT");
        }
        if (this.isPrimary && (object = this.myHeader.findCard("EXTEND")) == null) {
            this.myHeader.addValue("EXTEND", true, "Allow extensions");
        }
        if (!this.isPrimary) {
            object = this.myHeader.iterator();
            int n = this.myHeader.getIntValue("PCOUNT", 0);
            int n2 = this.myHeader.getIntValue("GCOUNT", 1);
            int n3 = this.myHeader.getIntValue("NAXIS", 0);
            this.myHeader.deleteKey("EXTEND");
            HeaderCard headerCard = this.myHeader.findCard("PCOUNT");
            HeaderCard headerCard2 = this.myHeader.findCard("GCOUNT");
            this.myHeader.getCard(2 + n3);
            if (headerCard == null) {
                this.myHeader.addValue("PCOUNT", n, "Required value");
            }
            if (headerCard2 == null) {
                this.myHeader.addValue("GCOUNT", n2, "Required value");
            }
            object = this.myHeader.iterator();
        }
    }

    public void addValue(String string, boolean bl, String string2) throws HeaderCardException {
        this.myHeader.addValue(string, bl, string2);
    }

    public void addValue(String string, int n, String string2) throws HeaderCardException {
        this.myHeader.addValue(string, n, string2);
    }

    public void addValue(String string, double d, String string2) throws HeaderCardException {
        this.myHeader.addValue(string, d, string2);
    }

    public void addValue(String string, String string2, String string3) throws HeaderCardException {
        this.myHeader.addValue(string, string2, string3);
    }

    public static BasicHDU getDummyHDU() {
        try {
            return FitsFactory.HDUFactory(new int[0]);
        }
        catch (FitsException fitsException) {
            System.err.println("Impossible exception in getDummyHDU");
            return null;
        }
    }
}

