/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.styles.BalloonTipStyle;

public class CustomBalloonTip
extends BalloonTip {
    protected Rectangle offset = new Rectangle(0, 0, 1, 1);
    private JViewport viewport = null;
    private ComponentAdapter viewportListenerListener = new ComponentAdapter(){

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            if (CustomBalloonTip.this.attachedComponent.isShowing()) {
                CustomBalloonTip.this.refreshLocation();
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (CustomBalloonTip.this.attachedComponent.isShowing()) {
                CustomBalloonTip.this.refreshLocation();
            }
        }
    };

    public CustomBalloonTip(JComponent jComponent, String string, Rectangle rectangle, BalloonTipStyle balloonTipStyle, BalloonTip.Orientation orientation, BalloonTip.AttachLocation attachLocation, int n, int n2, boolean bl) {
        super(jComponent, string, balloonTipStyle, orientation, attachLocation, n, n2, bl);
        this.offset = rectangle;
        this.refreshLocation();
    }

    public CustomBalloonTip(JComponent jComponent, String string, Rectangle rectangle, BalloonTipStyle balloonTipStyle, BalloonTipPositioner balloonTipPositioner, boolean bl) {
        super(jComponent, string, balloonTipStyle, balloonTipPositioner, bl);
        this.offset = rectangle;
        this.refreshLocation();
    }

    public void setOffset(Rectangle rectangle) {
        this.offset = rectangle;
        this.refreshLocation();
    }

    @Override
    public void closeBalloon() {
        if (this.viewport != null) {
            this.viewport.removeComponentListener(this.viewportListenerListener);
        }
        super.closeBalloon();
    }

    public void setViewport(JViewport jViewport) {
        this.viewport = jViewport;
        jViewport.addComponentListener(this.viewportListenerListener);
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    @Override
    public void refreshLocation() {
        Point point = SwingUtilities.convertPoint(this.attachedComponent, this.getLocation(), this);
        try {
            this.positioner.determineAndSetLocation(new Rectangle(point.x + this.offset.x, point.y + this.offset.y, this.offset.width, this.offset.height));
            if (this.viewport != null) {
                Rectangle rectangle = new Rectangle(SwingUtilities.convertPoint(this.viewport, this.viewport.getLocation(), this.getTopLevelContainer()), this.viewport.getSize());
                Point point2 = this.positioner.getTipLocation();
                if (point2.y >= rectangle.y - 1 && point2.y <= rectangle.y + rectangle.height && point2.x >= rectangle.x && point2.x <= rectangle.x + rectangle.width) {
                    this.setVisible(true);
                } else {
                    this.setVisible(false);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

