/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.tcode;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class Texjava
extends Task {
    private Vector texFileSets = new Vector();
    private Vector texFileLists = new Vector();
    private File texjava;
    private File masterFile = null;
    private File htmloutdir = null;
    private boolean html = false;
    private boolean htmlset = false;
    private boolean images = false;
    private boolean imagesset = false;
    private boolean savelatex = false;
    private boolean savelatexset = false;
    private boolean htmlonly = false;
    private String htmltitle;
    private boolean overviewtopackage = false;
    private File[] texjavaList;

    private Boolean getBoolProperty(String string) {
        String string2 = this.getProject().getProperty(string);
        if (string2 == null) {
            return null;
        }
        if (string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true") || string2.equals("1")) {
            return new Boolean(true);
        }
        if (string2.equalsIgnoreCase("no") || string2.equalsIgnoreCase("false") || string2.equals("0")) {
            return new Boolean(false);
        }
        return null;
    }

    public boolean getHtml() {
        Boolean bl;
        if (!this.htmlset && (bl = this.getBoolProperty("texjava.html")) != null) {
            this.html = bl;
            this.htmlset = true;
        }
        return this.html;
    }

    public void setHtml(boolean bl) {
        this.html = bl;
        this.htmlset = true;
    }

    public boolean getImages() {
        Boolean bl;
        if (!this.imagesset && (bl = this.getBoolProperty("texjava.images")) != null) {
            this.images = bl;
            this.imagesset = true;
        }
        return this.images;
    }

    public void setImages(boolean bl) {
        this.images = bl;
        this.imagesset = true;
    }

    public boolean getSavelatex() {
        Boolean bl;
        if (!this.savelatexset && (bl = this.getBoolProperty("texjava.savelatex")) != null) {
            this.html = bl;
            this.savelatexset = true;
        }
        return this.savelatex;
    }

    public void setSavelatex(boolean bl) {
        this.savelatex = bl;
        this.savelatexset = true;
    }

    public boolean getHtmlonly() {
        return this.htmlonly;
    }

    public void setHtmlonly(boolean bl) {
        this.htmlonly = bl;
    }

    public boolean getOverviewtopackage() {
        return this.overviewtopackage;
    }

    public void setOverviewtopackage(boolean bl) {
        this.overviewtopackage = bl;
    }

    public File getMaster() {
        return this.masterFile;
    }

    public void setMaster(File file) {
        this.masterFile = file;
    }

    public File getHtmloutdir() {
        if (this.htmloutdir == null) {
            this.htmloutdir = this.getProject().resolveFile(this.getProject().getProperty("texjava.htmloutdir"));
        }
        return this.htmloutdir;
    }

    public void setHtmloutdir(File file) {
        this.htmloutdir = file;
    }

    public String getHtmltitle() {
        if (this.htmltitle == null) {
            this.htmltitle = "";
        }
        return this.htmltitle;
    }

    public void setHtmltitle(String string) {
        this.htmltitle = string;
    }

    public File getTexjava() {
        String string;
        if (this.texjava == null && (string = this.getProject().getProperty("texjava.texjava")) != null) {
            this.texjava = this.getProject().resolveFile(string);
        }
        if (this.texjava == null) {
            this.texjava = new File(this.getProject().getBaseDir() + "/tcode", "texjava.pl");
        }
        return this.texjava;
    }

    public void setTexjava(File file) {
        this.texjava = file;
    }

    public void addTexfileset(FileSet fileSet) {
        this.texFileSets.addElement(fileSet);
    }

    public void addTexfilelist(FileList fileList) {
        this.texFileLists.addElement(fileList);
    }

    public void execute() throws BuildException {
        String[] stringArray;
        DirectoryScanner directoryScanner;
        FileSet fileSet;
        this.resetFileLists();
        Enumeration enumeration = this.texFileSets.elements();
        while (enumeration.hasMoreElements()) {
            fileSet = (FileSet)enumeration.nextElement();
            directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            stringArray = directoryScanner.getIncludedFiles();
            this.scanDir(fileSet.getDir(this.getProject()), stringArray);
        }
        fileSet = this.texFileLists.elements();
        while (fileSet.hasMoreElements()) {
            directoryScanner = (FileList)fileSet.nextElement();
            stringArray = directoryScanner.getFiles(this.getProject());
            this.scanDir(directoryScanner.getDir(this.getProject()), stringArray);
        }
        directoryScanner = new GlobPatternMapper();
        directoryScanner.setFrom("*.tex");
        directoryScanner.setTo(this.getHtmlonly() ? "*.html" : "*.java");
        if (this.texjavaList.length > 0 && !this.overviewtopackage) {
            this.log((this.htmlonly ? "Creating HTML contents from " : "Extracting Java code from ") + this.texjavaList.length + " TeX file" + (this.texjavaList.length == 1 ? "" : "s"));
        }
        int n = 0;
        while (n < this.texjavaList.length) {
            if (this.texjavaList[n] != null) {
                try {
                    this.log("Processing " + this.texjavaList[n].getAbsolutePath());
                    Commandline commandline = new Commandline();
                    commandline.setExecutable("perl");
                    commandline.createArgument().setFile(this.getTexjava());
                    if (this.masterFile != null) {
                        commandline.createArgument().setValue("-master");
                        commandline.createArgument().setFile(this.masterFile);
                    }
                    commandline.createArgument().setValue(this.getHtml() ? "-html" : "-nohtml");
                    commandline.createArgument().setValue(this.getImages() ? "-images" : "-noimages");
                    commandline.createArgument().setValue(this.getSavelatex() ? "-savelatex" : "-nosavelatex");
                    if (this.getHtmloutdir() != null) {
                        commandline.createArgument().setValue("-htmloutdir");
                        commandline.createArgument().setFile(this.htmloutdir);
                    }
                    if (this.getHtmlonly()) {
                        commandline.createArgument().setValue("-htmlonly");
                        if (!this.getHtmltitle().equals("")) {
                            commandline.createArgument().setValue("-htmltitle");
                            commandline.createArgument().setValue(this.htmltitle);
                        }
                    }
                    commandline.createArgument().setFile(this.texjavaList[n]);
                    String string = this.getOverviewtopackage() && this.texjavaList[n].getName().equals("overview.tex") ? "package.html" : directoryScanner.mapFileName(this.texjavaList[n].getName())[0];
                    commandline.createArgument().setFile(new File(this.texjavaList[n].getParentFile(), string));
                    Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 3, 1));
                    execute.setAntRun(this.getProject());
                    execute.setWorkingDirectory(this.getProject().getBaseDir());
                    execute.setCommandline(commandline.getCommandline());
                    execute.execute();
                    if (execute.getExitValue() != 0) {
                        throw new BuildException("Error running texjava", this.getLocation());
                    }
                }
                catch (IOException iOException) {
                    throw new BuildException("Error running texjava", (Throwable)iOException, this.getLocation());
                }
            }
            ++n;
        }
    }

    private void resetFileLists() {
        this.texjavaList = new File[0];
    }

    private void scanDir(File file, String[] stringArray) {
        GlobPatternMapper globPatternMapper = new GlobPatternMapper();
        globPatternMapper.setFrom("*.tex");
        globPatternMapper.setTo(this.htmlonly ? "*.html" : "*.java");
        SourceFileScanner sourceFileScanner = new SourceFileScanner((Task)this);
        File[] fileArray = sourceFileScanner.restrictAsFiles(stringArray, file, file, (FileNameMapper)globPatternMapper);
        if (this.overviewtopackage) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].getName().equals("overview.tex")) {
                    long l = fileArray[n].lastModified();
                    File file2 = new File(fileArray[n].getParent(), "package.html");
                    long l2 = file2.lastModified();
                    if (l2 >= l) {
                        fileArray[n] = null;
                    }
                }
                ++n;
            }
        }
        if (fileArray.length > 0) {
            File[] fileArray2 = new File[this.texjavaList.length + fileArray.length];
            System.arraycopy(this.texjavaList, 0, fileArray2, 0, this.texjavaList.length);
            System.arraycopy(fileArray, 0, fileArray2, this.texjavaList.length, fileArray.length);
            this.texjavaList = fileArray2;
        }
    }
}

