/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.time;

import java.util.Calendar;
import java.util.Date;
import org.encog.util.time.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSpan {
    public static final int YEARS_CENTURY = 100;
    public static final int HOURS_DAY = 24;
    public static final int MINUTES_HOUR = 60;
    public static final int SECONDS_MINUTE = 60;
    public static final int MONTHS_YEAR = 12;
    public static final int DAYS_WEEK = 7;
    public static final int YEARS_MIL = 1000;
    public static final int YEARS_SCORE = 20;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Date from;
    private final Date to;

    public TimeSpan(Date date, Date date2) {
        this.from = date;
        this.to = date2;
    }

    public Date getFrom() {
        return this.from;
    }

    public long getSpan(TimeUnit timeUnit) {
        switch (timeUnit) {
            case SECONDS: {
                return this.getSpanSeconds();
            }
            case MINUTES: {
                return this.getSpanMinutes();
            }
            case HOURS: {
                return this.getSpanHours();
            }
            case DAYS: {
                return this.getSpanDays();
            }
            case WEEKS: {
                return this.getSpanWeeks();
            }
            case FORTNIGHTS: {
                return this.getSpanFortnights();
            }
            case MONTHS: {
                return this.getSpanMonths();
            }
            case YEARS: {
                return this.getSpanYears();
            }
            case SCORES: {
                return this.getSpanScores();
            }
            case CENTURIES: {
                return this.getSpanCenturies();
            }
            case MILLENNIA: {
                return this.getSpanMillennia();
            }
        }
        return 0L;
    }

    private long getSpanCenturies() {
        return this.getSpanYears() / 100L;
    }

    private long getSpanDays() {
        return this.getSpanHours() / 24L;
    }

    private long getSpanFortnights() {
        return this.getSpanWeeks() / 2L;
    }

    private long getSpanHours() {
        return this.getSpanMinutes() / 60L;
    }

    private long getSpanMillennia() {
        return this.getSpanYears() / 1000L;
    }

    private long getSpanMinutes() {
        return this.getSpanSeconds() / 60L;
    }

    private long getSpanMonths() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.from);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(this.to);
        return calendar2.get(2) - calendar.get(2) + (calendar2.get(1) - calendar.get(1)) * 12;
    }

    private long getSpanScores() {
        return this.getSpanYears() / 20L;
    }

    private long getSpanSeconds() {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(this.from);
        calendar2.setTime(this.to);
        return (calendar2.getTimeInMillis() - calendar.getTimeInMillis()) / 1000L;
    }

    private long getSpanWeeks() {
        return this.getSpanDays() / 7L;
    }

    private long getSpanYears() {
        return this.getSpanMonths() / 12L;
    }

    public Date getTo() {
        return this.to;
    }
}

